/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.mars2micrometer.marsplugin;

import com.devexperts.mars2micrometer.marsadapter.config.MicrometerMarsMetricsExporterProperties;
import com.devexperts.mars2micrometer.marsplugin.BuiltInPrometheusMeters;
import com.devexperts.mars2micrometer.marsplugin.BuiltInPrometheusMetersProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;

public class MarsToPrometheusPluginProperties {
    private final boolean pluginEnabled;
    private final MicrometerMarsMetricsExporterProperties metricsExporterProperties;
    private final BuiltInPrometheusMetersProperties builtInPrometheusMetersProperties;
    private final String prometheusEndpointHostname;
    private final int prometheusEndpointPort;

    private MarsToPrometheusPluginProperties(Builder builder) {
        this.pluginEnabled = builder.pluginEnabled;
        this.metricsExporterProperties = builder.metricsExporterProperties;
        this.builtInPrometheusMetersProperties = builder.builtInPrometheusMetersProperties;
        this.prometheusEndpointHostname = builder.prometheusEndpointHostname;
        this.prometheusEndpointPort = builder.prometheusEndpointPort;
    }

    public boolean isPluginEnabled() {
        return this.pluginEnabled;
    }

    public BuiltInPrometheusMetersProperties getBuiltInPrometheusMetersProperties() {
        return this.builtInPrometheusMetersProperties;
    }

    public MicrometerMarsMetricsExporterProperties getMetricsExporterProperties() {
        return this.metricsExporterProperties;
    }

    public String getPrometheusEndpointHostname() {
        return this.prometheusEndpointHostname;
    }

    public int getPrometheusEndpointPort() {
        return this.prometheusEndpointPort;
    }

    public String toString() {
        return "PluginProperties{pluginEnabled=" + this.pluginEnabled + ", metricsExporterProperties='" + this.metricsExporterProperties + '\'' + ", builtInPrometheusMetersProperties='" + this.builtInPrometheusMetersProperties + '\'' + ", prometheusEndpointHostname='" + this.prometheusEndpointHostname + '\'' + ", prometheusEndpointPort=" + this.prometheusEndpointPort + '}';
    }

    public static class Builder {
        private final MicrometerMarsMetricsExporterProperties metricsExporterProperties = new MicrometerMarsMetricsExporterProperties();
        private final BuiltInPrometheusMetersProperties builtInPrometheusMetersProperties = new BuiltInPrometheusMetersProperties();
        private boolean pluginEnabled = false;
        private String prometheusEndpointHostname = "localhost";
        private int prometheusEndpointPort = 8080;

        public Builder setPluginEnabled(boolean pluginEnabled) {
            this.pluginEnabled = pluginEnabled;
            return this;
        }

        public Builder setPrefixesFilter(String metricsFilter) {
            this.metricsExporterProperties.setPrefixesFilter(metricsFilter);
            return this;
        }

        public Builder setIncludeMarsRoot(boolean includeMarsRoot) {
            this.metricsExporterProperties.setIncludeMarsRoot(includeMarsRoot);
            return this;
        }

        public Builder setBuiltInPrometheusMeters(String builtInPrometheusMeters) {
            this.builtInPrometheusMetersProperties.setSupportedMarsTypes(Arrays.stream(builtInPrometheusMeters.split(",")).filter(BuiltInPrometheusMeters::checkLabel).map(BuiltInPrometheusMeters::fromLabel).collect(Collectors.toCollection(ArrayList::new)));
            return this;
        }

        public Builder setPrometheusEndpointHostname(String prometheusEndpointHostname) {
            this.prometheusEndpointHostname = Objects.requireNonNull(prometheusEndpointHostname);
            return this;
        }

        public Builder setPrometheusEndpointPort(int prometheusEndpointPort) {
            if (prometheusEndpointPort < 0 || prometheusEndpointPort > 65535) {
                throw new IllegalArgumentException("Port must be in the range between 0 and 65535");
            }
            this.prometheusEndpointPort = prometheusEndpointPort;
            return this;
        }

        public MarsToPrometheusPluginProperties build() {
            return new MarsToPrometheusPluginProperties(this);
        }
    }
}

