package com.devexperts.mdd.auth.entitle;

/**
 * QDS Connect Emulator with Auth support.
 * Use {@code -Dentitle=<issuer>,<subject>,<user>[,<feed>;<feed>...] -DentitleSecret=<secret>} to specify auth params.
 * Specify login scheme in the address: {@code dxfeed-demo:7700[login=entitle]}.
 */
public class Connect {

    public static void main(String[] args) throws Exception {
        String entitle = System.getProperty(EntitleLoginHandlerFactory.ENTITLE_SCHEME);
        String secret = System.getProperty(EntitleLoginHandlerFactory.ENTITLE_SCHEME + "Secret");

        if (entitle == null || secret == null) {
            System.err.println("No security credentials specified!");
        } else {
            String[] items = entitle.split(",", 3);
            String issuer = items[0];
            String subject = items[1];
            String user = items[2];

            String token = EntitleLoginHandlerFactory.createToken(issuer, subject, user, secret);
            EntitleLoginHandlerFactory.setAppToken(token);
        }

        com.devexperts.qd.tools.Connect.main(args);
    }
}
