/*
 * !++
 * QDS - Quick Data Signalling Library
 * !-
 * Copyright (C) 2002 - 2025 Devexperts LLC
 * !-
 * This Source Code Form is subject to the terms of the Mozilla Public License, v. 2.0.
 * If a copy of the MPL was not distributed with this file, You can obtain one at
 * http://mozilla.org/MPL/2.0/.
 * !__
 */
package com.dxfeed.event.market.impl;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.ng.RecordCursor;
import com.devexperts.qd.util.MappingUtil;
import com.devexperts.util.TimeUtil;

public class NuamOrderMapping extends OrderBaseMapping {
// BEGIN: CODE AUTOMATICALLY GENERATED: DO NOT MODIFY. IT IS REGENERATED BY com.dxfeed.api.codegen.ImplCodeGen
    private final int iIndex;
    private final int iTime;
    private final int iSequence;
    private final int iTimeNanoPart;
    private final int iActionTime;
    private final int iOrderId;
    private final int iAuxOrderId;
    private final int iPrice;
    private final int iSize;
    private final int iExecutedSize;
    private final int iCount;
    private final int iFlags;
    private final int iTradeId;
    private final int iTradePrice;
    private final int iTradeSize;
    private final int iActorId;
    private final int iParticipantId;
    private final int iSubmitterId;
    private final int iOnBehalfOfSubmitterId;
    private final int oClientOrderId;
    private final int oCustomerAccount;
    private final int oCustomerInfo;
    private final int oExchangeInfo;
    private final int iTimeInForceData;
    private final int iTriggerOrderBookId;
    private final int iTriggerPrice;
    private final int iTriggerSessionType;
    private final int iOrderQuantity;
    private final int iDisplayQuantity;
    private final int iRefreshQuantity;
    private final int iLeavesQuantity;
    private final int iMatchedQuantity;
    private final int iNuamFlags;

    public NuamOrderMapping(DataRecord record) {
        super(record);
        iIndex = MappingUtil.findIntField(record, "Index", true);
        iTime = MappingUtil.findIntField(record, "Time", true);
        iSequence = MappingUtil.findIntField(record, "Sequence", true);
        iTimeNanoPart = MappingUtil.findIntField(record, "TimeNanoPart", false);
        iActionTime = MappingUtil.findIntField(record, "ActionTime", false);
        iOrderId = MappingUtil.findIntField(record, "OrderId", false);
        iAuxOrderId = MappingUtil.findIntField(record, "AuxOrderId", false);
        iPrice = findIntField("Price", true);
        iSize = findIntField("Size", true);
        iExecutedSize = findIntField("ExecutedSize", false);
        iCount = findIntField("Count", false);
        iFlags = MappingUtil.findIntField(record, "Flags", true);
        iTradeId = MappingUtil.findIntField(record, "TradeId", false);
        iTradePrice = findIntField("TradePrice", false);
        iTradeSize = findIntField("TradeSize", false);
        iActorId = MappingUtil.findIntField(record, "ActorId", true);
        iParticipantId = MappingUtil.findIntField(record, "ParticipantId", true);
        iSubmitterId = MappingUtil.findIntField(record, "SubmitterId", true);
        iOnBehalfOfSubmitterId = MappingUtil.findIntField(record, "OnBehalfOfSubmitterId", true);
        oClientOrderId = MappingUtil.findObjField(record, "ClientOrderId", true);
        oCustomerAccount = MappingUtil.findObjField(record, "CustomerAccount", true);
        oCustomerInfo = MappingUtil.findObjField(record, "CustomerInfo", true);
        oExchangeInfo = MappingUtil.findObjField(record, "ExchangeInfo", true);
        iTimeInForceData = MappingUtil.findIntField(record, "TimeInForceData", true);
        iTriggerOrderBookId = MappingUtil.findIntField(record, "TriggerOrderBookId", true);
        iTriggerPrice = findIntField("TriggerPrice", true);
        iTriggerSessionType = MappingUtil.findIntField(record, "TriggerSessionType", true);
        iOrderQuantity = findIntField("OrderQuantity", true);
        iDisplayQuantity = findIntField("DisplayQuantity", true);
        iRefreshQuantity = findIntField("RefreshQuantity", true);
        iLeavesQuantity = findIntField("LeavesQuantity", true);
        iMatchedQuantity = findIntField("MatchedQuantity", true);
        iNuamFlags = MappingUtil.findIntField(record, "NuamFlags", true);
    }

    public int getIndex(RecordCursor cursor) {
        return getInt(cursor, iIndex);
    }

    public void setIndex(RecordCursor cursor, int index) {
        setInt(cursor, iIndex, index);
    }

    public long getTimeMillis(RecordCursor cursor) {
        return getInt(cursor, iTime) * 1000L;
    }

    public void setTimeMillis(RecordCursor cursor, long time) {
        setInt(cursor, iTime, TimeUtil.getSecondsFromTime(time));
    }

    public int getTimeSeconds(RecordCursor cursor) {
        return getInt(cursor, iTime);
    }

    public void setTimeSeconds(RecordCursor cursor, int time) {
        setInt(cursor, iTime, time);
    }

    public int getSequence(RecordCursor cursor) {
        return getInt(cursor, iSequence);
    }

    public void setSequence(RecordCursor cursor, int sequence) {
        setInt(cursor, iSequence, sequence);
    }

    public int getTimeNanoPart(RecordCursor cursor) {
        if (iTimeNanoPart < 0)
            return 0;
        return getInt(cursor, iTimeNanoPart);
    }

    public void setTimeNanoPart(RecordCursor cursor, int timeNanoPart) {
        if (iTimeNanoPart < 0)
            return;
        setInt(cursor, iTimeNanoPart, timeNanoPart);
    }

    public long getActionTimeMillis(RecordCursor cursor) {
        if (iActionTime < 0)
            return 0;
        return getLong(cursor, iActionTime);
    }

    public void setActionTimeMillis(RecordCursor cursor, long actionTime) {
        if (iActionTime < 0)
            return;
        setLong(cursor, iActionTime, actionTime);
    }

    public int getActionTimeSeconds(RecordCursor cursor) {
        if (iActionTime < 0)
            return 0;
        return TimeUtil.getSecondsFromTime(getLong(cursor, iActionTime));
    }

    public void setActionTimeSeconds(RecordCursor cursor, int actionTime) {
        if (iActionTime < 0)
            return;
        setLong(cursor, iActionTime, actionTime * 1000L);
    }

    public long getOrderId(RecordCursor cursor) {
        if (iOrderId < 0)
            return 0;
        return getLong(cursor, iOrderId);
    }

    public void setOrderId(RecordCursor cursor, long orderId) {
        if (iOrderId < 0)
            return;
        setLong(cursor, iOrderId, orderId);
    }

    public long getAuxOrderId(RecordCursor cursor) {
        if (iAuxOrderId < 0)
            return 0;
        return getLong(cursor, iAuxOrderId);
    }

    public void setAuxOrderId(RecordCursor cursor, long auxOrderId) {
        if (iAuxOrderId < 0)
            return;
        setLong(cursor, iAuxOrderId, auxOrderId);
    }

    public double getPrice(RecordCursor cursor) {
        return getAsDouble(cursor, iPrice);
    }

    public void setPrice(RecordCursor cursor, double price) {
        setAsDouble(cursor, iPrice, price);
    }

    public int getPriceDecimal(RecordCursor cursor) {
        return getAsTinyDecimal(cursor, iPrice);
    }

    public void setPriceDecimal(RecordCursor cursor, int price) {
        setAsTinyDecimal(cursor, iPrice, price);
    }

    public long getPriceWideDecimal(RecordCursor cursor) {
        return getAsWideDecimal(cursor, iPrice);
    }

    public void setPriceWideDecimal(RecordCursor cursor, long price) {
        setAsWideDecimal(cursor, iPrice, price);
    }

    public int getSize(RecordCursor cursor) {
        return getAsInt(cursor, iSize);
    }

    public void setSize(RecordCursor cursor, int size) {
        setAsInt(cursor, iSize, size);
    }

    public long getSizeLong(RecordCursor cursor) {
        return getAsLong(cursor, iSize);
    }

    public void setSizeLong(RecordCursor cursor, long size) {
        setAsLong(cursor, iSize, size);
    }

    public double getSizeDouble(RecordCursor cursor) {
        return getAsDouble(cursor, iSize);
    }

    public void setSizeDouble(RecordCursor cursor, double size) {
        setAsDouble(cursor, iSize, size);
    }

    public int getSizeDecimal(RecordCursor cursor) {
        return getAsTinyDecimal(cursor, iSize);
    }

    public void setSizeDecimal(RecordCursor cursor, int size) {
        setAsTinyDecimal(cursor, iSize, size);
    }

    public long getSizeWideDecimal(RecordCursor cursor) {
        return getAsWideDecimal(cursor, iSize);
    }

    public void setSizeWideDecimal(RecordCursor cursor, long size) {
        setAsWideDecimal(cursor, iSize, size);
    }

    public double getExecutedSize(RecordCursor cursor) {
        if (iExecutedSize < 0)
            return Double.NaN;
        return getAsDouble(cursor, iExecutedSize);
    }

    public void setExecutedSize(RecordCursor cursor, double executedSize) {
        if (iExecutedSize < 0)
            return;
        setAsDouble(cursor, iExecutedSize, executedSize);
    }

    public int getExecutedSizeDecimal(RecordCursor cursor) {
        if (iExecutedSize < 0)
            return 0;
        return getAsTinyDecimal(cursor, iExecutedSize);
    }

    public void setExecutedSizeDecimal(RecordCursor cursor, int executedSize) {
        if (iExecutedSize < 0)
            return;
        setAsTinyDecimal(cursor, iExecutedSize, executedSize);
    }

    public long getExecutedSizeWideDecimal(RecordCursor cursor) {
        if (iExecutedSize < 0)
            return 0;
        return getAsWideDecimal(cursor, iExecutedSize);
    }

    public void setExecutedSizeWideDecimal(RecordCursor cursor, long executedSize) {
        if (iExecutedSize < 0)
            return;
        setAsWideDecimal(cursor, iExecutedSize, executedSize);
    }

    public int getCount(RecordCursor cursor) {
        if (iCount < 0)
            return 0;
        return getAsInt(cursor, iCount);
    }

    public void setCount(RecordCursor cursor, int count) {
        if (iCount < 0)
            return;
        setAsInt(cursor, iCount, count);
    }

    public long getCountLong(RecordCursor cursor) {
        if (iCount < 0)
            return 0;
        return getAsLong(cursor, iCount);
    }

    public void setCountLong(RecordCursor cursor, long count) {
        if (iCount < 0)
            return;
        setAsLong(cursor, iCount, count);
    }

    public double getCountDouble(RecordCursor cursor) {
        if (iCount < 0)
            return Double.NaN;
        return getAsDouble(cursor, iCount);
    }

    public void setCountDouble(RecordCursor cursor, double count) {
        if (iCount < 0)
            return;
        setAsDouble(cursor, iCount, count);
    }

    public int getCountDecimal(RecordCursor cursor) {
        if (iCount < 0)
            return 0;
        return getAsTinyDecimal(cursor, iCount);
    }

    public void setCountDecimal(RecordCursor cursor, int count) {
        if (iCount < 0)
            return;
        setAsTinyDecimal(cursor, iCount, count);
    }

    public long getCountWideDecimal(RecordCursor cursor) {
        if (iCount < 0)
            return 0;
        return getAsWideDecimal(cursor, iCount);
    }

    public void setCountWideDecimal(RecordCursor cursor, long count) {
        if (iCount < 0)
            return;
        setAsWideDecimal(cursor, iCount, count);
    }

    public int getFlags(RecordCursor cursor) {
        return getInt(cursor, iFlags);
    }

    public void setFlags(RecordCursor cursor, int flags) {
        setInt(cursor, iFlags, flags);
    }

    public long getTradeId(RecordCursor cursor) {
        if (iTradeId < 0)
            return 0;
        return getLong(cursor, iTradeId);
    }

    public void setTradeId(RecordCursor cursor, long tradeId) {
        if (iTradeId < 0)
            return;
        setLong(cursor, iTradeId, tradeId);
    }

    public double getTradePrice(RecordCursor cursor) {
        if (iTradePrice < 0)
            return Double.NaN;
        return getAsDouble(cursor, iTradePrice);
    }

    public void setTradePrice(RecordCursor cursor, double tradePrice) {
        if (iTradePrice < 0)
            return;
        setAsDouble(cursor, iTradePrice, tradePrice);
    }

    public int getTradePriceDecimal(RecordCursor cursor) {
        if (iTradePrice < 0)
            return 0;
        return getAsTinyDecimal(cursor, iTradePrice);
    }

    public void setTradePriceDecimal(RecordCursor cursor, int tradePrice) {
        if (iTradePrice < 0)
            return;
        setAsTinyDecimal(cursor, iTradePrice, tradePrice);
    }

    public long getTradePriceWideDecimal(RecordCursor cursor) {
        if (iTradePrice < 0)
            return 0;
        return getAsWideDecimal(cursor, iTradePrice);
    }

    public void setTradePriceWideDecimal(RecordCursor cursor, long tradePrice) {
        if (iTradePrice < 0)
            return;
        setAsWideDecimal(cursor, iTradePrice, tradePrice);
    }

    public double getTradeSize(RecordCursor cursor) {
        if (iTradeSize < 0)
            return Double.NaN;
        return getAsDouble(cursor, iTradeSize);
    }

    public void setTradeSize(RecordCursor cursor, double tradeSize) {
        if (iTradeSize < 0)
            return;
        setAsDouble(cursor, iTradeSize, tradeSize);
    }

    public int getTradeSizeDecimal(RecordCursor cursor) {
        if (iTradeSize < 0)
            return 0;
        return getAsTinyDecimal(cursor, iTradeSize);
    }

    public void setTradeSizeDecimal(RecordCursor cursor, int tradeSize) {
        if (iTradeSize < 0)
            return;
        setAsTinyDecimal(cursor, iTradeSize, tradeSize);
    }

    public long getTradeSizeWideDecimal(RecordCursor cursor) {
        if (iTradeSize < 0)
            return 0;
        return getAsWideDecimal(cursor, iTradeSize);
    }

    public void setTradeSizeWideDecimal(RecordCursor cursor, long tradeSize) {
        if (iTradeSize < 0)
            return;
        setAsWideDecimal(cursor, iTradeSize, tradeSize);
    }

    public int getActorId(RecordCursor cursor) {
        return getInt(cursor, iActorId);
    }

    public void setActorId(RecordCursor cursor, int actorId) {
        setInt(cursor, iActorId, actorId);
    }

    public int getParticipantId(RecordCursor cursor) {
        return getInt(cursor, iParticipantId);
    }

    public void setParticipantId(RecordCursor cursor, int participantId) {
        setInt(cursor, iParticipantId, participantId);
    }

    public int getSubmitterId(RecordCursor cursor) {
        return getInt(cursor, iSubmitterId);
    }

    public void setSubmitterId(RecordCursor cursor, int submitterId) {
        setInt(cursor, iSubmitterId, submitterId);
    }

    public int getOnBehalfOfSubmitterId(RecordCursor cursor) {
        return getInt(cursor, iOnBehalfOfSubmitterId);
    }

    public void setOnBehalfOfSubmitterId(RecordCursor cursor, int onBehalfOfSubmitterId) {
        setInt(cursor, iOnBehalfOfSubmitterId, onBehalfOfSubmitterId);
    }

    public String getClientOrderId(RecordCursor cursor) {
        return (String) getObj(cursor, oClientOrderId);
    }

    public void setClientOrderId(RecordCursor cursor, String clientOrderId) {
        setObj(cursor, oClientOrderId, clientOrderId);
    }

    public String getCustomerAccount(RecordCursor cursor) {
        return (String) getObj(cursor, oCustomerAccount);
    }

    public void setCustomerAccount(RecordCursor cursor, String customerAccount) {
        setObj(cursor, oCustomerAccount, customerAccount);
    }

    public String getCustomerInfo(RecordCursor cursor) {
        return (String) getObj(cursor, oCustomerInfo);
    }

    public void setCustomerInfo(RecordCursor cursor, String customerInfo) {
        setObj(cursor, oCustomerInfo, customerInfo);
    }

    public String getExchangeInfo(RecordCursor cursor) {
        return (String) getObj(cursor, oExchangeInfo);
    }

    public void setExchangeInfo(RecordCursor cursor, String exchangeInfo) {
        setObj(cursor, oExchangeInfo, exchangeInfo);
    }

    public int getTimeInForceData(RecordCursor cursor) {
        return getInt(cursor, iTimeInForceData);
    }

    public void setTimeInForceData(RecordCursor cursor, int timeInForceData) {
        setInt(cursor, iTimeInForceData, timeInForceData);
    }

    public int getTriggerOrderBookId(RecordCursor cursor) {
        return getInt(cursor, iTriggerOrderBookId);
    }

    public void setTriggerOrderBookId(RecordCursor cursor, int triggerOrderBookId) {
        setInt(cursor, iTriggerOrderBookId, triggerOrderBookId);
    }

    public double getTriggerPrice(RecordCursor cursor) {
        return getAsDouble(cursor, iTriggerPrice);
    }

    public void setTriggerPrice(RecordCursor cursor, double triggerPrice) {
        setAsDouble(cursor, iTriggerPrice, triggerPrice);
    }

    public int getTriggerPriceDecimal(RecordCursor cursor) {
        return getAsTinyDecimal(cursor, iTriggerPrice);
    }

    public void setTriggerPriceDecimal(RecordCursor cursor, int triggerPrice) {
        setAsTinyDecimal(cursor, iTriggerPrice, triggerPrice);
    }

    public long getTriggerPriceWideDecimal(RecordCursor cursor) {
        return getAsWideDecimal(cursor, iTriggerPrice);
    }

    public void setTriggerPriceWideDecimal(RecordCursor cursor, long triggerPrice) {
        setAsWideDecimal(cursor, iTriggerPrice, triggerPrice);
    }

    public int getTriggerSessionType(RecordCursor cursor) {
        return getInt(cursor, iTriggerSessionType);
    }

    public void setTriggerSessionType(RecordCursor cursor, int triggerSessionType) {
        setInt(cursor, iTriggerSessionType, triggerSessionType);
    }

    public int getOrderQuantity(RecordCursor cursor) {
        return getAsInt(cursor, iOrderQuantity);
    }

    public void setOrderQuantity(RecordCursor cursor, int orderQuantity) {
        setAsInt(cursor, iOrderQuantity, orderQuantity);
    }

    public long getOrderQuantityLong(RecordCursor cursor) {
        return getAsLong(cursor, iOrderQuantity);
    }

    public void setOrderQuantityLong(RecordCursor cursor, long orderQuantity) {
        setAsLong(cursor, iOrderQuantity, orderQuantity);
    }

    public double getOrderQuantityDouble(RecordCursor cursor) {
        return getAsDouble(cursor, iOrderQuantity);
    }

    public void setOrderQuantityDouble(RecordCursor cursor, double orderQuantity) {
        setAsDouble(cursor, iOrderQuantity, orderQuantity);
    }

    public int getOrderQuantityDecimal(RecordCursor cursor) {
        return getAsTinyDecimal(cursor, iOrderQuantity);
    }

    public void setOrderQuantityDecimal(RecordCursor cursor, int orderQuantity) {
        setAsTinyDecimal(cursor, iOrderQuantity, orderQuantity);
    }

    public long getOrderQuantityWideDecimal(RecordCursor cursor) {
        return getAsWideDecimal(cursor, iOrderQuantity);
    }

    public void setOrderQuantityWideDecimal(RecordCursor cursor, long orderQuantity) {
        setAsWideDecimal(cursor, iOrderQuantity, orderQuantity);
    }

    public int getDisplayQuantity(RecordCursor cursor) {
        return getAsInt(cursor, iDisplayQuantity);
    }

    public void setDisplayQuantity(RecordCursor cursor, int displayQuantity) {
        setAsInt(cursor, iDisplayQuantity, displayQuantity);
    }

    public long getDisplayQuantityLong(RecordCursor cursor) {
        return getAsLong(cursor, iDisplayQuantity);
    }

    public void setDisplayQuantityLong(RecordCursor cursor, long displayQuantity) {
        setAsLong(cursor, iDisplayQuantity, displayQuantity);
    }

    public double getDisplayQuantityDouble(RecordCursor cursor) {
        return getAsDouble(cursor, iDisplayQuantity);
    }

    public void setDisplayQuantityDouble(RecordCursor cursor, double displayQuantity) {
        setAsDouble(cursor, iDisplayQuantity, displayQuantity);
    }

    public int getDisplayQuantityDecimal(RecordCursor cursor) {
        return getAsTinyDecimal(cursor, iDisplayQuantity);
    }

    public void setDisplayQuantityDecimal(RecordCursor cursor, int displayQuantity) {
        setAsTinyDecimal(cursor, iDisplayQuantity, displayQuantity);
    }

    public long getDisplayQuantityWideDecimal(RecordCursor cursor) {
        return getAsWideDecimal(cursor, iDisplayQuantity);
    }

    public void setDisplayQuantityWideDecimal(RecordCursor cursor, long displayQuantity) {
        setAsWideDecimal(cursor, iDisplayQuantity, displayQuantity);
    }

    public int getRefreshQuantity(RecordCursor cursor) {
        return getAsInt(cursor, iRefreshQuantity);
    }

    public void setRefreshQuantity(RecordCursor cursor, int refreshQuantity) {
        setAsInt(cursor, iRefreshQuantity, refreshQuantity);
    }

    public long getRefreshQuantityLong(RecordCursor cursor) {
        return getAsLong(cursor, iRefreshQuantity);
    }

    public void setRefreshQuantityLong(RecordCursor cursor, long refreshQuantity) {
        setAsLong(cursor, iRefreshQuantity, refreshQuantity);
    }

    public double getRefreshQuantityDouble(RecordCursor cursor) {
        return getAsDouble(cursor, iRefreshQuantity);
    }

    public void setRefreshQuantityDouble(RecordCursor cursor, double refreshQuantity) {
        setAsDouble(cursor, iRefreshQuantity, refreshQuantity);
    }

    public int getRefreshQuantityDecimal(RecordCursor cursor) {
        return getAsTinyDecimal(cursor, iRefreshQuantity);
    }

    public void setRefreshQuantityDecimal(RecordCursor cursor, int refreshQuantity) {
        setAsTinyDecimal(cursor, iRefreshQuantity, refreshQuantity);
    }

    public long getRefreshQuantityWideDecimal(RecordCursor cursor) {
        return getAsWideDecimal(cursor, iRefreshQuantity);
    }

    public void setRefreshQuantityWideDecimal(RecordCursor cursor, long refreshQuantity) {
        setAsWideDecimal(cursor, iRefreshQuantity, refreshQuantity);
    }

    public int getLeavesQuantity(RecordCursor cursor) {
        return getAsInt(cursor, iLeavesQuantity);
    }

    public void setLeavesQuantity(RecordCursor cursor, int leavesQuantity) {
        setAsInt(cursor, iLeavesQuantity, leavesQuantity);
    }

    public long getLeavesQuantityLong(RecordCursor cursor) {
        return getAsLong(cursor, iLeavesQuantity);
    }

    public void setLeavesQuantityLong(RecordCursor cursor, long leavesQuantity) {
        setAsLong(cursor, iLeavesQuantity, leavesQuantity);
    }

    public double getLeavesQuantityDouble(RecordCursor cursor) {
        return getAsDouble(cursor, iLeavesQuantity);
    }

    public void setLeavesQuantityDouble(RecordCursor cursor, double leavesQuantity) {
        setAsDouble(cursor, iLeavesQuantity, leavesQuantity);
    }

    public int getLeavesQuantityDecimal(RecordCursor cursor) {
        return getAsTinyDecimal(cursor, iLeavesQuantity);
    }

    public void setLeavesQuantityDecimal(RecordCursor cursor, int leavesQuantity) {
        setAsTinyDecimal(cursor, iLeavesQuantity, leavesQuantity);
    }

    public long getLeavesQuantityWideDecimal(RecordCursor cursor) {
        return getAsWideDecimal(cursor, iLeavesQuantity);
    }

    public void setLeavesQuantityWideDecimal(RecordCursor cursor, long leavesQuantity) {
        setAsWideDecimal(cursor, iLeavesQuantity, leavesQuantity);
    }

    public int getMatchedQuantity(RecordCursor cursor) {
        return getAsInt(cursor, iMatchedQuantity);
    }

    public void setMatchedQuantity(RecordCursor cursor, int matchedQuantity) {
        setAsInt(cursor, iMatchedQuantity, matchedQuantity);
    }

    public long getMatchedQuantityLong(RecordCursor cursor) {
        return getAsLong(cursor, iMatchedQuantity);
    }

    public void setMatchedQuantityLong(RecordCursor cursor, long matchedQuantity) {
        setAsLong(cursor, iMatchedQuantity, matchedQuantity);
    }

    public double getMatchedQuantityDouble(RecordCursor cursor) {
        return getAsDouble(cursor, iMatchedQuantity);
    }

    public void setMatchedQuantityDouble(RecordCursor cursor, double matchedQuantity) {
        setAsDouble(cursor, iMatchedQuantity, matchedQuantity);
    }

    public int getMatchedQuantityDecimal(RecordCursor cursor) {
        return getAsTinyDecimal(cursor, iMatchedQuantity);
    }

    public void setMatchedQuantityDecimal(RecordCursor cursor, int matchedQuantity) {
        setAsTinyDecimal(cursor, iMatchedQuantity, matchedQuantity);
    }

    public long getMatchedQuantityWideDecimal(RecordCursor cursor) {
        return getAsWideDecimal(cursor, iMatchedQuantity);
    }

    public void setMatchedQuantityWideDecimal(RecordCursor cursor, long matchedQuantity) {
        setAsWideDecimal(cursor, iMatchedQuantity, matchedQuantity);
    }

    public int getNuamFlags(RecordCursor cursor) {
        return getInt(cursor, iNuamFlags);
    }

    public void setNuamFlags(RecordCursor cursor, int nuamFlags) {
        setInt(cursor, iNuamFlags, nuamFlags);
    }
// END: CODE AUTOMATICALLY GENERATED
}
