/*
 * !++
 * QDS - Quick Data Signalling Library
 * !-
 * Copyright (C) 2002 - 2021 Devexperts LLC
 * !-
 * This Source Code Form is subject to the terms of the Mozilla Public License, v. 2.0.
 * If a copy of the MPL was not distributed with this file, You can obtain one at
 * http://mozilla.org/MPL/2.0/.
 * !__
 */
package com.dxfeed.event.option.impl;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.ng.RecordCursor;
import com.devexperts.qd.ng.RecordMapping;
import com.devexperts.qd.util.MappingUtil;
import com.devexperts.util.TimeUtil;

public class GreeksMapping extends RecordMapping {
// BEGIN: CODE AUTOMATICALLY GENERATED: DO NOT MODIFY. IT IS REGENERATED BY com.dxfeed.api.codegen.ImplCodeGen
    private final int iTime;
    private final int iSequence;
    private final int iPrice;
    private final int iVolatility;
    private final int iDelta;
    private final int iGamma;
    private final int iTheta;
    private final int iRho;
    private final int iVega;

    public GreeksMapping(DataRecord record) {
        super(record);
        iTime = MappingUtil.findIntField(record, "Time", false);
        iSequence = MappingUtil.findIntField(record, "Sequence", false);
        iPrice = findIntField("Greeks.Price", true);
        iVolatility = findIntField("Volatility", true);
        iDelta = findIntField("Delta", true);
        iGamma = findIntField("Gamma", true);
        iTheta = findIntField("Theta", true);
        iRho = findIntField("Rho", true);
        iVega = findIntField("Vega", true);
        putNonDefaultPropertyName("Greeks.Price", "Price");
    }

    public long getTimeMillis(RecordCursor cursor) {
        if (iTime < 0)
            return 0;
        return getInt(cursor, iTime) * 1000L;
    }

    public void setTimeMillis(RecordCursor cursor, long time) {
        if (iTime < 0)
            return;
        setInt(cursor, iTime, TimeUtil.getSecondsFromTime(time));
    }

    public int getTimeSeconds(RecordCursor cursor) {
        if (iTime < 0)
            return 0;
        return getInt(cursor, iTime);
    }

    public void setTimeSeconds(RecordCursor cursor, int time) {
        if (iTime < 0)
            return;
        setInt(cursor, iTime, time);
    }

    public int getSequence(RecordCursor cursor) {
        if (iSequence < 0)
            return 0;
        return getInt(cursor, iSequence);
    }

    public void setSequence(RecordCursor cursor, int sequence) {
        if (iSequence < 0)
            return;
        setInt(cursor, iSequence, sequence);
    }

    @Deprecated
    public double getGreeksPrice(RecordCursor cursor) {
        return getAsDouble(cursor, iPrice);
    }

    @Deprecated
    public void setGreeksPrice(RecordCursor cursor, double greeksPrice) {
        setAsDouble(cursor, iPrice, greeksPrice);
    }

    @Deprecated
    public int getGreeksPriceDecimal(RecordCursor cursor) {
        return getAsTinyDecimal(cursor, iPrice);
    }

    @Deprecated
    public void setGreeksPriceDecimal(RecordCursor cursor, int greeksPrice) {
        setAsTinyDecimal(cursor, iPrice, greeksPrice);
    }

    @Deprecated
    public long getGreeksPriceWideDecimal(RecordCursor cursor) {
        return getAsWideDecimal(cursor, iPrice);
    }

    @Deprecated
    public void setGreeksPriceWideDecimal(RecordCursor cursor, long greeksPrice) {
        setAsWideDecimal(cursor, iPrice, greeksPrice);
    }

    public double getPrice(RecordCursor cursor) {
        return getAsDouble(cursor, iPrice);
    }

    public void setPrice(RecordCursor cursor, double price) {
        setAsDouble(cursor, iPrice, price);
    }

    public int getPriceDecimal(RecordCursor cursor) {
        return getAsTinyDecimal(cursor, iPrice);
    }

    public void setPriceDecimal(RecordCursor cursor, int price) {
        setAsTinyDecimal(cursor, iPrice, price);
    }

    public long getPriceWideDecimal(RecordCursor cursor) {
        return getAsWideDecimal(cursor, iPrice);
    }

    public void setPriceWideDecimal(RecordCursor cursor, long price) {
        setAsWideDecimal(cursor, iPrice, price);
    }

    public double getVolatility(RecordCursor cursor) {
        return getAsDouble(cursor, iVolatility);
    }

    public void setVolatility(RecordCursor cursor, double volatility) {
        setAsDouble(cursor, iVolatility, volatility);
    }

    public int getVolatilityDecimal(RecordCursor cursor) {
        return getAsTinyDecimal(cursor, iVolatility);
    }

    public void setVolatilityDecimal(RecordCursor cursor, int volatility) {
        setAsTinyDecimal(cursor, iVolatility, volatility);
    }

    public long getVolatilityWideDecimal(RecordCursor cursor) {
        return getAsWideDecimal(cursor, iVolatility);
    }

    public void setVolatilityWideDecimal(RecordCursor cursor, long volatility) {
        setAsWideDecimal(cursor, iVolatility, volatility);
    }

    public double getDelta(RecordCursor cursor) {
        return getAsDouble(cursor, iDelta);
    }

    public void setDelta(RecordCursor cursor, double delta) {
        setAsDouble(cursor, iDelta, delta);
    }

    public int getDeltaDecimal(RecordCursor cursor) {
        return getAsTinyDecimal(cursor, iDelta);
    }

    public void setDeltaDecimal(RecordCursor cursor, int delta) {
        setAsTinyDecimal(cursor, iDelta, delta);
    }

    public long getDeltaWideDecimal(RecordCursor cursor) {
        return getAsWideDecimal(cursor, iDelta);
    }

    public void setDeltaWideDecimal(RecordCursor cursor, long delta) {
        setAsWideDecimal(cursor, iDelta, delta);
    }

    public double getGamma(RecordCursor cursor) {
        return getAsDouble(cursor, iGamma);
    }

    public void setGamma(RecordCursor cursor, double gamma) {
        setAsDouble(cursor, iGamma, gamma);
    }

    public int getGammaDecimal(RecordCursor cursor) {
        return getAsTinyDecimal(cursor, iGamma);
    }

    public void setGammaDecimal(RecordCursor cursor, int gamma) {
        setAsTinyDecimal(cursor, iGamma, gamma);
    }

    public long getGammaWideDecimal(RecordCursor cursor) {
        return getAsWideDecimal(cursor, iGamma);
    }

    public void setGammaWideDecimal(RecordCursor cursor, long gamma) {
        setAsWideDecimal(cursor, iGamma, gamma);
    }

    public double getTheta(RecordCursor cursor) {
        return getAsDouble(cursor, iTheta);
    }

    public void setTheta(RecordCursor cursor, double theta) {
        setAsDouble(cursor, iTheta, theta);
    }

    public int getThetaDecimal(RecordCursor cursor) {
        return getAsTinyDecimal(cursor, iTheta);
    }

    public void setThetaDecimal(RecordCursor cursor, int theta) {
        setAsTinyDecimal(cursor, iTheta, theta);
    }

    public long getThetaWideDecimal(RecordCursor cursor) {
        return getAsWideDecimal(cursor, iTheta);
    }

    public void setThetaWideDecimal(RecordCursor cursor, long theta) {
        setAsWideDecimal(cursor, iTheta, theta);
    }

    public double getRho(RecordCursor cursor) {
        return getAsDouble(cursor, iRho);
    }

    public void setRho(RecordCursor cursor, double rho) {
        setAsDouble(cursor, iRho, rho);
    }

    public int getRhoDecimal(RecordCursor cursor) {
        return getAsTinyDecimal(cursor, iRho);
    }

    public void setRhoDecimal(RecordCursor cursor, int rho) {
        setAsTinyDecimal(cursor, iRho, rho);
    }

    public long getRhoWideDecimal(RecordCursor cursor) {
        return getAsWideDecimal(cursor, iRho);
    }

    public void setRhoWideDecimal(RecordCursor cursor, long rho) {
        setAsWideDecimal(cursor, iRho, rho);
    }

    public double getVega(RecordCursor cursor) {
        return getAsDouble(cursor, iVega);
    }

    public void setVega(RecordCursor cursor, double vega) {
        setAsDouble(cursor, iVega, vega);
    }

    public int getVegaDecimal(RecordCursor cursor) {
        return getAsTinyDecimal(cursor, iVega);
    }

    public void setVegaDecimal(RecordCursor cursor, int vega) {
        setAsTinyDecimal(cursor, iVega, vega);
    }

    public long getVegaWideDecimal(RecordCursor cursor) {
        return getAsWideDecimal(cursor, iVega);
    }

    public void setVegaWideDecimal(RecordCursor cursor, long vega) {
        setAsWideDecimal(cursor, iVega, vega);
    }
// END: CODE AUTOMATICALLY GENERATED
}
