/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.api.test;

import com.devexperts.test.ThreadCleanCheck;
import com.devexperts.util.TimeFormat;
import com.dxfeed.api.DXEndpoint;
import com.dxfeed.api.DXFeed;
import com.dxfeed.api.DXFeedSubscription;
import com.dxfeed.api.DXPublisher;
import com.dxfeed.api.osub.TimeSeriesSubscriptionSymbol;
import com.dxfeed.event.IndexedEventSource;
import com.dxfeed.event.LastingEvent;
import com.dxfeed.event.candle.Candle;
import com.dxfeed.event.candle.CandlePeriod;
import com.dxfeed.event.candle.CandleSymbol;
import com.dxfeed.event.candle.CandleSymbolAttribute;
import com.dxfeed.event.market.Order;
import com.dxfeed.event.market.OrderSource;
import com.dxfeed.event.market.Quote;
import com.dxfeed.event.market.Side;
import java.util.Collections;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DXFeedGetIfSubscribedTest {
    private static final String SYMBOL = "IBM";
    private static final CandleSymbol CANDLE_SYMBOL = CandleSymbol.valueOf((String)"IBM", (CandleSymbolAttribute)CandlePeriod.DAY);
    private DXEndpoint endpoint;
    private DXFeed feed;
    private DXPublisher publisher;

    @Before
    public void setUp() throws Exception {
        ThreadCleanCheck.before();
        this.endpoint = DXEndpoint.create((DXEndpoint.Role)DXEndpoint.Role.LOCAL_HUB);
        this.feed = this.endpoint.getFeed();
        this.publisher = this.endpoint.getPublisher();
    }

    @After
    public void tearDown() throws Exception {
        this.endpoint.close();
    }

    @Test
    public void testGetLast() {
        Quote q = new Quote(SYMBOL);
        Assert.assertSame((Object)q, (Object)this.feed.getLastEvent((LastingEvent)q));
        this.assertEmpty(q);
        q = (Quote)this.feed.getLastEventIfSubscribed(Quote.class, (Object)SYMBOL);
        Assert.assertNull((Object)q);
        DXFeedSubscription sub = this.feed.createSubscription(Quote.class);
        sub.addSymbols((Object)SYMBOL);
        q = (Quote)this.feed.getLastEventIfSubscribed(Quote.class, (Object)SYMBOL);
        Assert.assertNotNull((Object)q);
        this.assertEmpty(q);
        q = new Quote(SYMBOL);
        q.setAskPrice(10.5);
        this.publisher.publishEvents(Collections.singletonList(q));
        q = (Quote)this.feed.getLastEventIfSubscribed(Quote.class, (Object)SYMBOL);
        Assert.assertNotNull((Object)q);
        Assert.assertEquals((double)10.5, (double)q.getAskPrice(), (double)0.0);
        q.setAskPrice(Double.NaN);
        this.assertEmpty(q);
    }

    private void assertEmpty(Quote q) {
        Quote e = new Quote(SYMBOL);
        Assert.assertEquals((Object)e.getEventSymbol(), (Object)q.getEventSymbol());
        Assert.assertEquals((double)e.getBidPrice(), (double)q.getBidPrice(), (double)0.0);
        Assert.assertEquals((long)e.getBidSize(), (long)q.getBidSize());
        Assert.assertEquals((long)e.getBidTime(), (long)q.getBidTime());
        Assert.assertEquals((long)e.getBidExchangeCode(), (long)q.getBidExchangeCode());
        Assert.assertEquals((double)e.getAskPrice(), (double)q.getAskPrice(), (double)0.0);
        Assert.assertEquals((long)e.getAskSize(), (long)q.getAskSize());
        Assert.assertEquals((long)e.getAskTime(), (long)q.getAskTime());
        Assert.assertEquals((long)e.getAskExchangeCode(), (long)q.getAskExchangeCode());
    }

    @Test
    public void testGetIndexed() {
        List os = this.feed.getIndexedEventsIfSubscribed(Order.class, (Object)SYMBOL, (IndexedEventSource)OrderSource.DEFAULT);
        Assert.assertNull((Object)os);
        DXFeedSubscription sub = this.feed.createSubscription(Order.class);
        sub.addSymbols((Object)SYMBOL);
        os = this.feed.getIndexedEventsIfSubscribed(Order.class, (Object)SYMBOL, (IndexedEventSource)OrderSource.DEFAULT);
        Assert.assertNotNull((Object)os);
        Assert.assertTrue((boolean)os.isEmpty());
        Order o = new Order(SYMBOL);
        o.setIndex(1L);
        o.setOrderSide(Side.BUY);
        o.setPrice(10.5);
        o.setSize(100L);
        this.publisher.publishEvents(Collections.singletonList(o));
        os = this.feed.getIndexedEventsIfSubscribed(Order.class, (Object)SYMBOL, (IndexedEventSource)OrderSource.DEFAULT);
        Assert.assertNotNull((Object)os);
        Assert.assertEquals((long)1L, (long)os.size());
        o = (Order)os.get(0);
        Assert.assertEquals((long)1L, (long)o.getIndex());
        Assert.assertEquals((Object)Side.BUY, (Object)o.getOrderSide());
        Assert.assertEquals((double)10.5, (double)o.getPrice(), (double)0.0);
        Assert.assertEquals((long)100L, (long)o.getSize());
    }

    @Test
    public void testGetTimeSeries() {
        long fromTime = TimeFormat.DEFAULT.parse("20150101").getTime();
        long toTime = TimeFormat.DEFAULT.parse("20150710").getTime();
        List cs = this.feed.getTimeSeriesIfSubscribed(Candle.class, (Object)CANDLE_SYMBOL, fromTime, toTime);
        Assert.assertNull((Object)cs);
        DXFeedSubscription sub = this.feed.createSubscription(Candle.class);
        sub.addSymbols((Object)new TimeSeriesSubscriptionSymbol((Object)CANDLE_SYMBOL, toTime));
        cs = this.feed.getTimeSeriesIfSubscribed(Candle.class, (Object)CANDLE_SYMBOL, fromTime, toTime);
        Assert.assertNull((Object)cs);
        sub.addSymbols((Object)new TimeSeriesSubscriptionSymbol((Object)CANDLE_SYMBOL, fromTime));
        cs = this.feed.getTimeSeriesIfSubscribed(Candle.class, (Object)CANDLE_SYMBOL, fromTime, toTime);
        Assert.assertNotNull((Object)cs);
        Assert.assertTrue((boolean)cs.isEmpty());
        Candle c = new Candle(CANDLE_SYMBOL);
        c.setTime(fromTime);
        c.setClose(10.5);
        c.setVolume(100L);
        this.publisher.publishEvents(Collections.singletonList(c));
        cs = this.feed.getTimeSeriesIfSubscribed(Candle.class, (Object)CANDLE_SYMBOL, fromTime, toTime);
        Assert.assertNotNull((Object)cs);
        Assert.assertEquals((long)1L, (long)cs.size());
        c = (Candle)cs.get(0);
        Assert.assertEquals((long)fromTime, (long)c.getTime());
        Assert.assertEquals((double)10.5, (double)c.getClose(), (double)0.0);
        Assert.assertEquals((long)100L, (long)c.getVolume());
    }
}

