/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.api.impl.test;

import com.devexperts.qd.DataScheme;
import com.devexperts.qd.QDFactory;
import com.devexperts.qd.QDFilter;
import com.devexperts.qd.kit.CompositeFilters;
import org.junit.Assert;
import org.junit.Test;

public class FiltersStringTest {
    private static final DataScheme SCHEME = QDFactory.getDefaultScheme();

    @Test
    public void testFilterString() {
        this.assertStringOk("chartdata");
        this.assertStringOk("!chartdata");
        this.assertStringOk("feed");
        this.assertStringOk("fxsymbol");
        this.assertStringOk("cs");
        this.assertStringOk("opt");
        this.assertStringOk("fut");
        this.assertStringOk("chartdata", "chartdata&*");
        this.assertStringOk("chartdata", "*&chartdata");
        this.assertStringOk("!chartdata", "!chartdata&*");
        this.assertStringOk("!chartdata", "*&!chartdata");
        this.assertStringOk("chartdata,feed", "((chartdata,feed))");
        this.assertStringOk("!chartdata&!feed", "!(chartdata,feed)");
        this.assertStringOk("!chartdata&!feed", "!(((chartdata,feed)))");
        this.assertStringOk("IBM,MSFT", "IBM,MSFT");
        this.assertStringOk("A,B,C,D", "A,B,C,D");
        this.assertStringOk("!A&!B&!C&!D", "!((A,B,C,D))");
    }

    private void assertStringOk(String original) {
        this.assertStringOk(original, original);
    }

    private void assertStringOk(String expected, String original) {
        QDFilter filter = CompositeFilters.valueOf((String)original, (DataScheme)SCHEME);
        Assert.assertEquals((Object)expected, (Object)filter.toString());
    }
}

