/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.api.impl.test;

import com.devexperts.qd.DataScheme;
import com.devexperts.qd.QDFactory;
import com.devexperts.qd.kit.RecordOnlyFilter;
import org.junit.Assert;
import org.junit.Test;

public class RecordOnlyFiltersTest {
    private static final DataScheme SCHEME = QDFactory.getDefaultScheme();

    @Test
    public void testQuote() {
        this.assertRecordOnlyIncludes("Quote", "Quote");
        this.assertRecordOnlyExcludes("Quote", "Trade", "Fundamental", "Summary", "Message");
    }

    @Test
    public void testQuoteAndTrade() {
        this.assertRecordOnlyIncludes("Quote,Trade", "Quote", "Trade");
        this.assertRecordOnlyExcludes("Quote,Trade", "Fundamental", "Summary", "Message");
    }

    @Test
    public void testNotQuote() {
        this.assertRecordOnlyIncludes("!Quote", "Trade", "Fundamental", "Summary", "Message");
        this.assertRecordOnlyExcludes("!Quote", "Quote");
    }

    @Test
    public void testFeed() {
        this.assertRecordOnlyIncludes("feed", "Quote", "Trade", "Fundamental", "Summary");
        this.assertRecordOnlyExcludes("feed", "Message");
    }

    @Test
    public void testMessage() {
        this.assertRecordOnlyIncludes("Message", "Message");
        this.assertRecordOnlyExcludes("Message", "Quote", "Trade", "Fundamental", "Summary");
    }

    public void assertRecordOnlyIncludes(String spec, String ... includes) {
        RecordOnlyFilter filter = RecordOnlyFilter.valueOf((String)spec, (DataScheme)SCHEME);
        for (String name : includes) {
            Assert.assertTrue((boolean)filter.acceptRecord(SCHEME.findRecordByName(name)));
        }
    }

    public void assertRecordOnlyExcludes(String spec, String ... excludes) {
        RecordOnlyFilter filter = RecordOnlyFilter.valueOf((String)spec, (DataScheme)SCHEME);
        for (String name : excludes) {
            Assert.assertFalse((boolean)filter.acceptRecord(SCHEME.findRecordByName(name)));
        }
    }
}

