/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.api.test;

import com.dxfeed.event.market.MarketEventSymbols;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class MarketEventSymbolsTest {
    @Test
    public void testNull() {
        Assert.assertNull((Object)MarketEventSymbols.getBaseSymbol(null));
        Assert.assertEquals((Object)"SPX", (Object)MarketEventSymbols.changeBaseSymbol(null, (String)"SPX"));
        Assert.assertEquals((Object)false, (Object)MarketEventSymbols.hasExchangeCode(null));
        Assert.assertEquals((long)0L, (long)MarketEventSymbols.getExchangeCode(null));
        Assert.assertNull((Object)MarketEventSymbols.changeExchangeCode(null, (char)'\u0000'));
        Assert.assertEquals((Object)"&D", (Object)MarketEventSymbols.changeExchangeCode(null, (char)'D'));
        Assert.assertEquals(null, (Object)MarketEventSymbols.getAttributeStringByKey(null, (String)"p"));
        Assert.assertEquals(null, (Object)MarketEventSymbols.removeAttributeStringByKey(null, (String)"p"));
        Assert.assertEquals(null, (Object)MarketEventSymbols.changeAttributeStringByKey(null, (String)"p", null));
        Assert.assertEquals((Object)"{p=DAY}", (Object)MarketEventSymbols.changeAttributeStringByKey(null, (String)"p", (String)"DAY"));
        Assert.assertEquals(null, (Object)MarketEventSymbols.getAttributeStringByKey(null, (String)""));
        Assert.assertEquals(null, (Object)MarketEventSymbols.removeAttributeStringByKey(null, (String)""));
        Assert.assertEquals(null, (Object)MarketEventSymbols.changeAttributeStringByKey(null, (String)"", null));
        Assert.assertEquals((Object)"{=}", (Object)MarketEventSymbols.changeAttributeStringByKey(null, (String)"", (String)""));
    }

    @Test
    public void testEmpty() {
        this.checkNonAttributedSymbol("");
    }

    @Test
    public void testRegular() {
        this.checkNonAttributedSymbol("IBM");
    }

    @Test
    public void testBrokenSymbol() {
        this.checkNonAttributedSymbol("{");
        this.checkNonAttributedSymbol("}");
        this.checkNonAttributedSymbol("{}");
        this.checkNonAttributedSymbol("A{");
        this.checkNonAttributedSymbol("A}");
        this.checkNonAttributedSymbol("A{}");
        this.checkNonAttributedSymbol("{B");
        this.checkNonAttributedSymbol("}B");
        this.checkNonAttributedSymbol("{}B");
    }

    private void checkNonAttributedSymbol(String s) {
        Assert.assertEquals((Object)s, (Object)MarketEventSymbols.getBaseSymbol((String)s));
        Assert.assertEquals((Object)"MSFT", (Object)MarketEventSymbols.changeBaseSymbol((String)s, (String)"MSFT"));
        Assert.assertEquals((Object)false, (Object)MarketEventSymbols.hasExchangeCode((String)s));
        Assert.assertEquals((long)0L, (long)MarketEventSymbols.getExchangeCode((String)s));
        Assert.assertEquals((Object)s, (Object)MarketEventSymbols.changeExchangeCode((String)s, (char)'\u0000'));
        Assert.assertEquals((Object)(s + "&C"), (Object)MarketEventSymbols.changeExchangeCode((String)s, (char)'C'));
        Assert.assertEquals(null, (Object)MarketEventSymbols.getAttributeStringByKey((String)s, (String)"key"));
        Assert.assertEquals((Object)s, (Object)MarketEventSymbols.removeAttributeStringByKey((String)s, (String)"key"));
        Assert.assertEquals((Object)s, (Object)MarketEventSymbols.changeAttributeStringByKey((String)s, (String)"key", null));
        Assert.assertEquals((Object)(s + "{key=val}"), (Object)MarketEventSymbols.changeAttributeStringByKey((String)s, (String)"key", (String)"val"));
        Assert.assertEquals(null, (Object)MarketEventSymbols.getAttributeStringByKey((String)s, (String)""));
        Assert.assertEquals((Object)s, (Object)MarketEventSymbols.removeAttributeStringByKey((String)s, (String)""));
        Assert.assertEquals((Object)s, (Object)MarketEventSymbols.changeAttributeStringByKey((String)s, (String)"", null));
        Assert.assertEquals((Object)(s + "{=val}"), (Object)MarketEventSymbols.changeAttributeStringByKey((String)s, (String)"", (String)"val"));
        Assert.assertEquals((Object)(s + "{=}"), (Object)MarketEventSymbols.changeAttributeStringByKey((String)s, (String)"", (String)""));
    }

    @Test
    public void testRegional() {
        String s = "GE&N";
        Assert.assertEquals((Object)"GE", (Object)MarketEventSymbols.getBaseSymbol((String)s));
        Assert.assertEquals((Object)"F&N", (Object)MarketEventSymbols.changeBaseSymbol((String)s, (String)"F"));
        Assert.assertEquals((Object)true, (Object)MarketEventSymbols.hasExchangeCode((String)s));
        Assert.assertEquals((long)78L, (long)MarketEventSymbols.getExchangeCode((String)s));
        Assert.assertEquals((Object)"GE", (Object)MarketEventSymbols.changeExchangeCode((String)s, (char)'\u0000'));
        Assert.assertEquals((Object)"GE&Q", (Object)MarketEventSymbols.changeExchangeCode((String)s, (char)'Q'));
        Assert.assertEquals(null, (Object)MarketEventSymbols.getAttributeStringByKey((String)s, (String)"tho"));
        Assert.assertEquals((Object)s, (Object)MarketEventSymbols.removeAttributeStringByKey((String)s, (String)"tho"));
        Assert.assertEquals((Object)s, (Object)MarketEventSymbols.changeAttributeStringByKey((String)s, (String)"tho", null));
        Assert.assertEquals((Object)"GE&N{tho=true}", (Object)MarketEventSymbols.changeAttributeStringByKey((String)s, (String)"tho", (String)"true"));
        Assert.assertEquals(null, (Object)MarketEventSymbols.getAttributeStringByKey((String)s, (String)""));
        Assert.assertEquals((Object)s, (Object)MarketEventSymbols.removeAttributeStringByKey((String)s, (String)""));
        Assert.assertEquals((Object)s, (Object)MarketEventSymbols.changeAttributeStringByKey((String)s, (String)"", null));
        Assert.assertEquals((Object)"GE&N{=yes}", (Object)MarketEventSymbols.changeAttributeStringByKey((String)s, (String)"", (String)"yes"));
        Assert.assertEquals((Object)"GE&N{=}", (Object)MarketEventSymbols.changeAttributeStringByKey((String)s, (String)"", (String)""));
    }

    @Test
    public void testOneAttr() {
        String s = "/ES{tho=true}";
        Assert.assertEquals((Object)"/ES", (Object)MarketEventSymbols.getBaseSymbol((String)s));
        Assert.assertEquals((Object)"/NQ{tho=true}", (Object)MarketEventSymbols.changeBaseSymbol((String)s, (String)"/NQ"));
        Assert.assertEquals((Object)false, (Object)MarketEventSymbols.hasExchangeCode((String)s));
        Assert.assertEquals((long)0L, (long)MarketEventSymbols.getExchangeCode((String)s));
        Assert.assertEquals((Object)s, (Object)MarketEventSymbols.changeExchangeCode((String)s, (char)'\u0000'));
        Assert.assertEquals((Object)"/ES&G{tho=true}", (Object)MarketEventSymbols.changeExchangeCode((String)s, (char)'G'));
        Assert.assertEquals((Object)"true", (Object)MarketEventSymbols.getAttributeStringByKey((String)s, (String)"tho"));
        Assert.assertEquals((Object)"/ES", (Object)MarketEventSymbols.removeAttributeStringByKey((String)s, (String)"tho"));
        Assert.assertEquals((Object)"/ES", (Object)MarketEventSymbols.changeAttributeStringByKey((String)s, (String)"tho", null));
        Assert.assertEquals((Object)"/ES{tho=false}", (Object)MarketEventSymbols.changeAttributeStringByKey((String)s, (String)"tho", (String)"false"));
        Assert.assertEquals(null, (Object)MarketEventSymbols.getAttributeStringByKey((String)s, (String)"t"));
        Assert.assertEquals((Object)s, (Object)MarketEventSymbols.removeAttributeStringByKey((String)s, (String)"t"));
        Assert.assertEquals((Object)s, (Object)MarketEventSymbols.changeAttributeStringByKey((String)s, (String)"t", null));
        Assert.assertEquals((Object)"/ES{t=MIN,tho=true}", (Object)MarketEventSymbols.changeAttributeStringByKey((String)s, (String)"t", (String)"MIN"));
        Assert.assertEquals(null, (Object)MarketEventSymbols.getAttributeStringByKey((String)s, (String)"zap"));
        Assert.assertEquals((Object)s, (Object)MarketEventSymbols.removeAttributeStringByKey((String)s, (String)"zap"));
        Assert.assertEquals((Object)s, (Object)MarketEventSymbols.changeAttributeStringByKey((String)s, (String)"zap", null));
        Assert.assertEquals((Object)"/ES{tho=true,zap=15}", (Object)MarketEventSymbols.changeAttributeStringByKey((String)s, (String)"zap", (String)"15"));
        Assert.assertEquals((Object)"/ES{tho=true,zap=}", (Object)MarketEventSymbols.changeAttributeStringByKey((String)s, (String)"zap", (String)""));
        Assert.assertEquals(null, (Object)MarketEventSymbols.getAttributeStringByKey((String)s, (String)""));
        Assert.assertEquals((Object)s, (Object)MarketEventSymbols.removeAttributeStringByKey((String)s, (String)""));
        Assert.assertEquals((Object)s, (Object)MarketEventSymbols.changeAttributeStringByKey((String)s, (String)"", null));
        Assert.assertEquals((Object)"/ES{=code,tho=true}", (Object)MarketEventSymbols.changeAttributeStringByKey((String)s, (String)"", (String)"code"));
        Assert.assertEquals((Object)"/ES{=,tho=true}", (Object)MarketEventSymbols.changeAttributeStringByKey((String)s, (String)"", (String)""));
    }

    @Test
    public void testTwoAttrs() {
        String s = "A{c=1,e=3}";
        Assert.assertEquals((Object)"A", (Object)MarketEventSymbols.getBaseSymbol((String)s));
        Assert.assertEquals((Object)"B{c=1,e=3}", (Object)MarketEventSymbols.changeBaseSymbol((String)s, (String)"B"));
        Assert.assertEquals((Object)false, (Object)MarketEventSymbols.hasExchangeCode((String)s));
        Assert.assertEquals((long)0L, (long)MarketEventSymbols.getExchangeCode((String)s));
        Assert.assertEquals((Object)s, (Object)MarketEventSymbols.changeExchangeCode((String)s, (char)'\u0000'));
        Assert.assertEquals((Object)"A&D{c=1,e=3}", (Object)MarketEventSymbols.changeExchangeCode((String)s, (char)'D'));
        Assert.assertEquals(null, (Object)MarketEventSymbols.getAttributeStringByKey((String)s, (String)"b"));
        Assert.assertEquals((Object)s, (Object)MarketEventSymbols.removeAttributeStringByKey((String)s, (String)"b"));
        Assert.assertEquals((Object)s, (Object)MarketEventSymbols.changeAttributeStringByKey((String)s, (String)"b", null));
        Assert.assertEquals((Object)"A{b=2,c=1,e=3}", (Object)MarketEventSymbols.changeAttributeStringByKey((String)s, (String)"b", (String)"2"));
        Assert.assertEquals((Object)"A{b=,c=1,e=3}", (Object)MarketEventSymbols.changeAttributeStringByKey((String)s, (String)"b", (String)""));
        Assert.assertEquals((Object)"1", (Object)MarketEventSymbols.getAttributeStringByKey((String)s, (String)"c"));
        Assert.assertEquals((Object)"A{e=3}", (Object)MarketEventSymbols.removeAttributeStringByKey((String)s, (String)"c"));
        Assert.assertEquals((Object)"A{e=3}", (Object)MarketEventSymbols.changeAttributeStringByKey((String)s, (String)"c", null));
        Assert.assertEquals((Object)"A{c=2,e=3}", (Object)MarketEventSymbols.changeAttributeStringByKey((String)s, (String)"c", (String)"2"));
        Assert.assertEquals((Object)"A{c=,e=3}", (Object)MarketEventSymbols.changeAttributeStringByKey((String)s, (String)"c", (String)""));
        Assert.assertEquals(null, (Object)MarketEventSymbols.getAttributeStringByKey((String)s, (String)"d"));
        Assert.assertEquals((Object)s, (Object)MarketEventSymbols.removeAttributeStringByKey((String)s, (String)"d"));
        Assert.assertEquals((Object)s, (Object)MarketEventSymbols.changeAttributeStringByKey((String)s, (String)"d", null));
        Assert.assertEquals((Object)"A{c=1,d=4,e=3}", (Object)MarketEventSymbols.changeAttributeStringByKey((String)s, (String)"d", (String)"4"));
        Assert.assertEquals((Object)"A{c=1,d=,e=3}", (Object)MarketEventSymbols.changeAttributeStringByKey((String)s, (String)"d", (String)""));
        Assert.assertEquals((Object)"3", (Object)MarketEventSymbols.getAttributeStringByKey((String)s, (String)"e"));
        Assert.assertEquals((Object)"A{c=1}", (Object)MarketEventSymbols.removeAttributeStringByKey((String)s, (String)"e"));
        Assert.assertEquals((Object)"A{c=1}", (Object)MarketEventSymbols.changeAttributeStringByKey((String)s, (String)"e", null));
        Assert.assertEquals((Object)"A{c=1,e=0}", (Object)MarketEventSymbols.changeAttributeStringByKey((String)s, (String)"e", (String)"0"));
        Assert.assertEquals((Object)"A{c=1,e=}", (Object)MarketEventSymbols.changeAttributeStringByKey((String)s, (String)"e", (String)""));
        Assert.assertEquals(null, (Object)MarketEventSymbols.getAttributeStringByKey((String)s, (String)"t"));
        Assert.assertEquals((Object)s, (Object)MarketEventSymbols.removeAttributeStringByKey((String)s, (String)"t"));
        Assert.assertEquals((Object)s, (Object)MarketEventSymbols.changeAttributeStringByKey((String)s, (String)"t", null));
        Assert.assertEquals((Object)"A{c=1,e=3,t=5}", (Object)MarketEventSymbols.changeAttributeStringByKey((String)s, (String)"t", (String)"5"));
        Assert.assertEquals((Object)"A{c=1,e=3,t=}", (Object)MarketEventSymbols.changeAttributeStringByKey((String)s, (String)"t", (String)""));
        Assert.assertEquals(null, (Object)MarketEventSymbols.getAttributeStringByKey((String)s, (String)""));
        Assert.assertEquals((Object)s, (Object)MarketEventSymbols.removeAttributeStringByKey((String)s, (String)""));
        Assert.assertEquals((Object)s, (Object)MarketEventSymbols.changeAttributeStringByKey((String)s, (String)"", null));
        Assert.assertEquals((Object)"A{=-1,c=1,e=3}", (Object)MarketEventSymbols.changeAttributeStringByKey((String)s, (String)"", (String)"-1"));
        Assert.assertEquals((Object)"A{=,c=1,e=3}", (Object)MarketEventSymbols.changeAttributeStringByKey((String)s, (String)"", (String)""));
    }

    @Test
    public void testSpreadSymbol() {
        Assert.assertEquals((Object)"", (Object)MarketEventSymbols.buildSpreadSymbol(Collections.emptyMap()));
        Assert.assertEquals((Object)"", (Object)MarketEventSymbols.buildSpreadSymbol(this.spread("A:0")));
        Assert.assertEquals((Object)"A", (Object)MarketEventSymbols.buildSpreadSymbol(this.spread("A:1")));
        Assert.assertEquals((Object)"=-A", (Object)MarketEventSymbols.buildSpreadSymbol(this.spread("A:-1")));
        Assert.assertEquals((Object)"=2*A", (Object)MarketEventSymbols.buildSpreadSymbol(this.spread("A:2")));
        Assert.assertEquals((Object)"=-2*A", (Object)MarketEventSymbols.buildSpreadSymbol(this.spread("A:-2")));
        Assert.assertEquals((Object)"=0.5*A", (Object)MarketEventSymbols.buildSpreadSymbol(this.spread("A:0.5")));
        Assert.assertEquals((Object)"=-0.5*A", (Object)MarketEventSymbols.buildSpreadSymbol(this.spread("A:-0.5")));
        Assert.assertEquals((Object)"=A+B", (Object)MarketEventSymbols.buildSpreadSymbol(this.spread("A:1,B:1")));
        Assert.assertEquals((Object)"=A-B", (Object)MarketEventSymbols.buildSpreadSymbol(this.spread("A:1,B:-1")));
        Assert.assertEquals((Object)"=B-A", (Object)MarketEventSymbols.buildSpreadSymbol(this.spread("A:-1,B:1")));
        Assert.assertEquals((Object)"=-B-A", (Object)MarketEventSymbols.buildSpreadSymbol(this.spread("A:-1,B:-1")));
        Assert.assertEquals((Object)"=2*A+B", (Object)MarketEventSymbols.buildSpreadSymbol(this.spread("A:2,B:1")));
        Assert.assertEquals((Object)"=2*B+A", (Object)MarketEventSymbols.buildSpreadSymbol(this.spread("A:1,B:2")));
        Assert.assertEquals((Object)"=A-2*B", (Object)MarketEventSymbols.buildSpreadSymbol(this.spread("A:1,B:-2,C:0")));
        Assert.assertEquals((Object)"=4*D+4*H+3*C+3*G+2*B+2*F+A+E+MarketEventSymbolsTest+0.5*P+0.5*Q-0.5*L-0.5*K-1.5*J-1.5*I", (Object)MarketEventSymbols.buildSpreadSymbol(this.spread("A:1,B:2,C:3,D:4,E:1,F:2,G:3,H:4,I:-1.5,J:-1.5,K:-0.5,L:-0.5,M:0,N:0,P:0.5,Q:0.5,MarketEventSymbolsTest:1")));
    }

    private Map<String, Double> spread(String s) {
        HashMap<String, Double> m = new HashMap<String, Double>();
        for (String leg : s.split(",")) {
            m.put(leg.split(":")[0], Double.parseDouble(leg.split(":")[1]));
        }
        return m;
    }
}

