/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.api.test;

import com.dxfeed.api.DXEndpoint;
import com.dxfeed.api.test.AbstractDXPublisherTest;
import com.dxfeed.event.market.Quote;
import com.dxfeed.event.market.Trade;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SchemePropertiesTest
extends AbstractDXPublisherTest {
    private static final long NANO_TIME = 123456789012L;
    private final boolean withNanoTime;

    public SchemePropertiesTest(boolean withNanoTime) {
        super(DXEndpoint.Role.LOCAL_HUB);
        this.withNanoTime = withNanoTime;
    }

    @Override
    protected DXEndpoint.Builder endpointBuilder() {
        DXEndpoint.Builder builder = super.endpointBuilder();
        if (this.withNanoTime) {
            builder = builder.withProperty("dxscheme.nanoTime", "true");
        }
        return builder;
    }

    @Parameterized.Parameters(name="{0}")
    public static Iterable<Object[]> parameters() {
        return Arrays.asList({true}, {false});
    }

    @Test
    public void testNanosTrade() throws InterruptedException {
        String symbol = "Trade";
        Trade trade = new Trade(symbol);
        trade.setTimeNanos(123456789012L);
        this.testGetLastEvent(Trade.class, trade, new Trade(), (publishedEvent, receivedEvent) -> Assert.assertEquals((long)(this.withNanoTime ? 123456789012L : 123456000000L), (long)receivedEvent.getTimeNanos()));
    }

    @Test
    public void testNanosQuote() throws InterruptedException {
        String symbol = "Quote";
        Quote quote = new Quote(symbol);
        quote.setAskTime(123456L);
        quote.setBidTime(123455L);
        quote.setTimeNanoPart(789012);
        this.testGetLastEvent(Quote.class, quote, new Quote(), (publishedEvent, receivedEvent) -> {
            long expectedNanos = this.withNanoTime ? 123456789012L : 123000000000L;
            Assert.assertEquals((long)expectedNanos, (long)receivedEvent.getTimeNanos());
            long expectedTime = this.withNanoTime ? 123456L : 123000L;
            Assert.assertEquals((long)expectedTime, (long)receivedEvent.getTime());
        });
    }
}

