/*
 * !++
 * QDS - Quick Data Signalling Library
 * !-
 * Copyright (C) 2002 - 2021 Devexperts LLC
 * !-
 * This Source Code Form is subject to the terms of the Mozilla Public License, v. 2.0.
 * If a copy of the MPL was not distributed with this file, You can obtain one at
 * http://mozilla.org/MPL/2.0/.
 * !__
 */
package com.dxfeed.event.candle;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.QDContract;
import com.devexperts.qd.ng.RecordBuffer;
import com.devexperts.qd.ng.RecordCursor;
import com.dxfeed.api.impl.EventDelegateFlags;
import com.dxfeed.event.candle.impl.TradeHistoryMapping;

import java.util.EnumSet;

public final class CandleByTradeHistoryDelegate extends CandleEventDelegateImpl<Candle> {
// BEGIN: CODE AUTOMATICALLY GENERATED: DO NOT MODIFY. IT IS REGENERATED BY com.dxfeed.api.codegen.ImplCodeGen
    private final TradeHistoryMapping m;

    public CandleByTradeHistoryDelegate(DataRecord record, QDContract contract, EnumSet<EventDelegateFlags> flags) {
        super(record, contract, flags);
        m = record.getMapping(TradeHistoryMapping.class);
    }

    @Override
    public TradeHistoryMapping getMapping() {
        return m;
    }

    @Override
    public Candle createEvent() {
        return new Candle();
    }

    @Override
    public Candle getEvent(Candle event, RecordCursor cursor) {
        super.getEvent(event, cursor);
        event.setEventFlags(cursor.getEventFlags());
        event.setIndex((((long) m.getTimeSeconds(cursor)) << 32) | (m.getSequence(cursor) & 0xFFFFFFFFL));
        event.setCount(1);
        event.setClose(m.getClose(cursor));
        event.setVolumeAsDouble(m.getVolumeDouble(cursor));
        event.setOpen(event.getClose());
        event.setHigh(event.getClose());
        event.setLow(event.getClose());
        return event;
    }

    @Override
    public RecordCursor putEvent(Candle event, RecordBuffer buf) {
        RecordCursor cursor = super.putEvent(event, buf);
        cursor.setEventFlags(event.getEventFlags());
        m.setTimeSeconds(cursor, (int) (event.getIndex() >>> 32));
        m.setSequence(cursor, (int) event.getIndex());
        m.setClose(cursor, event.getClose());
        m.setVolumeDouble(cursor, event.getVolumeAsDouble());
        return cursor;
    }
// END: CODE AUTOMATICALLY GENERATED
}
