/*
 * !++
 * QDS - Quick Data Signalling Library
 * !-
 * Copyright (C) 2002 - 2021 Devexperts LLC
 * !-
 * This Source Code Form is subject to the terms of the Mozilla Public License, v. 2.0.
 * If a copy of the MPL was not distributed with this file, You can obtain one at
 * http://mozilla.org/MPL/2.0/.
 * !__
 */
package com.dxfeed.event.market.impl;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.ng.RecordCursor;
import com.devexperts.qd.util.MappingUtil;
import com.devexperts.util.TimeUtil;

public final class BookMapping extends MarketEventMapping {
// BEGIN: CODE AUTOMATICALLY GENERATED: DO NOT MODIFY. IT IS REGENERATED BY com.dxfeed.api.codegen.ImplCodeGen
    private final int iId;
    private final int iTime;
    private final int iType;
    private final int iPrice;
    private final int iSize;
    private final int iTimeInForce;
    private final int oSymbol;

    public BookMapping(DataRecord record) {
        super(record);
        iId = MappingUtil.findIntField(record, "ID", true);
        iTime = MappingUtil.findIntField(record, "Time", true);
        iType = MappingUtil.findIntField(record, "Type", true);
        iPrice = findIntField("Price", true);
        iSize = findIntField("Size", true);
        iTimeInForce = MappingUtil.findIntField(record, "TimeInForce", true);
        oSymbol = MappingUtil.findObjField(record, "Symbol", true);
        putNonDefaultPropertyName("ID", "Id");
    }

    @Deprecated
    public int getID(RecordCursor cursor) {
        return getInt(cursor, iId);
    }

    @Deprecated
    public void setID(RecordCursor cursor, int _ID) {
        setInt(cursor, iId, _ID);
    }

    public int getId(RecordCursor cursor) {
        return getInt(cursor, iId);
    }

    public void setId(RecordCursor cursor, int id) {
        setInt(cursor, iId, id);
    }

    public long getTimeMillis(RecordCursor cursor) {
        return getInt(cursor, iTime) * 1000L;
    }

    public void setTimeMillis(RecordCursor cursor, long time) {
        setInt(cursor, iTime, TimeUtil.getSecondsFromTime(time));
    }

    public int getTimeSeconds(RecordCursor cursor) {
        return getInt(cursor, iTime);
    }

    public void setTimeSeconds(RecordCursor cursor, int time) {
        setInt(cursor, iTime, time);
    }

    public char getType(RecordCursor cursor) {
        return (char) getInt(cursor, iType);
    }

    public void setType(RecordCursor cursor, char type) {
        setInt(cursor, iType, type);
    }

    public double getPrice(RecordCursor cursor) {
        return getAsDouble(cursor, iPrice);
    }

    public void setPrice(RecordCursor cursor, double price) {
        setAsDouble(cursor, iPrice, price);
    }

    public int getPriceDecimal(RecordCursor cursor) {
        return getAsTinyDecimal(cursor, iPrice);
    }

    public void setPriceDecimal(RecordCursor cursor, int price) {
        setAsTinyDecimal(cursor, iPrice, price);
    }

    public long getPriceWideDecimal(RecordCursor cursor) {
        return getAsWideDecimal(cursor, iPrice);
    }

    public void setPriceWideDecimal(RecordCursor cursor, long price) {
        setAsWideDecimal(cursor, iPrice, price);
    }

    public int getSize(RecordCursor cursor) {
        return getAsInt(cursor, iSize);
    }

    public void setSize(RecordCursor cursor, int size) {
        setAsInt(cursor, iSize, size);
    }

    public long getSizeLong(RecordCursor cursor) {
        return getAsLong(cursor, iSize);
    }

    public void setSizeLong(RecordCursor cursor, long size) {
        setAsLong(cursor, iSize, size);
    }

    public double getSizeDouble(RecordCursor cursor) {
        return getAsDouble(cursor, iSize);
    }

    public void setSizeDouble(RecordCursor cursor, double size) {
        setAsDouble(cursor, iSize, size);
    }

    public int getSizeDecimal(RecordCursor cursor) {
        return getAsTinyDecimal(cursor, iSize);
    }

    public void setSizeDecimal(RecordCursor cursor, int size) {
        setAsTinyDecimal(cursor, iSize, size);
    }

    public long getSizeWideDecimal(RecordCursor cursor) {
        return getAsWideDecimal(cursor, iSize);
    }

    public void setSizeWideDecimal(RecordCursor cursor, long size) {
        setAsWideDecimal(cursor, iSize, size);
    }

    public char getTimeInForce(RecordCursor cursor) {
        return (char) getInt(cursor, iTimeInForce);
    }

    public void setTimeInForce(RecordCursor cursor, char timeInForce) {
        setInt(cursor, iTimeInForce, timeInForce);
    }

    public String getSymbol(RecordCursor cursor) {
        return (String) getObj(cursor, oSymbol);
    }

    public void setSymbol(RecordCursor cursor, String symbol) {
        setObj(cursor, oSymbol, symbol);
    }
// END: CODE AUTOMATICALLY GENERATED
}
