/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.api.test;

import com.devexperts.test.ThreadCleanCheck;
import com.dxfeed.api.DXEndpoint;
import com.dxfeed.api.DXFeed;
import com.dxfeed.api.DXFeedSubscription;
import com.dxfeed.api.DXPublisher;
import com.dxfeed.event.IndexedEvent;
import com.dxfeed.event.IndexedEventSource;
import com.dxfeed.event.market.MarketMaker;
import com.dxfeed.event.market.Order;
import java.util.Collections;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MarketMakerTest {
    private static final String SYMBOL = "TEST";
    private final BlockingQueue<MarketMaker> marketMakerQueue = new ArrayBlockingQueue<MarketMaker>(10);
    private final BlockingQueue<Order> orderQueue = new ArrayBlockingQueue<Order>(10);
    private DXEndpoint endpoint;
    private DXPublisher publisher;
    private DXFeedSubscription<IndexedEvent<?>> sub;

    @Before
    public void setUp() throws Exception {
        ThreadCleanCheck.before();
        this.endpoint = DXEndpoint.create((DXEndpoint.Role)DXEndpoint.Role.LOCAL_HUB);
        this.endpoint.executor(Runnable::run);
        DXFeed feed = this.endpoint.getFeed();
        this.publisher = this.endpoint.getPublisher();
        this.sub = feed.createSubscription(new Class[]{MarketMaker.class, Order.class});
        this.sub.addEventListener(events -> {
            for (IndexedEvent event : events) {
                if (event instanceof MarketMaker) {
                    this.marketMakerQueue.add((MarketMaker)event);
                    continue;
                }
                if (event instanceof Order) {
                    this.orderQueue.add((Order)event);
                    continue;
                }
                throw new IllegalArgumentException("Unexpected event type: " + event.getClass().getName());
            }
        });
        this.sub.addSymbols((Object)SYMBOL);
    }

    @After
    public void tearDown() throws Exception {
        this.endpoint.close();
        ThreadCleanCheck.after();
    }

    @Test
    public void testMarketMaker() throws InterruptedException {
        MarketMaker marketMaker = new MarketMaker(SYMBOL);
        marketMaker.setExchangeCode('Q');
        marketMaker.setMarketMaker("NSDQ");
        marketMaker.setBidSize(1.0);
        marketMaker.setBidPrice(2.0);
        marketMaker.setAskSize(3.0);
        marketMaker.setAskPrice(4.0);
        this.publisher.publishEvents(Collections.singleton(marketMaker));
        MarketMaker receivedMarketMaker = this.marketMakerQueue.take();
        Assert.assertEquals((Object)SYMBOL, (Object)receivedMarketMaker.getEventSymbol());
        Assert.assertEquals((long)81L, (long)receivedMarketMaker.getExchangeCode());
        Assert.assertEquals((Object)"NSDQ", (Object)receivedMarketMaker.getMarketMaker());
        Assert.assertEquals((double)1.0, (double)receivedMarketMaker.getBidSize(), (double)0.0);
        Assert.assertEquals((double)2.0, (double)receivedMarketMaker.getBidPrice(), (double)0.0);
        Assert.assertEquals((double)3.0, (double)receivedMarketMaker.getAskSize(), (double)0.0);
        Assert.assertEquals((double)4.0, (double)receivedMarketMaker.getAskPrice(), (double)0.0);
        Order receivedBidOrder = this.orderQueue.take();
        Assert.assertEquals((Object)SYMBOL, (Object)receivedBidOrder.getEventSymbol());
        Assert.assertEquals((long)81L, (long)receivedBidOrder.getExchangeCode());
        Assert.assertEquals((Object)"NSDQ", (Object)receivedBidOrder.getMarketMaker());
        Assert.assertEquals((double)1.0, (double)receivedBidOrder.getSize(), (double)0.0);
        Assert.assertEquals((double)2.0, (double)receivedBidOrder.getPrice(), (double)0.0);
        Order receivedAskOrder = this.orderQueue.take();
        Assert.assertEquals((Object)SYMBOL, (Object)receivedAskOrder.getEventSymbol());
        Assert.assertEquals((long)81L, (long)receivedAskOrder.getExchangeCode());
        Assert.assertEquals((Object)"NSDQ", (Object)receivedAskOrder.getMarketMaker());
        Assert.assertEquals((double)3.0, (double)receivedAskOrder.getSize(), (double)0.0);
        Assert.assertEquals((double)4.0, (double)receivedAskOrder.getPrice(), (double)0.0);
        Assert.assertEquals((long)0L, (long)this.marketMakerQueue.size());
        Assert.assertEquals((long)0L, (long)this.orderQueue.size());
    }

    @Test
    public void testEmptyMarketMaker() {
        MarketMaker marketMaker = new MarketMaker();
        Assert.assertNull((Object)marketMaker.getEventSymbol());
        Assert.assertEquals((Object)IndexedEventSource.DEFAULT, (Object)marketMaker.getSource());
        Assert.assertEquals((long)0L, (long)marketMaker.getIndex());
        Assert.assertEquals((long)0L, (long)marketMaker.getExchangeCode());
        Assert.assertNull((Object)marketMaker.getMarketMaker());
        Assert.assertTrue((boolean)Double.isNaN(marketMaker.getBidPrice()));
        Assert.assertTrue((boolean)Double.isNaN(marketMaker.getBidSize()));
        Assert.assertTrue((boolean)Double.isNaN(marketMaker.getAskPrice()));
        Assert.assertTrue((boolean)Double.isNaN(marketMaker.getAskSize()));
    }
}

