/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.api.test;

import com.devexperts.test.ThreadCleanCheck;
import com.dxfeed.api.DXEndpoint;
import com.dxfeed.api.DXFeed;
import com.dxfeed.api.DXFeedSubscription;
import com.dxfeed.api.DXPublisher;
import com.dxfeed.event.market.Order;
import com.dxfeed.event.market.OtcMarketsOrder;
import com.dxfeed.event.market.OtcMarketsPriceType;
import com.dxfeed.event.market.Scope;
import com.dxfeed.event.market.Side;
import java.util.Collections;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OtcMarketsOrderTest {
    private static final String SYMBOL = "TEST";
    private DXEndpoint endpoint;
    private DXPublisher publisher;
    private DXFeedSubscription<OtcMarketsOrder> sub;
    private final BlockingQueue<OtcMarketsOrder> queue = new ArrayBlockingQueue<OtcMarketsOrder>(10);

    @Before
    public void setUp() throws Exception {
        ThreadCleanCheck.before();
        this.endpoint = DXEndpoint.create((DXEndpoint.Role)DXEndpoint.Role.LOCAL_HUB);
        DXFeed feed = this.endpoint.getFeed();
        this.publisher = this.endpoint.getPublisher();
        this.sub = feed.createSubscription(OtcMarketsOrder.class);
        this.sub.addEventListener(this.queue::addAll);
        this.sub.addSymbols((Object)SYMBOL);
    }

    @After
    public void tearDown() throws Exception {
        this.endpoint.close();
        ThreadCleanCheck.after();
    }

    @Test
    public void testOtcMarketsOrder() throws InterruptedException {
        OtcMarketsOrder order = new OtcMarketsOrder(SYMBOL);
        order.setOrderSide(Side.BUY);
        order.setMarketMaker("NSDQ");
        order.setScope(Scope.ORDER);
        order.setPrice(10.0);
        order.setSize(1L);
        order.setIndex(1L);
        order.setMarketMaker(SYMBOL);
        order.setQuoteAccessPayment(-30);
        order.setOpen(true);
        order.setUnsolicited(true);
        order.setOtcMarketsPriceType(OtcMarketsPriceType.ACTUAL);
        order.setSaturated(true);
        order.setAutoExecution(true);
        order.setNmsConditional(true);
        this.publisher.publishEvents(Collections.singleton(order));
        OtcMarketsOrder received = this.queue.take();
        Assert.assertEquals((Object)SYMBOL, (Object)received.getEventSymbol());
        Assert.assertEquals((Object)Side.BUY, (Object)received.getOrderSide());
        Assert.assertEquals((Object)Scope.ORDER, (Object)received.getScope());
        Assert.assertEquals((double)10.0, (double)received.getPrice(), (double)0.0);
        Assert.assertEquals((long)1L, (long)received.getSize());
        Assert.assertEquals((Object)SYMBOL, (Object)received.getMarketMaker());
        Assert.assertEquals((long)-30L, (long)received.getQuoteAccessPayment());
        Assert.assertTrue((boolean)received.isOpen());
        Assert.assertTrue((boolean)received.isUnsolicited());
        Assert.assertEquals((Object)OtcMarketsPriceType.ACTUAL, (Object)received.getOtcMarketsPriceType());
        Assert.assertTrue((boolean)received.isSaturated());
        Assert.assertTrue((boolean)received.isAutoExecution());
        Assert.assertTrue((boolean)received.isNmsConditional());
        order.setQuoteAccessPayment(25);
        order.setOpen(true);
        order.setUnsolicited(false);
        order.setOtcMarketsPriceType(OtcMarketsPriceType.WANTED);
        order.setSaturated(true);
        order.setAutoExecution(false);
        order.setNmsConditional(true);
        this.publisher.publishEvents(Collections.singleton(order));
        received = this.queue.take();
        Assert.assertEquals((long)25L, (long)received.getQuoteAccessPayment());
        Assert.assertTrue((boolean)received.isOpen());
        Assert.assertFalse((boolean)received.isUnsolicited());
        Assert.assertEquals((Object)OtcMarketsPriceType.WANTED, (Object)received.getOtcMarketsPriceType());
        Assert.assertTrue((boolean)received.isSaturated());
        Assert.assertFalse((boolean)received.isAutoExecution());
        Assert.assertTrue((boolean)received.isNmsConditional());
    }

    @Test
    public void testOrderNotReceived() throws InterruptedException {
        Order order = new Order(SYMBOL);
        order.setOrderSide(Side.BUY);
        order.setMarketMaker("NSDQ");
        order.setScope(Scope.ORDER);
        order.setPrice(10.0);
        order.setSize(1L);
        order.setIndex(1L);
        this.publisher.publishEvents(Collections.singleton(order));
        Order received = (Order)this.queue.poll(1L, TimeUnit.SECONDS);
        Assert.assertNull((Object)received);
    }

    @Test
    public void testEmptyOtcMarketsOrder() {
        OtcMarketsOrder order = new OtcMarketsOrder();
        Assert.assertNull((Object)order.getEventSymbol());
        Assert.assertNull((Object)order.getMarketMaker());
        Assert.assertEquals((long)0L, (long)order.getQuoteAccessPayment());
        Assert.assertFalse((boolean)order.isOpen());
        Assert.assertFalse((boolean)order.isUnsolicited());
        Assert.assertEquals((Object)OtcMarketsPriceType.UNPRICED, (Object)order.getOtcMarketsPriceType());
        Assert.assertFalse((boolean)order.isSaturated());
        Assert.assertFalse((boolean)order.isAutoExecution());
        Assert.assertFalse((boolean)order.isNmsConditional());
    }
}

