/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.api.test;

import com.dxfeed.event.candle.CandleExchange;
import com.dxfeed.event.candle.CandlePeriod;
import com.dxfeed.event.candle.CandlePrice;
import com.dxfeed.event.candle.CandleSession;
import com.dxfeed.event.candle.CandleSymbol;
import com.dxfeed.event.candle.CandleSymbolAttribute;
import com.dxfeed.event.candle.CandleType;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;

public class CandleSymbolTest {
    @Test
    public void testCandlePeriods() {
        Assert.assertEquals((Object)CandlePeriod.DAY, (Object)CandlePeriod.parse((String)"DAY"));
        Assert.assertEquals((Object)CandlePeriod.DAY, (Object)CandlePeriod.parse((String)"1DAY"));
        Assert.assertEquals((Object)CandlePeriod.DAY, (Object)CandlePeriod.parse((String)"1day"));
        Assert.assertEquals((Object)CandlePeriod.DAY, (Object)CandlePeriod.parse((String)"1Day"));
        Assert.assertEquals((Object)CandlePeriod.DAY, (Object)CandlePeriod.parse((String)"Day"));
        Assert.assertEquals((Object)CandlePeriod.DAY, (Object)CandlePeriod.parse((String)"Days"));
        Assert.assertEquals((Object)CandlePeriod.DAY, (Object)CandlePeriod.parse((String)"d"));
        Assert.assertEquals((Object)CandlePeriod.DAY, (Object)CandlePeriod.parse((String)"1d"));
        Assert.assertEquals((Object)CandlePeriod.TICK, (Object)CandlePeriod.parse((String)"TICK"));
        Assert.assertEquals((Object)CandlePeriod.TICK, (Object)CandlePeriod.parse((String)"tick"));
        Assert.assertEquals((Object)CandlePeriod.TICK, (Object)CandlePeriod.parse((String)"Ticks"));
        Assert.assertEquals((Object)CandlePeriod.TICK, (Object)CandlePeriod.parse((String)"1tick"));
        Assert.assertEquals((Object)CandlePeriod.TICK, (Object)CandlePeriod.parse((String)"1T"));
        Assert.assertEquals((Object)CandlePeriod.valueOf((double)5.0, (CandleType)CandleType.MINUTE), (Object)CandlePeriod.parse((String)"5MINUTE"));
        Assert.assertEquals((Object)CandlePeriod.valueOf((double)5.0, (CandleType)CandleType.MINUTE), (Object)CandlePeriod.parse((String)"5min"));
        Assert.assertEquals((Object)CandlePeriod.valueOf((double)5.0, (CandleType)CandleType.MINUTE), (Object)CandlePeriod.parse((String)"5Min"));
        Assert.assertEquals((Object)CandlePeriod.valueOf((double)5.0, (CandleType)CandleType.MINUTE), (Object)CandlePeriod.parse((String)"5m"));
        Assert.assertEquals((Object)CandlePeriod.valueOf((double)5.0, (CandleType)CandleType.MINUTE), (Object)CandlePeriod.parse((String)"5M"));
        HashSet<CandlePeriod> set = new HashSet<CandlePeriod>();
        for (double val = 0.0; val <= 5.0; val += 0.25) {
            for (CandleType type : CandleType.values()) {
                CandlePeriod p = CandlePeriod.valueOf((double)val, (CandleType)type);
                Assert.assertTrue((String)"All should be different", (boolean)set.add(p));
                String s1 = p.toString();
                Assert.assertEquals((Object)p, (Object)CandlePeriod.parse((String)s1));
                String s2 = val + type.name();
                Assert.assertEquals((Object)p, (Object)CandlePeriod.parse((String)s2));
            }
        }
    }

    @Test
    public void testNormalization() {
        Assert.assertEquals((Object)"IBM&E", (Object)CandleSymbol.valueOf((String)"IBM", (CandleSymbolAttribute)CandleExchange.valueOf((char)'E')).toString());
        Assert.assertEquals((Object)"IBM", (Object)CandleSymbol.valueOf((String)"IBM", (CandleSymbolAttribute)CandleExchange.COMPOSITE).toString());
        Assert.assertEquals((Object)"IBM{=d}", (Object)CandleSymbol.valueOf((String)"IBM", (CandleSymbolAttribute)CandlePeriod.DAY).toString());
        Assert.assertEquals((Object)"IBM", (Object)CandleSymbol.valueOf((String)"IBM", (CandleSymbolAttribute)CandlePeriod.TICK).toString());
        Assert.assertEquals((Object)"IBM{price=ask}", (Object)CandleSymbol.valueOf((String)"IBM", (CandleSymbolAttribute)CandlePrice.ASK).toString());
        Assert.assertEquals((Object)"IBM", (Object)CandleSymbol.valueOf((String)"IBM", (CandleSymbolAttribute)CandlePrice.LAST).toString());
        Assert.assertEquals((Object)"IBM{tho=true}", (Object)CandleSymbol.valueOf((String)"IBM", (CandleSymbolAttribute)CandleSession.REGULAR).toString());
        Assert.assertEquals((Object)"IBM", (Object)CandleSymbol.valueOf((String)"IBM", (CandleSymbolAttribute)CandleSession.ANY).toString());
        Assert.assertEquals((Object)"EUR/USD{=2h,price=bid,source=bank}", (Object)CandleSymbol.valueOf((String)"EUR/USD{source=bank}", (CandleSymbolAttribute)CandlePrice.BID, (CandleSymbolAttribute[])new CandleSymbolAttribute[]{CandlePeriod.valueOf((double)2.0, (CandleType)CandleType.HOUR)}).toString());
        Assert.assertEquals((Object)"IBM{=15m,aa=zz,price=bid}", (Object)CandleSymbol.valueOf((String)"IBM{aa=zz,price=b}", (CandleSymbolAttribute)CandlePeriod.valueOf((double)15.0, (CandleType)CandleType.MINUTE)).toString());
    }
}

