/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.api.test;

import com.devexperts.qd.qtp.socket.ClientSocketConnector;
import com.devexperts.qd.qtp.socket.ConnectOrder;
import com.devexperts.qd.qtp.socket.ServerSocketTestHelper;
import com.devexperts.util.SynchronizedIndexedSet;
import com.dxfeed.api.DXEndpoint;
import com.dxfeed.api.impl.DXEndpointImpl;
import com.dxfeed.api.test.TestConnectorFactory;
import com.dxfeed.promise.Promise;
import com.dxfeed.promise.Promises;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DXEndpointRestoreTest {
    private static final int PUB_COUNT = 3;
    private static final int WAIT_TIMEOUT = 20000;
    private String testId;
    List<DXEndpoint> publishers;
    List<Integer> ports;
    DXEndpoint feedEndpoint;

    @Before
    public void setUp() throws Exception {
        this.testId = UUID.randomUUID().toString();
        this.publishers = new ArrayList<DXEndpoint>(3);
        this.ports = new ArrayList<Integer>(3);
    }

    @After
    public void tearDown() throws Exception {
        if (this.feedEndpoint != null) {
            this.feedEndpoint.close();
        }
        if (this.publishers != null) {
            this.publishers.forEach(DXEndpoint::close);
        }
    }

    @Test
    public void testConnectRestoreManualPriority() throws Exception {
        this.testConnectRestore(ConnectOrder.PRIORITY, true);
    }

    @Test
    public void testConnectRestoreManualOrdered() throws Exception {
        this.testConnectRestore(ConnectOrder.ORDERED, true);
    }

    @Test
    public void testConnectRestoreAutomaticPriority() throws Exception {
        this.testConnectRestore(ConnectOrder.PRIORITY, false);
    }

    @Test
    public void testConnectRestoreAutomaticOrdered() throws Exception {
        this.testConnectRestore(ConnectOrder.ORDERED, false);
    }

    private void testConnectRestore(ConnectOrder order, boolean manual) throws Exception {
        this.startPublishers();
        String address = this.ports.stream().map(port -> "127.0.0.1:" + port).collect(Collectors.joining(","));
        address = address + String.format("[name=uplink,reconnectDelay=1,connectOrder=%s]", order.toString());
        SynchronizedIndexedSet blockedPorts = SynchronizedIndexedSet.create();
        TestConnectorFactory.addClientSocketConnectorForBlockedPorts(this.testId + ":", (Set<Integer>)blockedPorts);
        this.feedEndpoint = DXEndpoint.create((DXEndpoint.Role)DXEndpoint.Role.STREAM_FEED);
        blockedPorts.add(this.ports.get(0));
        this.feedEndpoint.connect(this.testId + ":" + address);
        Assert.assertTrue((String)"Connect expected", (boolean)DXEndpointRestoreTest.waitCondition(20000L, 10L, () -> this.feedEndpoint.getState() == DXEndpoint.State.CONNECTED));
        ClientSocketConnector connector = this.getFirstConnector(this.feedEndpoint);
        int secondPort = this.ports.get(1);
        Assert.assertEquals((String)"Connect to the second publisher is expected", (long)secondPort, (long)connector.getCurrentPort());
        blockedPorts.clear();
        if (manual) {
            connector.restoreNow();
        } else {
            connector.restoreGracefully("0.001");
        }
        int firstPort = this.ports.get(0);
        Assert.assertTrue((String)"Connect to the first publisher is expected", (boolean)DXEndpointRestoreTest.waitCondition(20000L, 10L, () -> connector.getCurrentPort() == firstPort));
    }

    public static boolean waitCondition(long timeout, long pollPeriod, BooleanSupplier condition) {
        long deadline = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(timeout);
        while (!condition.getAsBoolean()) {
            LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(pollPeriod));
            if (System.nanoTime() - deadline < 0L) continue;
            return condition.getAsBoolean();
        }
        return true;
    }

    private ClientSocketConnector getFirstConnector(DXEndpoint feedEndpoint) {
        List connectors = ((DXEndpointImpl)feedEndpoint).getQDEndpoint().getConnectors();
        Assert.assertEquals((long)1L, (long)connectors.size());
        Assert.assertTrue((boolean)(connectors.get(0) instanceof ClientSocketConnector));
        return (ClientSocketConnector)connectors.get(0);
    }

    private Promise<Integer> addPublisher(String symbol) {
        String name = this.testId + "-pub-" + symbol;
        Promise port = ServerSocketTestHelper.createPortPromise((String)name);
        DXEndpoint endpoint = DXEndpoint.newBuilder().withRole(DXEndpoint.Role.STREAM_PUBLISHER).build().connect(":0[name=" + name + ",bindAddr=127.0.0.1]");
        this.publishers.add(endpoint);
        return port;
    }

    private void startPublishers() {
        ArrayList<Promise<Integer>> promises = new ArrayList<Promise<Integer>>();
        for (int i = 0; i < 3; ++i) {
            String symbol = String.valueOf((char)(65 + i));
            promises.add(this.addPublisher(symbol));
        }
        Promises.allOf(promises).await(20000L, TimeUnit.MILLISECONDS);
        promises.stream().map(Promise::getResult).forEach(this.ports::add);
    }
}

