/*
 * !++
 * QDS - Quick Data Signalling Library
 * !-
 * Copyright (C) 2002 - 2022 Devexperts LLC
 * !-
 * This Source Code Form is subject to the terms of the Mozilla Public License, v. 2.0.
 * If a copy of the MPL was not distributed with this file, You can obtain one at
 * http://mozilla.org/MPL/2.0/.
 * !__
 */
package com.dxfeed.event.market;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.QDContract;
import com.devexperts.qd.ng.RecordBuffer;
import com.devexperts.qd.ng.RecordCursor;
import com.dxfeed.api.impl.EventDelegateFlags;
import com.dxfeed.event.market.impl.OptionSaleMapping;

import java.util.EnumSet;

public final class OptionSaleDelegate extends MarketEventDelegateImpl<OptionSale> {
// BEGIN: CODE AUTOMATICALLY GENERATED: DO NOT MODIFY. IT IS REGENERATED BY com.dxfeed.api.codegen.ImplCodeGen
    private final OptionSaleMapping m;

    public OptionSaleDelegate(DataRecord record, QDContract contract, EnumSet<EventDelegateFlags> flags) {
        super(record, contract, flags);
        m = record.getMapping(OptionSaleMapping.class);
    }

    @Override
    public OptionSaleMapping getMapping() {
        return m;
    }

    @Override
    public OptionSale createEvent() {
        return new OptionSale();
    }

    @Override
    public OptionSale getEvent(OptionSale event, RecordCursor cursor) {
        super.getEvent(event, cursor);
        event.setEventFlags(cursor.getEventFlags());
        event.setIndex(((long) m.getIndex(cursor)));
        event.setTimeSequence((((long) m.getTimeSeconds(cursor)) << 32) | (m.getSequence(cursor) & 0xFFFFFFFFL));
        event.setTimeNanoPart(m.getTimeNanoPart(cursor));
        event.setExchangeCode(m.getExchangeCode(cursor));
        event.setPrice(m.getPrice(cursor));
        event.setSize(m.getSizeDouble(cursor));
        event.setBidPrice(m.getBidPrice(cursor));
        event.setAskPrice(m.getAskPrice(cursor));
        event.setExchangeSaleConditions(m.getExchangeSaleConditionsString(cursor));
        event.setFlags(m.getFlags(cursor));
        event.setUnderlyingPrice(m.getUnderlyingPrice(cursor));
        event.setVolatility(m.getVolatility(cursor));
        event.setDelta(m.getDelta(cursor));
        event.setOptionSymbol(m.getOptionSymbol(cursor));
        return event;
    }

    @Override
    public RecordCursor putEvent(OptionSale event, RecordBuffer buf) {
        RecordCursor cursor = super.putEvent(event, buf);
        cursor.setEventFlags(event.getEventFlags());
        int index = (int) event.getIndex();
        m.setIndex(cursor, index);
        m.setTimeSeconds(cursor, (int) (event.getTimeSequence() >>> 32));
        m.setSequence(cursor, (int) event.getTimeSequence());
        m.setTimeNanoPart(cursor, event.getTimeNanoPart());
        m.setExchangeCode(cursor, event.getExchangeCode());
        m.setPrice(cursor, event.getPrice());
        m.setSizeDouble(cursor, event.getSize());
        m.setBidPrice(cursor, event.getBidPrice());
        m.setAskPrice(cursor, event.getAskPrice());
        m.setExchangeSaleConditionsString(cursor, event.getExchangeSaleConditions());
        m.setFlags(cursor, event.getFlags());
        m.setUnderlyingPrice(cursor, event.getUnderlyingPrice());
        m.setVolatility(cursor, event.getVolatility());
        m.setDelta(cursor, event.getDelta());
        m.setOptionSymbol(cursor, event.getOptionSymbol());
        return cursor;
    }
// END: CODE AUTOMATICALLY GENERATED
}
