/*
 * !++
 * QDS - Quick Data Signalling Library
 * !-
 * Copyright (C) 2002 - 2021 Devexperts LLC
 * !-
 * This Source Code Form is subject to the terms of the Mozilla Public License, v. 2.0.
 * If a copy of the MPL was not distributed with this file, You can obtain one at
 * http://mozilla.org/MPL/2.0/.
 * !__
 */
package com.dxfeed.event.market;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.QDContract;
import com.devexperts.qd.ng.RecordBuffer;
import com.devexperts.qd.ng.RecordCursor;
import com.dxfeed.api.impl.EventDelegateFlags;
import com.dxfeed.event.market.impl.TradeETHMapping;

import java.util.EnumSet;

public final class TradeETHDelegate extends MarketEventDelegateImpl<TradeETH> {
// BEGIN: CODE AUTOMATICALLY GENERATED: DO NOT MODIFY. IT IS REGENERATED BY com.dxfeed.api.codegen.ImplCodeGen
    private final TradeETHMapping m;

    public TradeETHDelegate(DataRecord record, QDContract contract, EnumSet<EventDelegateFlags> flags) {
        super(record, contract, flags);
        m = record.getMapping(TradeETHMapping.class);
    }

    @Override
    public TradeETHMapping getMapping() {
        return m;
    }

    @Override
    public TradeETH createEvent() {
        return new TradeETH();
    }

    @Override
    public TradeETH getEvent(TradeETH event, RecordCursor cursor) {
        super.getEvent(event, cursor);
        event.setTimeSequence((((long) m.getTimeSeconds(cursor)) << 32) | (m.getSequence(cursor) & 0xFFFFFFFFL));
        event.setTimeNanoPart(m.getTimeNanoPart(cursor));
        event.setExchangeCode(m.getExchangeCode(cursor));
        event.setPrice(m.getPrice(cursor));
        event.setSizeAsDouble(m.getSizeDouble(cursor));
        event.setChange(m.getChange(cursor));
        event.setDayId(m.getDayId(cursor));
        event.setDayVolumeAsDouble(m.getDayVolumeDouble(cursor));
        event.setDayTurnover(m.getDayTurnover(cursor));
        event.setFlags(m.getFlags(cursor));
        return event;
    }

    @Override
    public RecordCursor putEvent(TradeETH event, RecordBuffer buf) {
        RecordCursor cursor = super.putEvent(event, buf);
        m.setTimeSeconds(cursor, (int) (event.getTimeSequence() >>> 32));
        m.setSequence(cursor, (int) event.getTimeSequence());
        m.setTimeNanoPart(cursor, event.getTimeNanoPart());
        m.setExchangeCode(cursor, event.getExchangeCode());
        m.setPrice(cursor, event.getPrice());
        m.setSizeDouble(cursor, event.getSizeAsDouble());
        m.setChange(cursor, event.getChange());
        m.setDayId(cursor, event.getDayId());
        m.setDayVolumeDouble(cursor, event.getDayVolumeAsDouble());
        m.setDayTurnover(cursor, event.getDayTurnover());
        m.setFlags(cursor, event.getFlags());
        return cursor;
    }
// END: CODE AUTOMATICALLY GENERATED
}
