/*
 * !++
 * QDS - Quick Data Signalling Library
 * !-
 * Copyright (C) 2002 - 2021 Devexperts LLC
 * !-
 * This Source Code Form is subject to the terms of the Mozilla Public License, v. 2.0.
 * If a copy of the MPL was not distributed with this file, You can obtain one at
 * http://mozilla.org/MPL/2.0/.
 * !__
 */
package com.dxfeed.event.market.impl;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.ng.RecordCursor;
import com.devexperts.qd.util.MappingUtil;

public class SummaryMapping extends MarketEventMapping {
// BEGIN: CODE AUTOMATICALLY GENERATED: DO NOT MODIFY. IT IS REGENERATED BY com.dxfeed.api.codegen.ImplCodeGen
    private final int iDayId;
    private final int iDayOpenPrice;
    private final int iDayHighPrice;
    private final int iDayLowPrice;
    private final int iDayClosePrice;
    private final int iPrevDayId;
    private final int iPrevDayClosePrice;
    private final int iPrevDayVolume;
    private final int iOpenInterest;
    private final int iFlags;

    public SummaryMapping(DataRecord record) {
        super(record);
        iDayId = MappingUtil.findIntField(record, "DayId", true);
        iDayOpenPrice = findIntField("DayOpen.Price", true);
        iDayHighPrice = findIntField("DayHigh.Price", true);
        iDayLowPrice = findIntField("DayLow.Price", true);
        iDayClosePrice = findIntField("DayClose.Price", false);
        iPrevDayId = MappingUtil.findIntField(record, "PrevDayId", true);
        iPrevDayClosePrice = findIntField("PrevDayClose.Price", true);
        iPrevDayVolume = findIntField("PrevDayVolume", false);
        iOpenInterest = findIntField("OpenInterest", false);
        iFlags = MappingUtil.findIntField(record, "Flags", false);
    }

    public int getDayId(RecordCursor cursor) {
        return getInt(cursor, iDayId);
    }

    public void setDayId(RecordCursor cursor, int dayId) {
        setInt(cursor, iDayId, dayId);
    }

    public double getDayOpenPrice(RecordCursor cursor) {
        return getAsDouble(cursor, iDayOpenPrice);
    }

    public void setDayOpenPrice(RecordCursor cursor, double dayOpenPrice) {
        setAsDouble(cursor, iDayOpenPrice, dayOpenPrice);
    }

    public int getDayOpenPriceDecimal(RecordCursor cursor) {
        return getAsTinyDecimal(cursor, iDayOpenPrice);
    }

    public void setDayOpenPriceDecimal(RecordCursor cursor, int dayOpenPrice) {
        setAsTinyDecimal(cursor, iDayOpenPrice, dayOpenPrice);
    }

    public long getDayOpenPriceWideDecimal(RecordCursor cursor) {
        return getAsWideDecimal(cursor, iDayOpenPrice);
    }

    public void setDayOpenPriceWideDecimal(RecordCursor cursor, long dayOpenPrice) {
        setAsWideDecimal(cursor, iDayOpenPrice, dayOpenPrice);
    }

    public double getDayHighPrice(RecordCursor cursor) {
        return getAsDouble(cursor, iDayHighPrice);
    }

    public void setDayHighPrice(RecordCursor cursor, double dayHighPrice) {
        setAsDouble(cursor, iDayHighPrice, dayHighPrice);
    }

    public int getDayHighPriceDecimal(RecordCursor cursor) {
        return getAsTinyDecimal(cursor, iDayHighPrice);
    }

    public void setDayHighPriceDecimal(RecordCursor cursor, int dayHighPrice) {
        setAsTinyDecimal(cursor, iDayHighPrice, dayHighPrice);
    }

    public long getDayHighPriceWideDecimal(RecordCursor cursor) {
        return getAsWideDecimal(cursor, iDayHighPrice);
    }

    public void setDayHighPriceWideDecimal(RecordCursor cursor, long dayHighPrice) {
        setAsWideDecimal(cursor, iDayHighPrice, dayHighPrice);
    }

    public double getDayLowPrice(RecordCursor cursor) {
        return getAsDouble(cursor, iDayLowPrice);
    }

    public void setDayLowPrice(RecordCursor cursor, double dayLowPrice) {
        setAsDouble(cursor, iDayLowPrice, dayLowPrice);
    }

    public int getDayLowPriceDecimal(RecordCursor cursor) {
        return getAsTinyDecimal(cursor, iDayLowPrice);
    }

    public void setDayLowPriceDecimal(RecordCursor cursor, int dayLowPrice) {
        setAsTinyDecimal(cursor, iDayLowPrice, dayLowPrice);
    }

    public long getDayLowPriceWideDecimal(RecordCursor cursor) {
        return getAsWideDecimal(cursor, iDayLowPrice);
    }

    public void setDayLowPriceWideDecimal(RecordCursor cursor, long dayLowPrice) {
        setAsWideDecimal(cursor, iDayLowPrice, dayLowPrice);
    }

    public double getDayClosePrice(RecordCursor cursor) {
        if (iDayClosePrice < 0)
            return Double.NaN;
        return getAsDouble(cursor, iDayClosePrice);
    }

    public void setDayClosePrice(RecordCursor cursor, double dayClosePrice) {
        if (iDayClosePrice < 0)
            return;
        setAsDouble(cursor, iDayClosePrice, dayClosePrice);
    }

    public int getDayClosePriceDecimal(RecordCursor cursor) {
        if (iDayClosePrice < 0)
            return 0;
        return getAsTinyDecimal(cursor, iDayClosePrice);
    }

    public void setDayClosePriceDecimal(RecordCursor cursor, int dayClosePrice) {
        if (iDayClosePrice < 0)
            return;
        setAsTinyDecimal(cursor, iDayClosePrice, dayClosePrice);
    }

    public long getDayClosePriceWideDecimal(RecordCursor cursor) {
        if (iDayClosePrice < 0)
            return 0;
        return getAsWideDecimal(cursor, iDayClosePrice);
    }

    public void setDayClosePriceWideDecimal(RecordCursor cursor, long dayClosePrice) {
        if (iDayClosePrice < 0)
            return;
        setAsWideDecimal(cursor, iDayClosePrice, dayClosePrice);
    }

    public int getPrevDayId(RecordCursor cursor) {
        return getInt(cursor, iPrevDayId);
    }

    public void setPrevDayId(RecordCursor cursor, int prevDayId) {
        setInt(cursor, iPrevDayId, prevDayId);
    }

    public double getPrevDayClosePrice(RecordCursor cursor) {
        return getAsDouble(cursor, iPrevDayClosePrice);
    }

    public void setPrevDayClosePrice(RecordCursor cursor, double prevDayClosePrice) {
        setAsDouble(cursor, iPrevDayClosePrice, prevDayClosePrice);
    }

    public int getPrevDayClosePriceDecimal(RecordCursor cursor) {
        return getAsTinyDecimal(cursor, iPrevDayClosePrice);
    }

    public void setPrevDayClosePriceDecimal(RecordCursor cursor, int prevDayClosePrice) {
        setAsTinyDecimal(cursor, iPrevDayClosePrice, prevDayClosePrice);
    }

    public long getPrevDayClosePriceWideDecimal(RecordCursor cursor) {
        return getAsWideDecimal(cursor, iPrevDayClosePrice);
    }

    public void setPrevDayClosePriceWideDecimal(RecordCursor cursor, long prevDayClosePrice) {
        setAsWideDecimal(cursor, iPrevDayClosePrice, prevDayClosePrice);
    }

    public long getPrevDayVolume(RecordCursor cursor) {
        if (iPrevDayVolume < 0)
            return 0;
        return getAsLong(cursor, iPrevDayVolume);
    }

    public void setPrevDayVolume(RecordCursor cursor, long prevDayVolume) {
        if (iPrevDayVolume < 0)
            return;
        setAsLong(cursor, iPrevDayVolume, prevDayVolume);
    }

    public double getPrevDayVolumeDouble(RecordCursor cursor) {
        if (iPrevDayVolume < 0)
            return Double.NaN;
        return getAsDouble(cursor, iPrevDayVolume);
    }

    public void setPrevDayVolumeDouble(RecordCursor cursor, double prevDayVolume) {
        if (iPrevDayVolume < 0)
            return;
        setAsDouble(cursor, iPrevDayVolume, prevDayVolume);
    }

    public int getPrevDayVolumeDecimal(RecordCursor cursor) {
        if (iPrevDayVolume < 0)
            return 0;
        return getAsTinyDecimal(cursor, iPrevDayVolume);
    }

    public void setPrevDayVolumeDecimal(RecordCursor cursor, int prevDayVolume) {
        if (iPrevDayVolume < 0)
            return;
        setAsTinyDecimal(cursor, iPrevDayVolume, prevDayVolume);
    }

    public long getPrevDayVolumeWideDecimal(RecordCursor cursor) {
        if (iPrevDayVolume < 0)
            return 0;
        return getAsWideDecimal(cursor, iPrevDayVolume);
    }

    public void setPrevDayVolumeWideDecimal(RecordCursor cursor, long prevDayVolume) {
        if (iPrevDayVolume < 0)
            return;
        setAsWideDecimal(cursor, iPrevDayVolume, prevDayVolume);
    }

    public int getOpenInterest(RecordCursor cursor) {
        if (iOpenInterest < 0)
            return 0;
        return getAsInt(cursor, iOpenInterest);
    }

    public void setOpenInterest(RecordCursor cursor, int openInterest) {
        if (iOpenInterest < 0)
            return;
        setAsInt(cursor, iOpenInterest, openInterest);
    }

    public long getOpenInterestLong(RecordCursor cursor) {
        if (iOpenInterest < 0)
            return 0;
        return getAsLong(cursor, iOpenInterest);
    }

    public void setOpenInterestLong(RecordCursor cursor, long openInterest) {
        if (iOpenInterest < 0)
            return;
        setAsLong(cursor, iOpenInterest, openInterest);
    }

    public double getOpenInterestDouble(RecordCursor cursor) {
        if (iOpenInterest < 0)
            return Double.NaN;
        return getAsDouble(cursor, iOpenInterest);
    }

    public void setOpenInterestDouble(RecordCursor cursor, double openInterest) {
        if (iOpenInterest < 0)
            return;
        setAsDouble(cursor, iOpenInterest, openInterest);
    }

    public int getOpenInterestDecimal(RecordCursor cursor) {
        if (iOpenInterest < 0)
            return 0;
        return getAsTinyDecimal(cursor, iOpenInterest);
    }

    public void setOpenInterestDecimal(RecordCursor cursor, int openInterest) {
        if (iOpenInterest < 0)
            return;
        setAsTinyDecimal(cursor, iOpenInterest, openInterest);
    }

    public long getOpenInterestWideDecimal(RecordCursor cursor) {
        if (iOpenInterest < 0)
            return 0;
        return getAsWideDecimal(cursor, iOpenInterest);
    }

    public void setOpenInterestWideDecimal(RecordCursor cursor, long openInterest) {
        if (iOpenInterest < 0)
            return;
        setAsWideDecimal(cursor, iOpenInterest, openInterest);
    }

    public int getFlags(RecordCursor cursor) {
        if (iFlags < 0)
            return 0;
        return getInt(cursor, iFlags);
    }

    public void setFlags(RecordCursor cursor, int flags) {
        if (iFlags < 0)
            return;
        setInt(cursor, iFlags, flags);
    }
// END: CODE AUTOMATICALLY GENERATED
}
