/*
 * !++
 * QDS - Quick Data Signalling Library
 * !-
 * Copyright (C) 2002 - 2025 Devexperts LLC
 * !-
 * This Source Code Form is subject to the terms of the Mozilla Public License, v. 2.0.
 * If a copy of the MPL was not distributed with this file, You can obtain one at
 * http://mozilla.org/MPL/2.0/.
 * !__
 */
package com.dxfeed.event.misc;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.QDContract;
import com.devexperts.qd.SerialFieldType;
import com.devexperts.qd.ng.RecordMapping;
import com.devexperts.qd.ng.RecordMappingFactory;
import com.devexperts.services.ServiceProvider;
import com.dxfeed.api.impl.EventDelegate;
import com.dxfeed.api.impl.EventDelegateFactory;
import com.dxfeed.api.impl.EventDelegateFlags;
import com.dxfeed.api.impl.SchemeBuilder;
import com.dxfeed.event.misc.impl.ConfigurationMapping;
import com.dxfeed.event.misc.impl.MessageMapping;
import com.dxfeed.event.misc.impl.TextConfigurationMapping;
import com.dxfeed.event.misc.impl.TextMessageMapping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;

@ServiceProvider(order = -50)
public final class MiscFactoryImpl extends EventDelegateFactory implements RecordMappingFactory {
// BEGIN: CODE AUTOMATICALLY GENERATED: DO NOT MODIFY. IT IS REGENERATED BY com.dxfeed.api.codegen.ImplCodeGen
    @Override
    public void buildScheme(SchemeBuilder builder) {
        builder.addRequiredField("Message", "Message", SerialFieldType.SERIAL_OBJECT);

        builder.addRequiredField("TextMessage", "Time", SerialFieldType.TIME_SECONDS);
        builder.addRequiredField("TextMessage", "Sequence", SerialFieldType.SEQUENCE);
        builder.addRequiredField("TextMessage", "Text", SerialFieldType.UTF_CHAR_ARRAY);

        builder.addOptionalField("Configuration", "Version", SerialFieldType.COMPACT_INT, "Configuration", "Version", true);
        builder.addRequiredField("Configuration", "Configuration", SerialFieldType.SERIAL_OBJECT);

        builder.addOptionalField("TextConfiguration", "Time", SerialFieldType.TIME_SECONDS, "TextConfiguration", "Time", true);
        builder.addOptionalField("TextConfiguration", "Sequence", SerialFieldType.SEQUENCE, "TextConfiguration", "Sequence", true);
        builder.addOptionalField("TextConfiguration", "Version", SerialFieldType.COMPACT_INT, "TextConfiguration", "Version", true);
        builder.addRequiredField("TextConfiguration", "Text", SerialFieldType.UTF_CHAR_ARRAY);
    }

    @Override
    public Collection<EventDelegate<?>> createDelegates(DataRecord record) {
        Collection<EventDelegate<?>> result = new ArrayList<>();
        if (record.getMapping(MessageMapping.class) != null) {
            result.add(new MessageDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
        } else if (record.getMapping(TextMessageMapping.class) != null) {
            result.add(new TextMessageDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
        } else if (record.getMapping(ConfigurationMapping.class) != null) {
            result.add(new ConfigurationDelegate(record, QDContract.TICKER, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB)));
            result.add(new ConfigurationDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
        } else if (record.getMapping(TextConfigurationMapping.class) != null) {
            result.add(new TextConfigurationDelegate(record, QDContract.TICKER, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB)));
            result.add(new TextConfigurationDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
        }
        return result;
    }

    @Override
    public Collection<EventDelegate<?>> createStreamOnlyDelegates(DataRecord record) {
        Collection<EventDelegate<?>> result = new ArrayList<>();
        if (record.getMapping(MessageMapping.class) != null) {
            result.add(new MessageDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
        } else if (record.getMapping(TextMessageMapping.class) != null) {
            result.add(new TextMessageDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
        } else if (record.getMapping(ConfigurationMapping.class) != null) {
            result.add(new ConfigurationDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
        } else if (record.getMapping(TextConfigurationMapping.class) != null) {
            result.add(new TextConfigurationDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
        }
        return result;
    }

    @Override
    public RecordMapping createMapping(DataRecord record) {
        String baseRecordName = getBaseRecordName(record.getName());
        if (baseRecordName.equals("Message"))
            return new MessageMapping(record);
        if (baseRecordName.equals("TextMessage"))
            return new TextMessageMapping(record);
        if (baseRecordName.equals("Configuration"))
            return new ConfigurationMapping(record);
        if (baseRecordName.equals("TextConfiguration"))
            return new TextConfigurationMapping(record);
        return null;
    }
// END: CODE AUTOMATICALLY GENERATED
}
