/*
 * !++
 * QDS - Quick Data Signalling Library
 * !-
 * Copyright (C) 2002 - 2025 Devexperts LLC
 * !-
 * This Source Code Form is subject to the terms of the Mozilla Public License, v. 2.0.
 * If a copy of the MPL was not distributed with this file, You can obtain one at
 * http://mozilla.org/MPL/2.0/.
 * !__
 */
package com.dxfeed.event.misc;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.QDContract;
import com.devexperts.qd.ng.RecordBuffer;
import com.devexperts.qd.ng.RecordCursor;
import com.dxfeed.api.impl.EventDelegate;
import com.dxfeed.api.impl.EventDelegateFlags;
import com.dxfeed.event.misc.impl.TextConfigurationMapping;

import java.util.EnumSet;

public final class TextConfigurationDelegate extends EventDelegate<TextConfiguration> {
// BEGIN: CODE AUTOMATICALLY GENERATED: DO NOT MODIFY. IT IS REGENERATED BY com.dxfeed.api.codegen.ImplCodeGen
    private final TextConfigurationMapping m;

    public TextConfigurationDelegate(DataRecord record, QDContract contract, EnumSet<EventDelegateFlags> flags) {
        super(record, contract, flags);
        m = record.getMapping(TextConfigurationMapping.class);
    }

    @Override
    public TextConfigurationMapping getMapping() {
        return m;
    }

    @Override
    public TextConfiguration createEvent() {
        return new TextConfiguration();
    }

    @Override
    public TextConfiguration getEvent(TextConfiguration event, RecordCursor cursor) {
        super.getEvent(event, cursor);
        event.setTimeSequence((((long) m.getTimeSeconds(cursor)) << 32) | (m.getSequence(cursor) & 0xFFFFFFFFL));
        event.setVersion(m.getVersion(cursor));
        event.setText(m.getText(cursor));
        return event;
    }

    @Override
    public RecordCursor putEvent(TextConfiguration event, RecordBuffer buf) {
        RecordCursor cursor = super.putEvent(event, buf);
        m.setTimeSeconds(cursor, (int) (event.getTimeSequence() >>> 32));
        m.setSequence(cursor, (int) event.getTimeSequence());
        m.setVersion(cursor, event.getVersion());
        m.setText(cursor, event.getText());
        return cursor;
    }
// END: CODE AUTOMATICALLY GENERATED
}
