/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.api.impl.test;

import com.devexperts.qd.DataScheme;
import com.devexperts.qd.QDFactory;
import com.dxfeed.api.impl.HistorySubscriptionFilterImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class HistorySubscriptionFilterImplTest {
    private static final DataScheme SCHEME = QDFactory.getDefaultScheme();

    @After
    public void tearDown() {
        for (int i = 0; i < SCHEME.getRecordCount(); ++i) {
            System.clearProperty("com.dxfeed.api.impl.HistorySubscriptionFilterImpl.maxRecordCount." + SCHEME.getRecord(i).getName());
        }
        System.clearProperty("com.dxfeed.api.impl.HistorySubscriptionFilterImpl.maxRecordCount.candle");
        System.clearProperty("com.dxfeed.api.impl.HistorySubscriptionFilterImpl.maxRecordCount.timeSeries");
        System.clearProperty("com.dxfeed.api.impl.HistorySubscriptionFilterImpl.maxRecordCount.indexed");
    }

    @Test
    public void defaultMaxRecordCountCorrect() {
        HistorySubscriptionFilterImpl filter = new HistorySubscriptionFilterImpl();
        Assert.assertEquals((long)8000L, (long)filter.getMaxRecordCount(SCHEME.findRecordByName("Candle"), 0, "ABC"));
        Assert.assertEquals((long)8000L, (long)filter.getMaxRecordCount(SCHEME.findRecordByName("Trade.Day"), 0, "ABC"));
        Assert.assertEquals((long)8000L, (long)filter.getMaxRecordCount(SCHEME.findRecordByName("Trade.2hour"), 0, "ABC"));
        Assert.assertEquals((long)8000L, (long)filter.getMaxRecordCount(SCHEME.findRecordByName("Trade.1min"), 0, "ABC"));
        Assert.assertEquals((long)8000L, (long)filter.getMaxRecordCount(SCHEME.findRecordByName("Trade.133ticks"), 0, "ABC"));
        Assert.assertEquals((long)1000L, (long)filter.getMaxRecordCount(SCHEME.findRecordByName("TimeAndSale"), 0, "ABC"));
        Assert.assertEquals((long)1000L, (long)filter.getMaxRecordCount(SCHEME.findRecordByName("TradeHistory"), 0, "ABC"));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)filter.getMaxRecordCount(SCHEME.findRecordByName("Order"), 0, "ABC"));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)filter.getMaxRecordCount(SCHEME.findRecordByName("MarketMaker"), 0, "ABC"));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)filter.getMaxRecordCount(SCHEME.findRecordByName("Series"), 0, "ABC"));
        Assert.assertEquals((long)1000L, (long)filter.getMaxRecordCount(SCHEME.findRecordByName("Underlying"), 0, "ABC"));
        Assert.assertEquals((long)1000L, (long)filter.getMaxRecordCount(SCHEME.findRecordByName("TheoPrice"), 0, "ABC"));
        Assert.assertEquals((long)1000L, (long)filter.getMaxRecordCount(SCHEME.findRecordByName("Greeks"), 0, "ABC"));
    }

    @Test
    public void adjustedMaxRecordCountCorrect() {
        System.setProperty("com.dxfeed.api.impl.HistorySubscriptionFilterImpl.maxRecordCount.Candle", "1");
        System.setProperty("com.dxfeed.api.impl.HistorySubscriptionFilterImpl.maxRecordCount.Trade.Day", "1");
        System.setProperty("com.dxfeed.api.impl.HistorySubscriptionFilterImpl.maxRecordCount.candle", "10");
        System.setProperty("com.dxfeed.api.impl.HistorySubscriptionFilterImpl.maxRecordCount.timeSeries", "2");
        System.setProperty("com.dxfeed.api.impl.HistorySubscriptionFilterImpl.maxRecordCount.indexed", "3");
        HistorySubscriptionFilterImpl filter = new HistorySubscriptionFilterImpl();
        Assert.assertEquals((long)1L, (long)filter.getMaxRecordCount(SCHEME.findRecordByName("Candle"), 0, "ABC"));
        Assert.assertEquals((long)1L, (long)filter.getMaxRecordCount(SCHEME.findRecordByName("Trade.Day"), 0, "ABC"));
        Assert.assertEquals((long)10L, (long)filter.getMaxRecordCount(SCHEME.findRecordByName("Trade.2hour"), 0, "ABC"));
        Assert.assertEquals((long)10L, (long)filter.getMaxRecordCount(SCHEME.findRecordByName("Trade.1min"), 0, "ABC"));
        Assert.assertEquals((long)10L, (long)filter.getMaxRecordCount(SCHEME.findRecordByName("Trade.133ticks"), 0, "ABC"));
        Assert.assertEquals((long)2L, (long)filter.getMaxRecordCount(SCHEME.findRecordByName("TimeAndSale"), 0, "ABC"));
        Assert.assertEquals((long)2L, (long)filter.getMaxRecordCount(SCHEME.findRecordByName("TradeHistory"), 0, "ABC"));
        Assert.assertEquals((long)3L, (long)filter.getMaxRecordCount(SCHEME.findRecordByName("Order"), 0, "ABC"));
        Assert.assertEquals((long)3L, (long)filter.getMaxRecordCount(SCHEME.findRecordByName("MarketMaker"), 0, "ABC"));
        Assert.assertEquals((long)3L, (long)filter.getMaxRecordCount(SCHEME.findRecordByName("Series"), 0, "ABC"));
        Assert.assertEquals((long)2L, (long)filter.getMaxRecordCount(SCHEME.findRecordByName("Underlying"), 0, "ABC"));
        Assert.assertEquals((long)2L, (long)filter.getMaxRecordCount(SCHEME.findRecordByName("TheoPrice"), 0, "ABC"));
        Assert.assertEquals((long)2L, (long)filter.getMaxRecordCount(SCHEME.findRecordByName("Greeks"), 0, "ABC"));
    }
}

