/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.api.impl.test;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.DataScheme;
import com.devexperts.qd.QDFactory;
import com.devexperts.qd.QDFilter;
import com.devexperts.qd.SymbolCodec;
import com.devexperts.qd.kit.CompositeFilters;
import com.devexperts.qd.kit.FilterSyntaxException;
import com.devexperts.qd.kit.SymbolSetFilter;
import com.devexperts.qd.util.SymbolSet;
import org.junit.Assert;
import org.junit.Test;

public class SymbolListFiltersTest {
    private static final DataScheme SCHEME = QDFactory.getDefaultScheme();

    @Test
    public void testSymbolList() {
        this.assertSymbolList("IBM", "IBM");
        this.assertNotSymbolList("IBM*");
        this.assertSymbolList("IBM,MSFT", "IBM", "MSFT");
        this.assertSymbolList("IBM,MSFT,HABAHABA", "IBM", "MSFT", "HABAHABA");
        this.assertSymbolList("[ABC]", "A", "B", "C");
        this.assertSymbolList("(A,B,C,D,E)&(B,D,E)&(A,B,C,D)", "B", "D");
        this.assertSymbolList("AAPL{=15m,price=bid},GOOG{=1h,price=ask}", "AAPL{=15m,price=bid}", "GOOG{=1h,price=ask}");
        this.assertSymbolList("optsymbol&(IBM,.IBM)", ".IBM");
        this.assertSymbolList("!optsymbol&(IBM,.IBM)", "IBM");
        this.assertSymbolList("opt&(IBM,.IBM,EUR/USD,/CL,/CL9H)", ".IBM");
        this.assertSymbolList("!opt&(IBM,.IBM,EUR/USD,/CL,/CL9H)", "IBM", "EUR/USD", "/CL", "/CL9H");
        this.assertSymbolList("fut&(IBM,.IBM,EUR/USD,/CL,/CL9H)", "/CL", "/CL9H");
        this.assertSymbolList("!fut&(IBM,.IBM,EUR/USD,/CL)", "IBM", ".IBM", "EUR/USD");
        this.assertSymbolList("prod&(IBM,.IBM,EUR/USD,/CL,/CL9H)", "/CL");
        this.assertSymbolList("!prod&(IBM,.IBM,EUR/USD,/CL,/CL9H)", "IBM", ".IBM", "EUR/USD", "/CL9H");
        this.assertSymbolList("fx&(IBM,.IBM,EUR/USD,/CL)", "EUR/USD");
        this.assertSymbolList("!fx&(IBM,.IBM,EUR/USD,/CL)", "IBM", ".IBM", "/CL");
        this.assertSymbolList("bs&(IBM,.IBM,EUR/USD,/CL,/CL9H)", "IBM", "EUR/USD");
        this.assertSymbolList("!bs&(IBM,.IBM,EUR/USD,/CL,/CL9H)", ".IBM", "/CL", "/CL9H");
        this.assertSymbolList("cs&(IBM,.IBM,EUR/USD,/CL,/CL9H)", "IBM", "EUR/USD", "/CL", "/CL9H");
        this.assertSymbolList("!cs&(IBM,.IBM,EUR/USD,/CL,/CL9H)", ".IBM");
        this.assertNotSymbolList("opt");
        this.assertNotSymbolList("fut");
        this.assertNotSymbolList("fx");
        this.assertNotSymbolList("bs");
        this.assertNotSymbolList("cs");
        this.assertSymbolList("IBM;fold[ ]i=1[ ]to[ ]2[ ]with[ ]a[ ]do[ ]a;1m", "IBM;fold i=1 to 2 with a do a;1m");
        this.assertSymbolList("IBM;fold\\ i=1\\ to\\ 2\\ with\\ a\\ do\\ a;1m", "IBM;fold i=1 to 2 with a do a;1m");
        this.assertSymbolList("\\QIBM;fold i=1 to 2 with a do a;1m\\E", "IBM;fold i=1 to 2 with a do a;1m");
    }

    private void assertSymbolList(String spec, String ... symbols) {
        SymbolSetFilter filter = SymbolSetFilter.valueOf((String)spec, (DataScheme)SCHEME);
        Assert.assertEquals((Object)QDFilter.Kind.SYMBOL_SET, (Object)filter.getKind());
        SymbolSet set = filter.getSymbolSet();
        Assert.assertNotNull((Object)set);
        Assert.assertEquals((long)symbols.length, (long)set.size());
        for (String symbol : symbols) {
            Assert.assertTrue((String)symbol, (boolean)set.contains(SCHEME.getCodec().encode(symbol), symbol));
        }
    }

    private void assertNotSymbolList(String spec) {
        Assert.assertThrows((String)("Should not be supported: " + spec), FilterSyntaxException.class, () -> SymbolSetFilter.valueOf((String)spec, (DataScheme)SCHEME));
    }

    @Test
    public void testToString() {
        this.checkToString("IBM", "+IBM", "-MSFT", "-GOOG", "-TEST");
        this.checkToString("IBM,MSFT", "+IBM", "+MSFT", "-GOOG", "-TEST");
        this.checkToString("IBM,MSFT,GOOG", "+IBM", "+MSFT", "+GOOG", "-TEST");
        this.checkToString("IBM,MSFT,!GOOG", "+IBM", "+MSFT", "-GOOG", "+TEST");
        this.checkToString("IBM&MSFT,GOOG", "-IBM", "-MSFT", "+GOOG", "-TEST");
        this.checkToString("!IBM", "-IBM", "+MSFT", "+GOOG", "+TEST");
        this.checkToString("!(IBM,MSFT)", "-IBM", "-MSFT", "+GOOG", "+TEST");
        this.checkToString("!GOOG&(IBM,MSFT,GOOG)", "+IBM", "+MSFT", "-GOOG", "-TEST");
    }

    private void checkToString(String spec, String ... testSymbols) {
        QDFilter one = CompositeFilters.valueOf((String)spec, (DataScheme)SCHEME);
        QDFilter two = CompositeFilters.valueOf((String)one.toString(), (DataScheme)SCHEME);
        SymbolCodec code = SCHEME.getCodec();
        DataRecord record = SCHEME.getRecord(0);
        for (String symbolSpec : testSymbols) {
            boolean accepts;
            switch (symbolSpec.charAt(0)) {
                case '+': {
                    accepts = true;
                    break;
                }
                case '-': {
                    accepts = false;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            String symbol = symbolSpec.substring(1);
            int cipher = code.encode(symbol);
            Assert.assertEquals((Object)accepts, (Object)one.accept(null, record, cipher, symbol));
            Assert.assertEquals((Object)accepts, (Object)two.accept(null, record, cipher, symbol));
        }
    }
}

