/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.api.test;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.DataScheme;
import com.devexperts.qd.QDContract;
import com.devexperts.qd.QDFilter;
import com.devexperts.qd.kit.CompositeFilters;
import com.devexperts.test.ThreadCleanCheck;
import com.dxfeed.api.DXEndpoint;
import com.dxfeed.api.DXFeed;
import com.dxfeed.api.DXFeedSubscription;
import com.dxfeed.api.DXFeedTimeSeriesSubscription;
import com.dxfeed.api.DXPublisher;
import com.dxfeed.api.impl.DXEndpointImpl;
import com.dxfeed.api.impl.DXFeedImpl;
import com.dxfeed.api.impl.DXFeedScheme;
import com.dxfeed.api.osub.TimeSeriesSubscriptionSymbol;
import com.dxfeed.event.LastingEvent;
import com.dxfeed.event.market.TimeAndSale;
import com.dxfeed.event.market.Trade;
import com.dxfeed.promise.Promise;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DXFeedFilterTest {
    private static final String SYMBOL = "A";
    private DXEndpointImpl endpoint;
    private DXPublisher publisher;
    private QDFilter filter = CompositeFilters.valueOf((String)"!A", (DataScheme)DXFeedScheme.getInstance());

    @Before
    public void setUp() throws Exception {
        ThreadCleanCheck.before();
        this.endpoint = (DXEndpointImpl)DXEndpoint.create((DXEndpoint.Role)DXEndpoint.Role.LOCAL_HUB);
        this.endpoint.executor(Runnable::run);
        this.publisher = this.endpoint.getPublisher();
    }

    @After
    public void tearDown() throws Exception {
        this.endpoint.close();
        ThreadCleanCheck.after();
    }

    @Test
    public void testFilter() {
        DXFeed feed = this.endpoint.getFeed();
        DXFeedImpl filterFeed = new DXFeedImpl(this.endpoint, this.filter);
        ArrayList tradesReceived = new ArrayList();
        ArrayList filterTradesReceived = new ArrayList();
        DXFeedSubscription sub = feed.createSubscription(Trade.class);
        sub.setExecutor(Runnable::run);
        sub.addEventListener(tradesReceived::addAll);
        sub.addSymbols((Object)SYMBOL);
        DXFeedSubscription filterSub = filterFeed.createSubscription(Trade.class);
        filterSub.addEventListener(filterTradesReceived::addAll);
        filterSub.addSymbols((Object)SYMBOL);
        this.publisher.publishEvents(Collections.singletonList(new Trade(SYMBOL)));
        Assert.assertEquals((long)1L, (long)tradesReceived.size());
        Assert.assertEquals((Object)SYMBOL, (Object)((Trade)tradesReceived.get(0)).getEventSymbol());
        Assert.assertTrue((boolean)filterTradesReceived.isEmpty());
        filterFeed.closeImpl();
    }

    @Test
    public void testSeparateFeedClose() throws InterruptedException {
        DXFeed feed = this.endpoint.getFeed();
        DXFeedImpl filterFeed = new DXFeedImpl(this.endpoint, this.filter);
        LinkedBlockingDeque tradesReceived = new LinkedBlockingDeque();
        DXFeedSubscription sub = feed.createSubscription(Trade.class);
        sub.addEventListener(tradesReceived::addAll);
        sub.addSymbols((Object)SYMBOL);
        DXFeedSubscription filterSub = filterFeed.createSubscription(Trade.class);
        filterSub.addSymbols((Object)SYMBOL);
        filterFeed.closeImpl();
        this.publisher.publishEvents(Collections.singletonList(new Trade(SYMBOL)));
        Trade t = (Trade)tradesReceived.poll(10L, TimeUnit.SECONDS);
        Assert.assertNotNull((Object)t);
        Assert.assertEquals((Object)SYMBOL, (Object)t.getEventSymbol());
    }

    @Test
    public void testLastEventPromise() {
        DXFeedImpl filterFeed = new DXFeedImpl(this.endpoint, this.filter);
        this.publisher.publishEvents(Collections.singletonList(new Trade(SYMBOL)));
        long time = System.currentTimeMillis();
        TimeAndSale tns = new TimeAndSale(SYMBOL);
        tns.setTime(time);
        this.publisher.publishEvents(Collections.singletonList(tns));
        Promise promise = filterFeed.getLastEventPromise(Trade.class, (Object)SYMBOL);
        Assert.assertTrue((boolean)promise.isDone());
        Assert.assertTrue((boolean)promise.hasException());
        Promise timeSeriesPromise = filterFeed.getTimeSeriesPromise(TimeAndSale.class, (Object)SYMBOL, time - 1000L, time + 1000L);
        Assert.assertTrue((boolean)timeSeriesPromise.isDone());
        Assert.assertTrue((boolean)timeSeriesPromise.hasException());
    }

    @Test
    public void testDynamicFilter() {
        SimpleDynamicFilter filter = new SimpleDynamicFilter();
        DXFeedImpl feed = new DXFeedImpl(this.endpoint, (QDFilter)filter);
        ArrayList trades = new ArrayList();
        DXFeedSubscription sub = feed.createSubscription(Trade.class);
        sub.addEventListener(trades::addAll);
        sub.addSymbols((Object)SYMBOL);
        Assert.assertEquals((long)0L, (long)((Trade)feed.getLastEvent((LastingEvent)new Trade(SYMBOL))).getSequence());
        Assert.assertEquals((long)0L, (long)trades.size());
        this.publisher.publishEvents(Collections.singletonList(DXFeedFilterTest.createTrade(1)));
        Assert.assertEquals((long)0L, (long)((Trade)feed.getLastEvent((LastingEvent)new Trade(SYMBOL))).getSequence());
        Assert.assertEquals((long)0L, (long)trades.size());
        filter = filter.addSymbol(SYMBOL);
        this.publisher.publishEvents(Collections.singletonList(DXFeedFilterTest.createTrade(2)));
        Assert.assertEquals((long)2L, (long)((Trade)feed.getLastEvent((LastingEvent)new Trade(SYMBOL))).getSequence());
        Assert.assertEquals((long)2L, (long)((Trade)trades.get(0)).getSequence());
        Assert.assertEquals((long)1L, (long)trades.size());
        filter = filter.removeSymbol(SYMBOL);
        Assert.assertEquals((long)0L, (long)((Trade)feed.getLastEvent((LastingEvent)new Trade(SYMBOL))).getSequence());
        Assert.assertEquals((long)1L, (long)trades.size());
        this.publisher.publishEvents(Collections.singletonList(DXFeedFilterTest.createTrade(3)));
        Assert.assertEquals((long)0L, (long)((Trade)feed.getLastEvent((LastingEvent)new Trade(SYMBOL))).getSequence());
        Assert.assertEquals((long)1L, (long)trades.size());
    }

    @Test
    public void testDynamicFilterTimeSeriesEvent() {
        SimpleDynamicFilter filter = new SimpleDynamicFilter();
        DXFeedImpl feed = new DXFeedImpl(this.endpoint, (QDFilter)filter);
        ArrayList tns = new ArrayList();
        DXFeedSubscription sub = feed.createSubscription(TimeAndSale.class);
        sub.addEventListener(tns::addAll);
        sub.addSymbols((Object)new TimeSeriesSubscriptionSymbol((Object)SYMBOL, 0L));
        Assert.assertEquals((long)0L, (long)tns.size());
        this.publisher.publishEvents(Collections.singletonList(DXFeedFilterTest.createTns(1)));
        Assert.assertEquals((long)0L, (long)tns.size());
        filter = filter.addSymbol(SYMBOL);
        this.publisher.publishEvents(Collections.singletonList(DXFeedFilterTest.createTns(2)));
        Assert.assertEquals((long)1L, (long)tns.size());
        Assert.assertEquals((long)2L, (long)((TimeAndSale)tns.get(0)).getSequence());
        filter = filter.removeSymbol(SYMBOL);
        this.publisher.publishEvents(Collections.singletonList(DXFeedFilterTest.createTns(3)));
        Assert.assertEquals((long)1L, (long)tns.size());
    }

    @Test
    public void testDynamicFilterTimeSeriesSubscription() {
        SimpleDynamicFilter filter = new SimpleDynamicFilter();
        DXFeedImpl feed = new DXFeedImpl(this.endpoint, (QDFilter)filter);
        ArrayList tns = new ArrayList();
        DXFeedTimeSeriesSubscription sub = feed.createTimeSeriesSubscription(TimeAndSale.class);
        sub.setFromTime(0L);
        sub.addEventListener(tns::addAll);
        sub.addSymbols((Object)SYMBOL);
        Assert.assertEquals((long)0L, (long)tns.size());
        this.publisher.publishEvents(Collections.singletonList(DXFeedFilterTest.createTns(1)));
        Assert.assertEquals((long)0L, (long)tns.size());
        List events = feed.getTimeSeriesIfSubscribed(TimeAndSale.class, (Object)SYMBOL, 0L, Long.MAX_VALUE);
        Assert.assertNull((Object)events);
        filter = filter.addSymbol(SYMBOL);
        this.publisher.publishEvents(Collections.singletonList(DXFeedFilterTest.createTns(2)));
        Assert.assertEquals((long)1L, (long)tns.size());
        Assert.assertEquals((long)2L, (long)((TimeAndSale)tns.get(0)).getSequence());
        events = feed.getTimeSeriesIfSubscribed(TimeAndSale.class, (Object)SYMBOL, 0L, Long.MAX_VALUE);
        Assert.assertNotNull((Object)events);
        Assert.assertEquals((long)1L, (long)events.size());
        Assert.assertEquals((long)2L, (long)((TimeAndSale)events.get(0)).getSequence());
        filter = filter.removeSymbol(SYMBOL);
        this.publisher.publishEvents(Collections.singletonList(DXFeedFilterTest.createTns(3)));
        Assert.assertEquals((long)1L, (long)tns.size());
    }

    @Test
    public void testDynamicFilterTimeSeriesAgentLeak() {
        SimpleDynamicFilter filter = new SimpleDynamicFilter();
        filter = filter.addSymbol(SYMBOL);
        DXFeedImpl feed = new DXFeedImpl(this.endpoint, (QDFilter)filter);
        ArrayList tns = new ArrayList();
        DXFeedTimeSeriesSubscription sub = feed.createTimeSeriesSubscription(TimeAndSale.class);
        sub.setFromTime(0L);
        sub.addEventListener(tns::addAll);
        sub.addSymbols((Object)SYMBOL);
        Assert.assertEquals((long)0L, (long)tns.size());
        this.publisher.publishEvents(Collections.singletonList(DXFeedFilterTest.createTns(1)));
        Assert.assertEquals((long)1L, (long)tns.size());
        Assert.assertEquals((long)1L, (long)((TimeAndSale)tns.get(0)).getSequence());
        filter = filter.addSymbol("HABA");
        this.publisher.publishEvents(Collections.singletonList(DXFeedFilterTest.createTns(2)));
        Assert.assertEquals((long)2L, (long)tns.size());
        Assert.assertEquals((long)2L, (long)((TimeAndSale)tns.get(1)).getSequence());
    }

    @Test
    public void testTimeSeriesSubscription() {
        DXFeedImpl feed = new DXFeedImpl(this.endpoint);
        DXFeedTimeSeriesSubscription sub = feed.createTimeSeriesSubscription(TimeAndSale.class);
        sub.addSymbols((Object)SYMBOL);
        TimeSeriesSubscriptionSymbol symbol = new TimeSeriesSubscriptionSymbol((Object)SYMBOL, 0L);
        Assert.assertTrue((boolean)sub.getSymbols().contains(SYMBOL));
        Assert.assertFalse((boolean)sub.getSymbols().contains(symbol));
        Assert.assertFalse((boolean)sub.getDecoratedSymbols().contains(SYMBOL));
        Assert.assertTrue((boolean)sub.getDecoratedSymbols().contains(symbol));
        DXFeedTimeSeriesSubscription sub2 = feed.createTimeSeriesSubscription(TimeAndSale.class);
        sub2.addSymbols((Object)SYMBOL);
        Assert.assertEquals((Object)sub.getSymbols(), (Object)sub2.getSymbols());
        Assert.assertEquals((Object)sub.getDecoratedSymbols(), (Object)sub2.getDecoratedSymbols());
    }

    private static Trade createTrade(int sequence) {
        Trade trade = new Trade(SYMBOL);
        trade.setSequence(sequence);
        return trade;
    }

    private static TimeAndSale createTns(int sequence) {
        TimeAndSale tns = new TimeAndSale(SYMBOL);
        tns.setSequence(sequence);
        tns.setTime(0L);
        return tns;
    }

    private static class SimpleDynamicFilter
    extends QDFilter {
        private Set<String> symbols = new HashSet<String>();

        SimpleDynamicFilter() {
            super((DataScheme)DXFeedScheme.getInstance());
            this.setName("dynamic");
        }

        SimpleDynamicFilter(SimpleDynamicFilter source, String symbol, boolean add) {
            super((DataScheme)DXFeedScheme.getInstance(), (QDFilter)source);
            this.setName("dynamic");
            this.symbols = new HashSet<String>(source.symbols);
            if (add) {
                this.symbols.add(symbol);
            } else {
                this.symbols.remove(symbol);
            }
        }

        public boolean accept(QDContract contract, DataRecord record, int cipher, String symbol) {
            return this.symbols.contains(record.getScheme().getCodec().decode(cipher, symbol));
        }

        public boolean isDynamic() {
            return true;
        }

        SimpleDynamicFilter addSymbol(String symbol) {
            SimpleDynamicFilter newFilter = new SimpleDynamicFilter(this, symbol, true);
            this.fireFilterUpdated(newFilter);
            return newFilter;
        }

        SimpleDynamicFilter removeSymbol(String symbol) {
            SimpleDynamicFilter newFilter = new SimpleDynamicFilter(this, symbol, false);
            this.fireFilterUpdated(newFilter);
            return newFilter;
        }
    }
}

