/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.api.test;

import com.devexperts.qd.DataField;
import com.devexperts.qd.DataRecord;
import com.devexperts.qd.DataScheme;
import com.devexperts.qd.SerialFieldType;
import com.dxfeed.api.impl.DXFeedScheme;
import com.dxfeed.api.impl.EventDelegate;
import com.dxfeed.api.impl.EventDelegateFactory;
import com.dxfeed.api.impl.SchemeBuilder;
import com.dxfeed.api.impl.SchemeFieldTime;
import com.dxfeed.api.impl.SchemeProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;

public class DXFeedSchemeTest {
    private static final TestFactory FACTORY_1 = DXFeedSchemeTest.factory().field("Zzz.CompactIntField", SerialFieldType.COMPACT_INT, SchemeFieldTime.COMMON_FIELD).field("Zzz.DecimalField", SerialFieldType.DECIMAL, SchemeFieldTime.COMMON_FIELD).field("Zzz.StringField", SerialFieldType.STRING, SchemeFieldTime.COMMON_FIELD).field("BlahBlahBlah.Foo", SerialFieldType.VOID, SchemeFieldTime.COMMON_FIELD).field("TimedRec.T1", SerialFieldType.INT, SchemeFieldTime.FIRST_TIME_INT_FIELD).field("TimedRec.T2", SerialFieldType.SHORT_STRING, SchemeFieldTime.SECOND_TIME_INT_FIELD);
    private static final TestFactory FACTORY_2 = DXFeedSchemeTest.factory().field("Zzz.StringField", SerialFieldType.STRING, SchemeFieldTime.COMMON_FIELD).field("Zzz.DecimalField", SerialFieldType.DECIMAL, SchemeFieldTime.COMMON_FIELD).field("Zzz.ObjField", SerialFieldType.CUSTOM_OBJECT, SchemeFieldTime.COMMON_FIELD).field("Zzz.VoidField", SerialFieldType.VOID, SchemeFieldTime.COMMON_FIELD).field("TimedRec.T1", SerialFieldType.INT, SchemeFieldTime.FIRST_TIME_INT_FIELD);
    private static final TestFactory FACTORY_3 = DXFeedSchemeTest.factory().field("TimedRec.T1", SerialFieldType.INT, SchemeFieldTime.COMMON_FIELD).field("TimedRec.T2", SerialFieldType.SHORT_STRING, SchemeFieldTime.COMMON_FIELD).field("TimedRec.Zzz", SerialFieldType.COMPACT_INT, SchemeFieldTime.COMMON_FIELD).field("Xyz.Field", SerialFieldType.VOID, SchemeFieldTime.SECOND_TIME_INT_FIELD);

    private static TestFactory factory() {
        return new TestFactory();
    }

    private void checkFail(String errorMsg, TestFactory ... factories) {
        try {
            new TestScheme(Arrays.asList(factories));
        }
        catch (IllegalArgumentException e) {
            if (!e.getMessage().equals(errorMsg)) {
                Assert.fail();
            }
            return;
        }
        Assert.fail();
    }

    private void check(String expected, TestFactory ... factories) {
        Assert.assertEquals((Object)expected, (Object)DXFeedSchemeTest.printScheme((DataScheme)new TestScheme(Arrays.asList(factories))));
    }

    private static String printScheme(DataScheme scheme) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < scheme.getRecordCount(); ++i) {
            int j;
            DataRecord record = scheme.getRecord(i);
            if (sb.length() > 0) {
                sb.append("; ");
            }
            sb.append(record.getName());
            if (record.hasTime()) {
                sb.append("+T");
            }
            sb.append("{");
            for (j = 0; j < record.getIntFieldCount(); ++j) {
                DXFeedSchemeTest.printField((DataField)record.getIntField(j), sb);
            }
            for (j = 0; j < record.getObjFieldCount(); ++j) {
                DXFeedSchemeTest.printField((DataField)record.getObjField(j), sb);
            }
            sb.append("}");
        }
        return sb.toString();
    }

    private static void printField(DataField field, StringBuilder sb) {
        if (sb.charAt(sb.length() - 1) != '{') {
            sb.append(", ");
        }
        sb.append(field.getLocalName()).append(":").append(field.getSerialType());
    }

    @Test
    public void testSimpleScheme() {
        this.check("Zzz{CompactIntField:COMPACT_INT, DecimalField:DECIMAL, StringField:STRING}; BlahBlahBlah{Foo:VOID}; TimedRec+T{T1:INT, T2:SHORT_STRING}", FACTORY_1);
        this.check("Zzz{DecimalField:DECIMAL, VoidField:VOID, StringField:STRING, ObjField:BYTE_ARRAY}; TimedRec+T{T1:INT, $VoidTimeField:VOID}", FACTORY_2);
        this.check("TimedRec{T1:INT, T2:SHORT_STRING, Zzz:COMPACT_INT}; Xyz+T{$VoidTimeField:VOID, Field:VOID}", FACTORY_3);
        this.check("Zzz{CompactIntField:COMPACT_INT, DecimalField:DECIMAL, VoidField:VOID, StringField:STRING, ObjField:BYTE_ARRAY}; BlahBlahBlah{Foo:VOID}; TimedRec+T{T1:INT, T2:SHORT_STRING}", FACTORY_1, FACTORY_2);
        this.check("Zzz{DecimalField:DECIMAL, VoidField:VOID, StringField:STRING, ObjField:BYTE_ARRAY}; TimedRec+T{T1:INT, $VoidTimeField:VOID, T2:SHORT_STRING, Zzz:COMPACT_INT}; Xyz+T{$VoidTimeField:VOID, Field:VOID}", FACTORY_2, FACTORY_3);
        this.check("TimedRec+T{T1:INT, T2:SHORT_STRING, Zzz:COMPACT_INT}; Xyz+T{$VoidTimeField:VOID, Field:VOID}; Zzz{CompactIntField:COMPACT_INT, DecimalField:DECIMAL, StringField:STRING}; BlahBlahBlah{Foo:VOID}", FACTORY_3, FACTORY_1);
        this.check("Zzz{CompactIntField:COMPACT_INT, DecimalField:DECIMAL, VoidField:VOID, StringField:STRING, ObjField:BYTE_ARRAY}; BlahBlahBlah{Foo:VOID}; TimedRec+T{T1:INT, T2:SHORT_STRING, Zzz:COMPACT_INT}; Xyz+T{$VoidTimeField:VOID, Field:VOID}", FACTORY_1, FACTORY_2, FACTORY_3);
    }

    @Test
    public void testGoodTimedFields() {
        this.check("R+T{T1:SHORT_STRING, $VoidTimeField:VOID}", DXFeedSchemeTest.factory().field("R.T1", SerialFieldType.SHORT_STRING, SchemeFieldTime.FIRST_TIME_INT_FIELD));
        this.check("R+T{$VoidTimeField:VOID, T2:DECIMAL}", DXFeedSchemeTest.factory().field("R.T2", SerialFieldType.DECIMAL, SchemeFieldTime.SECOND_TIME_INT_FIELD));
        this.check("R+T{T1:SHORT_STRING, T2:DECIMAL, Int:COMPACT_INT, Obj:SERIAL_OBJECT}; Zzz{Haba:VOID}", DXFeedSchemeTest.factory().field("R.T1", SerialFieldType.SHORT_STRING, SchemeFieldTime.FIRST_TIME_INT_FIELD).field("R.T2", SerialFieldType.DECIMAL, SchemeFieldTime.SECOND_TIME_INT_FIELD).field("R.Int", SerialFieldType.COMPACT_INT, SchemeFieldTime.COMMON_FIELD).field("R.Obj", SerialFieldType.SERIAL_OBJECT, SchemeFieldTime.COMMON_FIELD), DXFeedSchemeTest.factory().field("R.T2", SerialFieldType.DECIMAL, SchemeFieldTime.SECOND_TIME_INT_FIELD).field("Zzz.Haba", SerialFieldType.VOID, SchemeFieldTime.COMMON_FIELD));
        this.check("R+T{T:SHORT_STRING, $VoidTimeField:VOID}", DXFeedSchemeTest.factory().field("R.T", SerialFieldType.SHORT_STRING, SchemeFieldTime.FIRST_TIME_INT_FIELD), DXFeedSchemeTest.factory().field("R.T", SerialFieldType.SHORT_STRING, SchemeFieldTime.COMMON_FIELD));
    }

    @Test
    public void testBadTimedFields() {
        this.checkFail("Failed to create default data-scheme: R.Obj time-field must have integer type", DXFeedSchemeTest.factory().field("R.Obj", SerialFieldType.SERIAL_OBJECT, SchemeFieldTime.FIRST_TIME_INT_FIELD));
        this.checkFail("Failed to create default data-scheme: R.Str time-field must have integer type", DXFeedSchemeTest.factory().field("R.Str", SerialFieldType.STRING, SchemeFieldTime.SECOND_TIME_INT_FIELD));
        this.checkFail("Failed to create default data-scheme: different time-fields proposed for R record", DXFeedSchemeTest.factory().field("R.a", SerialFieldType.COMPACT_INT, SchemeFieldTime.FIRST_TIME_INT_FIELD), DXFeedSchemeTest.factory().field("R.b", SerialFieldType.COMPACT_INT, SchemeFieldTime.FIRST_TIME_INT_FIELD));
        this.checkFail("Failed to create default data-scheme: R.xxx field has several different types", DXFeedSchemeTest.factory().field("R.xxx", SerialFieldType.COMPACT_INT, SchemeFieldTime.FIRST_TIME_INT_FIELD), DXFeedSchemeTest.factory().field("R.xxx", SerialFieldType.SHORT_STRING, SchemeFieldTime.FIRST_TIME_INT_FIELD));
    }

    private static class Field {
        public final String name;
        public final SerialFieldType type;
        public final SchemeFieldTime time;

        public Field(String name, SerialFieldType type, SchemeFieldTime time) {
            this.name = name;
            this.type = type;
            this.time = time;
        }
    }

    private static class TestFactory
    extends EventDelegateFactory {
        private final List<Field> fields = new ArrayList<Field>();

        TestFactory() {
        }

        public void buildScheme(SchemeBuilder builder) {
            for (Field f : this.fields) {
                String[] s = f.name.split("\\.", 2);
                builder.addRequiredField(s[0], s[1], f.type, f.time);
            }
        }

        public TestFactory field(String name, SerialFieldType type, SchemeFieldTime time) {
            this.fields.add(new Field(name, type, time));
            return this;
        }

        public Collection<EventDelegate<?>> createDelegates(DataRecord record) {
            return Collections.emptyList();
        }
    }

    private static class TestScheme
    extends DXFeedScheme {
        public TestScheme(Iterable<? extends EventDelegateFactory> eventDelegateFactories) {
            super(eventDelegateFactories, new SchemeProperties(new Properties()));
        }
    }
}

