/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.api.test;

import com.devexperts.test.ThreadCleanCheck;
import com.dxfeed.api.DXEndpoint;
import com.dxfeed.api.DXFeed;
import com.dxfeed.api.DXFeedSubscription;
import com.dxfeed.api.DXPublisher;
import com.dxfeed.event.misc.Message;
import java.util.Arrays;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MessageTest {
    @Before
    public void setUp() throws Exception {
        ThreadCleanCheck.before();
    }

    @After
    public void tearDown() throws Exception {
        ThreadCleanCheck.after();
    }

    @Test
    public void testMessageConflation() {
        Runnable task;
        ConcurrentLinkedQueue taskQueue = new ConcurrentLinkedQueue();
        DXEndpoint endpoint = DXEndpoint.create((DXEndpoint.Role)DXEndpoint.Role.LOCAL_HUB);
        endpoint.executor(taskQueue::add);
        DXFeed feed = endpoint.getFeed();
        String topic = "test";
        DXFeedSubscription sub = feed.createSubscription(Message.class);
        ConcurrentLinkedQueue receiveQueue = new ConcurrentLinkedQueue();
        sub.addEventListener(receiveQueue::addAll);
        sub.addSymbols((Object)topic);
        DXPublisher publisher = endpoint.getPublisher();
        publisher.publishEvents(Arrays.asList(new Message(topic, (Object)"one"), new Message(topic, (Object)"two"), new Message(topic, (Object)"three")));
        Assert.assertEquals((long)0L, (long)receiveQueue.size());
        while ((task = (Runnable)taskQueue.poll()) != null) {
            task.run();
        }
        Assert.assertEquals((long)3L, (long)receiveQueue.size());
        Assert.assertEquals((Object)"one", (Object)((Message)receiveQueue.poll()).getAttachment());
        Assert.assertEquals((Object)"two", (Object)((Message)receiveQueue.poll()).getAttachment());
        Assert.assertEquals((Object)"three", (Object)((Message)receiveQueue.poll()).getAttachment());
        Assert.assertNull(receiveQueue.poll());
    }
}

