/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.api.test;

import com.devexperts.test.ThreadCleanCheck;
import com.dxfeed.api.DXEndpoint;
import com.dxfeed.api.DXFeed;
import com.dxfeed.api.DXPublisher;
import com.dxfeed.api.osub.ObservableSubscriptionChangeListener;
import com.dxfeed.event.option.TheoPrice;
import com.dxfeed.event.option.Underlying;
import com.dxfeed.promise.Promise;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OptionEventTimeSeriesPromiseTest {
    private static final String SYMBOL = "XYZ";
    private DXEndpoint endpoint;
    private DXFeed feed;
    private DXPublisher publisher;
    private final Queue<Runnable> tasks = new ArrayDeque<Runnable>();
    private final Queue<Object> added = new ArrayDeque<Object>();
    private final Queue<Object> removed = new ArrayDeque<Object>();

    @Before
    public void setUp() throws Exception {
        ThreadCleanCheck.before();
        this.endpoint = DXEndpoint.create((DXEndpoint.Role)DXEndpoint.Role.LOCAL_HUB);
        this.feed = this.endpoint.getFeed();
        this.publisher = this.endpoint.getPublisher();
        this.endpoint.executor(this.tasks::add);
        ObservableSubscriptionChangeListener subscriptionChangeListener = new ObservableSubscriptionChangeListener(){

            public void symbolsAdded(Set<?> symbols) {
                OptionEventTimeSeriesPromiseTest.this.added.addAll(symbols);
            }

            public void symbolsRemoved(Set<?> symbols) {
                OptionEventTimeSeriesPromiseTest.this.removed.addAll(symbols);
            }
        };
        this.publisher.getSubscription(Underlying.class).addChangeListener(subscriptionChangeListener);
        this.publisher.getSubscription(TheoPrice.class).addChangeListener(subscriptionChangeListener);
        this.runAllTasks();
    }

    private void runAllTasks() {
        while (!this.tasks.isEmpty()) {
            this.runTask();
        }
        ThreadCleanCheck.after();
    }

    @After
    public void tearDown() throws Exception {
        this.endpoint.close();
    }

    @Test
    public void testUnderlyingPromise() {
        Promise promise = this.feed.getTimeSeriesPromise(Underlying.class, (Object)SYMBOL, 0L, 300L);
        Assert.assertFalse((boolean)promise.isDone());
        Assert.assertEquals((long)0L, (long)this.added.size());
        this.runTask();
        this.assertNoTasks();
        Assert.assertTrue((boolean)this.added.poll().toString().startsWith(SYMBOL));
        this.assertNoAddedOrRemoved();
        Assert.assertFalse((boolean)promise.isDone());
        this.publishUnderlying(300L, 10.01, 4);
        Assert.assertFalse((boolean)promise.isDone());
        this.assertNoTasks();
        this.publishUnderlying(200L, 10.02, 0);
        Assert.assertFalse((boolean)promise.isDone());
        this.assertNoTasks();
        this.publishUnderlying(100L, 10.03, 0);
        Assert.assertFalse((boolean)promise.isDone());
        this.assertNoTasks();
        this.publishUnderlying(0L, 10.04, 0);
        Assert.assertTrue((boolean)promise.isDone());
        this.assertNoAddedOrRemoved();
        this.runTask();
        this.assertNoTasks();
        Assert.assertTrue((boolean)this.removed.poll().toString().startsWith(SYMBOL));
        this.assertNoAddedOrRemoved();
        List list = (List)promise.getResult();
        Assert.assertEquals((long)4L, (long)list.size());
        this.assertUnderlying((Underlying)list.get(0), 0L, 10.04);
        this.assertUnderlying((Underlying)list.get(1), 100L, 10.03);
        this.assertUnderlying((Underlying)list.get(2), 200L, 10.02);
        this.assertUnderlying((Underlying)list.get(3), 300L, 10.01);
    }

    @Test
    public void testTheoPricePromise() {
        Promise promise = this.feed.getTimeSeriesPromise(TheoPrice.class, (Object)SYMBOL, 0L, 300L);
        Assert.assertFalse((boolean)promise.isDone());
        Assert.assertEquals((long)0L, (long)this.added.size());
        this.runTask();
        this.assertNoTasks();
        Assert.assertTrue((boolean)this.added.poll().toString().startsWith(SYMBOL));
        this.assertNoAddedOrRemoved();
        Assert.assertFalse((boolean)promise.isDone());
        this.publishTheoPrice(300L, 10.01, 4);
        Assert.assertFalse((boolean)promise.isDone());
        this.assertNoTasks();
        this.publishTheoPrice(200L, 10.02, 0);
        Assert.assertFalse((boolean)promise.isDone());
        this.assertNoTasks();
        this.publishTheoPrice(100L, 10.03, 0);
        Assert.assertFalse((boolean)promise.isDone());
        this.assertNoTasks();
        this.publishTheoPrice(0L, 10.04, 0);
        Assert.assertTrue((boolean)promise.isDone());
        this.assertNoAddedOrRemoved();
        this.runTask();
        this.assertNoTasks();
        Assert.assertTrue((boolean)this.removed.poll().toString().startsWith(SYMBOL));
        this.assertNoAddedOrRemoved();
        List list = (List)promise.getResult();
        Assert.assertEquals((long)4L, (long)list.size());
        this.assertTheoPrice((TheoPrice)list.get(0), 0L, 10.04);
        this.assertTheoPrice((TheoPrice)list.get(1), 100L, 10.03);
        this.assertTheoPrice((TheoPrice)list.get(2), 200L, 10.02);
        this.assertTheoPrice((TheoPrice)list.get(3), 300L, 10.01);
    }

    private void assertNoAddedOrRemoved() {
        Assert.assertEquals((long)0L, (long)this.added.size());
        Assert.assertEquals((long)0L, (long)this.removed.size());
    }

    private void publishUnderlying(long time, double volatility, int eventFlags) {
        Underlying underlying = new Underlying(SYMBOL);
        underlying.setTime(time);
        underlying.setEventFlags(eventFlags);
        underlying.setVolatility(volatility);
        this.publisher.publishEvents(Collections.singletonList(underlying));
    }

    private void assertUnderlying(Underlying underlying, long time, double volatility) {
        Assert.assertEquals((Object)SYMBOL, (Object)underlying.getEventSymbol());
        Assert.assertEquals((long)time, (long)underlying.getTime());
        Assert.assertEquals((long)0L, (long)underlying.getEventFlags());
        Assert.assertEquals((double)volatility, (double)underlying.getVolatility(), (double)0.0);
    }

    private void publishTheoPrice(long time, double price, int eventFlags) {
        TheoPrice theoPrice = new TheoPrice(SYMBOL);
        theoPrice.setTime(time);
        theoPrice.setEventFlags(eventFlags);
        theoPrice.setPrice(price);
        this.publisher.publishEvents(Collections.singletonList(theoPrice));
    }

    private void assertTheoPrice(TheoPrice theoPrice, long time, double price) {
        Assert.assertEquals((Object)SYMBOL, (Object)theoPrice.getEventSymbol());
        Assert.assertEquals((long)time, (long)theoPrice.getTime());
        Assert.assertEquals((long)0L, (long)theoPrice.getEventFlags());
        Assert.assertEquals((double)price, (double)theoPrice.getPrice(), (double)0.0);
    }

    private void assertNoTasks() {
        Assert.assertEquals((long)0L, (long)this.tasks.size());
    }

    private void runTask() {
        this.tasks.poll().run();
    }
}

