/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.api.test;

import com.dxfeed.api.DXEndpoint;
import com.dxfeed.api.DXFeedTimeSeriesSubscription;
import com.dxfeed.api.test.AbstractDXPublisherTest;
import com.dxfeed.event.option.TheoPrice;
import com.dxfeed.event.option.Underlying;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.ArrayBlockingQueue;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;

public class OptionEventTimeSeriesSubscriptionTest
extends AbstractDXPublisherTest {
    private static final String SYMBOL = "ABC";

    public OptionEventTimeSeriesSubscriptionTest(DXEndpoint.Role role) {
        super(role);
    }

    @Parameterized.Parameters(name="{0}")
    public static Iterable<Object[]> parameters() {
        return Arrays.asList(new Object[][]{{DXEndpoint.Role.FEED}});
    }

    @Test
    public void testUnderlyingEvents() throws InterruptedException {
        this.setUp("underlyingTimeSeriesSubscription");
        DXFeedTimeSeriesSubscription sub = this.feed.createTimeSeriesSubscription(Underlying.class);
        ArrayBlockingQueue eventQueue = new ArrayBlockingQueue(10);
        sub.addEventListener(eventQueue::addAll);
        sub.setSymbols(new Object[]{SYMBOL});
        sub.setFromTime(0L);
        this.publishUnderlying(300L, 3.0, 4);
        this.publishUnderlying(200L, 2.0, 0);
        this.publishUnderlying(100L, 1.0, 0);
        this.publishUnderlying(0L, 0.5, 8);
        Assert.assertEquals((long)4L, (long)eventQueue.size());
        ArrayList events = new ArrayList(eventQueue);
        this.assertUnderlying((Underlying)events.get(0), 300L, 3.0, 4);
        this.assertUnderlying((Underlying)events.get(1), 200L, 2.0, 0);
        this.assertUnderlying((Underlying)events.get(2), 100L, 1.0, 0);
        this.assertUnderlying((Underlying)events.get(3), 0L, 0.5, 8);
        this.tearDown();
    }

    @Test
    public void testTheoPriceEvents() throws InterruptedException {
        this.setUp("theoPriceTimeSeriesSubscription");
        DXFeedTimeSeriesSubscription sub = this.feed.createTimeSeriesSubscription(TheoPrice.class);
        ArrayBlockingQueue eventQueue = new ArrayBlockingQueue(10);
        sub.addEventListener(eventQueue::addAll);
        sub.setSymbols(new Object[]{SYMBOL});
        sub.setFromTime(0L);
        this.publishTheoPrice(300L, 3.0, 4);
        this.publishTheoPrice(200L, 2.0, 0);
        this.publishTheoPrice(100L, 1.0, 0);
        this.publishTheoPrice(0L, 0.5, 8);
        Assert.assertEquals((long)4L, (long)eventQueue.size());
        ArrayList events = new ArrayList(eventQueue);
        this.assertTheoPrice((TheoPrice)events.get(0), 300L, 3.0, 4);
        this.assertTheoPrice((TheoPrice)events.get(1), 200L, 2.0, 0);
        this.assertTheoPrice((TheoPrice)events.get(2), 100L, 1.0, 0);
        this.assertTheoPrice((TheoPrice)events.get(3), 0L, 0.5, 8);
        this.tearDown();
    }

    private void publishUnderlying(long time, double volatility, int eventFlags) {
        Underlying underlying = new Underlying(SYMBOL);
        underlying.setTime(time);
        underlying.setEventFlags(eventFlags);
        underlying.setVolatility(volatility);
        this.publisher.publishEvents(Collections.singletonList(underlying));
        this.checkpoint();
    }

    private void assertUnderlying(Underlying underlying, long time, double volatility, int eventFlags) {
        Assert.assertEquals((Object)SYMBOL, (Object)underlying.getEventSymbol());
        Assert.assertEquals((long)time, (long)underlying.getTime());
        Assert.assertEquals((double)volatility, (double)underlying.getVolatility(), (double)0.0);
        Assert.assertEquals((long)eventFlags, (long)underlying.getEventFlags());
    }

    private void publishTheoPrice(long time, double price, int eventFlags) {
        TheoPrice theoPrice = new TheoPrice(SYMBOL);
        theoPrice.setTime(time);
        theoPrice.setEventFlags(eventFlags);
        theoPrice.setPrice(price);
        this.publisher.publishEvents(Collections.singletonList(theoPrice));
        this.checkpoint();
    }

    private void assertTheoPrice(TheoPrice theoPrice, long time, double price, int eventFlags) {
        Assert.assertEquals((Object)SYMBOL, (Object)theoPrice.getEventSymbol());
        Assert.assertEquals((long)time, (long)theoPrice.getTime());
        Assert.assertEquals((double)price, (double)theoPrice.getPrice(), (double)0.0);
        Assert.assertEquals((long)eventFlags, (long)theoPrice.getEventFlags());
    }
}

