/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.api.test;

import com.devexperts.test.ThreadCleanCheck;
import com.dxfeed.api.DXEndpoint;
import com.dxfeed.api.DXFeedSubscription;
import com.dxfeed.api.osub.IndexedEventSubscriptionSymbol;
import com.dxfeed.event.IndexedEventSource;
import com.dxfeed.event.market.Order;
import com.dxfeed.event.market.OrderSource;
import com.dxfeed.event.market.Scope;
import com.dxfeed.event.market.Side;
import java.util.Collections;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OrderEventFlagsTest {
    private static final int PORT = 4455;
    private static final String SYMBOL = "IBM";
    private static final String MARKET_MAKER = "TEST";
    private DXEndpoint publisherEndpoint;
    private DXEndpoint feedEndpoint;
    private final BlockingQueue<Object> subQueue = new ArrayBlockingQueue<Object>(10);
    private final BlockingQueue<Order> orderQeuue = new ArrayBlockingQueue<Order>(10);

    @Before
    public void setUp() throws Exception {
        ThreadCleanCheck.before();
        this.publisherEndpoint = DXEndpoint.create((DXEndpoint.Role)DXEndpoint.Role.PUBLISHER);
        this.feedEndpoint = DXEndpoint.create((DXEndpoint.Role)DXEndpoint.Role.FEED);
    }

    @After
    public void tearDown() throws Exception {
        this.feedEndpoint.close();
        this.publisherEndpoint.close();
        ThreadCleanCheck.after();
    }

    @Test
    public void testOrderEventFlags() throws InterruptedException {
        IndexedEventSubscriptionSymbol subSymbol;
        this.publisherEndpoint.connect(":4455");
        this.feedEndpoint.connect("localhost:4455");
        IndexedEventSubscriptionSymbol expectedSubSymbol = new IndexedEventSubscriptionSymbol((Object)SYMBOL, (IndexedEventSource)OrderSource.DEFAULT);
        DXFeedSubscription sub = this.feedEndpoint.getFeed().createSubscription(Order.class);
        sub.addEventListener(this.orderQeuue::addAll);
        sub.addSymbols((Object)expectedSubSymbol);
        this.publisherEndpoint.getPublisher().getSubscription(Order.class).addChangeListener(this.subQueue::addAll);
        while (!expectedSubSymbol.equals((Object)(subSymbol = (IndexedEventSubscriptionSymbol)this.subQueue.poll(10L, TimeUnit.SECONDS)))) {
        }
        Order pub1 = new Order(SYMBOL);
        pub1.setOrderSide(Side.BUY);
        pub1.setMarketMaker(MARKET_MAKER);
        pub1.setScope(Scope.ORDER);
        pub1.setEventFlags(14);
        this.publisherEndpoint.getPublisher().publishEvents(Collections.singleton(pub1));
        Order got1 = this.orderQeuue.poll(10L, TimeUnit.SECONDS);
        Assert.assertEquals((Object)SYMBOL, (Object)got1.getEventSymbol());
        Assert.assertEquals((long)0L, (long)got1.getIndex());
        Assert.assertEquals((long)14L, (long)got1.getEventFlags());
        Order pub2 = new Order(SYMBOL);
        pub2.setOrderSide(Side.BUY);
        pub2.setMarketMaker(MARKET_MAKER);
        pub2.setScope(Scope.ORDER);
        pub2.setPrice(123.45);
        pub2.setSize(67L);
        pub2.setIndex(1L);
        this.publisherEndpoint.getPublisher().publishEvents(Collections.singleton(pub2));
        Order got2 = this.orderQeuue.poll(10L, TimeUnit.SECONDS);
        Assert.assertEquals((Object)SYMBOL, (Object)got2.getEventSymbol());
        Assert.assertEquals((Object)Side.BUY, (Object)got2.getOrderSide());
        Assert.assertEquals((Object)MARKET_MAKER, (Object)got2.getMarketMaker());
        Assert.assertEquals((Object)Scope.ORDER, (Object)got2.getScope());
        Assert.assertEquals((double)123.45, (double)got2.getPrice(), (double)0.0);
        Assert.assertEquals((long)67L, (long)got2.getSize());
        Assert.assertEquals((long)1L, (long)got2.getIndex());
        Assert.assertEquals((long)0L, (long)got2.getEventFlags());
    }
}

