/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.api.test;

import com.devexperts.test.ThreadCleanCheck;
import com.devexperts.test.isolated.Isolated;
import com.devexperts.test.isolated.IsolatedParametersRunnerFactory;
import com.devexperts.util.SystemProperties;
import com.dxfeed.api.DXEndpoint;
import com.dxfeed.api.DXFeedSubscription;
import com.dxfeed.api.osub.IndexedEventSubscriptionSymbol;
import com.dxfeed.api.osub.ObservableSubscriptionChangeListener;
import com.dxfeed.event.IndexedEventSource;
import com.dxfeed.event.market.MarketEventSymbols;
import com.dxfeed.event.market.MarketMaker;
import com.dxfeed.event.market.Order;
import com.dxfeed.event.market.OrderSource;
import com.dxfeed.event.market.Quote;
import com.dxfeed.event.market.Side;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Parameterized.UseParametersRunnerFactory(value=IsolatedParametersRunnerFactory.class)
@Isolated(value={"com.dxfeed.api", "com.dxfeed.event", "com.devexperts.qd", "com.devexperts.rmi"})
public class OrderSourceTest {
    private final Queue<Runnable> tasks = new ArrayDeque<Runnable>();
    private final Queue<Object> addOrderSub = new ArrayDeque<Object>();
    private final Queue<Object> removeOrderSub = new ArrayDeque<Object>();
    private final Queue<Object> addQuoteSub = new ArrayDeque<Object>();
    private final Queue<Object> removeQuoteSub = new ArrayDeque<Object>();
    private final Queue<Object> addMarketMakerSub = new ArrayDeque<Object>();
    private final Queue<Object> removeMarketMakerSub = new ArrayDeque<Object>();
    private final Queue<Order> orders = new ArrayDeque<Order>();
    private final Random rnd = new Random(20140930L);
    private DXEndpoint endpoint;
    private DXFeedSubscription<Order> sub;
    private boolean useUnitarySource;
    private String originUnitaryOrderSourceProp;
    @Parameterized.Parameter
    public String unitaryOrderSourceProp;

    @Parameterized.Parameters(name="unitaryOrderSourceProp={0}")
    public static List<String> params() {
        return Arrays.asList(null, "false", "true");
    }

    @Before
    public void setUp() throws Exception {
        ThreadCleanCheck.before();
        this.originUnitaryOrderSourceProp = this.setSystemProperty("dxscheme.unitaryOrderSource", this.unitaryOrderSourceProp);
        this.useUnitarySource = SystemProperties.getBooleanProperty((String)"dxscheme.unitaryOrderSource", (boolean)false);
        this.endpoint = DXEndpoint.create((DXEndpoint.Role)DXEndpoint.Role.LOCAL_HUB);
        this.sub = this.endpoint.getFeed().createSubscription(Order.class);
        this.endpoint.executor(this.tasks::add);
        this.endpoint.getPublisher().getSubscription(Order.class).addChangeListener(new ObservableSubscriptionChangeListener(){

            public void symbolsAdded(Set<?> symbols) {
                OrderSourceTest.this.addOrderSub.addAll(symbols);
            }

            public void symbolsRemoved(Set<?> symbols) {
                OrderSourceTest.this.removeOrderSub.addAll(symbols);
            }
        });
        this.endpoint.getPublisher().getSubscription(Quote.class).addChangeListener(new ObservableSubscriptionChangeListener(){

            public void symbolsAdded(Set<?> symbols) {
                OrderSourceTest.this.addQuoteSub.addAll(symbols);
            }

            public void symbolsRemoved(Set<?> symbols) {
                OrderSourceTest.this.removeQuoteSub.addAll(symbols);
            }
        });
        this.endpoint.getPublisher().getSubscription(MarketMaker.class).addChangeListener(new ObservableSubscriptionChangeListener(){

            public void symbolsAdded(Set<?> symbols) {
                OrderSourceTest.this.addMarketMakerSub.addAll(symbols);
            }

            public void symbolsRemoved(Set<?> symbols) {
                OrderSourceTest.this.removeMarketMakerSub.addAll(symbols);
            }
        });
        this.sub.addEventListener(this.orders::addAll);
    }

    @After
    public void tearDown() throws Exception {
        this.endpoint.close();
        this.setSystemProperty("dxscheme.unitaryOrderSource", this.originUnitaryOrderSourceProp);
    }

    private String setSystemProperty(String prop, String value) {
        return value != null ? System.setProperty(prop, value) : System.clearProperty(prop);
    }

    private void runTasks() {
        while (!this.tasks.isEmpty()) {
            this.tasks.poll().run();
        }
    }

    @Test
    public void testPubSubDepthSource() throws InterruptedException {
        this.checkPubSubDepthSource(OrderSource.DEFAULT);
        this.checkPubSubDepthSource(OrderSource.NTV);
        this.checkPubSubDepthSource(OrderSource.ISE);
    }

    private void checkPubSubDepthSource(OrderSource source) {
        String symbol = "TEST1";
        IndexedEventSubscriptionSymbol indexedSymbol = new IndexedEventSubscriptionSymbol((Object)symbol, (IndexedEventSource)source);
        this.sub.addSymbols((Object)indexedSymbol);
        this.runTasks();
        Assert.assertEquals((Object)indexedSymbol, (Object)this.addOrderSub.poll());
        Assert.assertEquals((long)0L, (long)this.addOrderSub.size());
        this.checkEventWithSource(symbol, source);
    }

    private void checkEventWithSource(String symbol, OrderSource source) {
        Order order = new Order(symbol);
        double expectedPrice = (double)(1234 + this.rnd.nextInt(1000)) * 0.01;
        Side expectedSide = this.rnd.nextBoolean() ? Side.BUY : Side.SELL;
        order.setSource(source);
        order.setPrice(expectedPrice);
        order.setOrderSide(expectedSide);
        this.endpoint.getPublisher().publishEvents(Collections.singletonList(order));
        this.runTasks();
        Order in = this.orders.poll();
        Assert.assertEquals((long)0L, (long)this.orders.size());
        Assert.assertEquals((Object)symbol, (Object)in.getEventSymbol());
        Assert.assertEquals((Object)source, (Object)in.getSource());
        Assert.assertEquals((double)expectedPrice, (double)in.getPrice(), (double)0.0);
        Assert.assertEquals((Object)expectedSide, (Object)in.getOrderSide());
    }

    @Test
    public void testPubSubAllSources() throws InterruptedException {
        String symbol = "TEST2";
        this.sub.addSymbols((Object)symbol);
        HashSet<IndexedEventSubscriptionSymbol> expectedOrderSub = new HashSet<IndexedEventSubscriptionSymbol>();
        for (OrderSource source : OrderSource.publishable(Order.class)) {
            expectedOrderSub.add(new IndexedEventSubscriptionSymbol((Object)symbol, (IndexedEventSource)source));
        }
        this.runTasks();
        Assert.assertEquals(expectedOrderSub, this.takeSubSet(this.addOrderSub));
        Assert.assertEquals(this.allQuotesSet(symbol), this.takeSubSet(this.addQuoteSub));
        for (OrderSource source : OrderSource.publishable(Order.class)) {
            Order order = new Order(symbol);
            int index = this.rnd.nextInt(100000);
            int size = this.rnd.nextInt(100000);
            order.setIndex((long)index);
            order.setSource(source);
            order.setSize((long)size);
            order.setOrderSide(this.rnd.nextBoolean() ? Side.BUY : Side.SELL);
            long composedIndex = order.getIndex();
            this.endpoint.getPublisher().publishEvents(Collections.singletonList(order));
            this.runTasks();
            Order in = this.orders.poll();
            Assert.assertEquals((long)0L, (long)this.orders.size());
            Assert.assertEquals((Object)symbol, (Object)in.getEventSymbol());
            Assert.assertEquals((Object)source, (Object)in.getSource());
            Assert.assertEquals((long)composedIndex, (long)in.getIndex());
            Assert.assertEquals((long)size, (long)in.getSize());
        }
        this.checkSyntheticQuoteOrders(symbol, '\u0000', this.useUnitarySource ? OrderSource.COMPOSITE : OrderSource.COMPOSITE_BID, this.useUnitarySource ? OrderSource.COMPOSITE : OrderSource.COMPOSITE_ASK);
        for (Object c : (Object)MarketEventSymbols.DEFAULT_EXCHANGES.toCharArray()) {
            this.checkSyntheticQuoteOrders(symbol, (char)c, this.useUnitarySource ? OrderSource.REGIONAL : OrderSource.REGIONAL_BID, this.useUnitarySource ? OrderSource.REGIONAL : OrderSource.REGIONAL_ASK);
        }
        this.checkAggregateMarketMakerOrders(symbol, this.useUnitarySource ? OrderSource.AGGREGATE : OrderSource.AGGREGATE_BID, this.useUnitarySource ? OrderSource.AGGREGATE : OrderSource.AGGREGATE_ASK);
    }

    private Set<Object> allQuotesSet(String symbol) {
        HashSet<Object> expectedQuoteSub = new HashSet<Object>();
        expectedQuoteSub.add(symbol);
        for (char c : MarketEventSymbols.DEFAULT_EXCHANGES.toCharArray()) {
            expectedQuoteSub.add(symbol + "&" + c);
        }
        return expectedQuoteSub;
    }

    private Set<Object> allMarketMakerSet(String symbol) {
        return new HashSet<Object>(Collections.singleton(symbol));
    }

    private Set<Object> takeSubSet(Queue<?> addSub) {
        HashSet<Object> subSet = new HashSet<Object>(addSub);
        addSub.clear();
        return subSet;
    }

    private void checkSyntheticQuoteOrders(String symbol, char exchange, OrderSource ... sources) {
        Quote quote = new Quote(MarketEventSymbols.changeExchangeCode((String)symbol, (char)exchange));
        int bidSize = this.rnd.nextInt(100000);
        int askSize = this.rnd.nextInt(100000);
        quote.setBidSize((long)bidSize);
        quote.setAskSize((long)askSize);
        this.endpoint.getPublisher().publishEvents(Collections.singletonList(quote));
        this.runTasks();
        this.checkReceivedOrders(symbol, exchange, sources, bidSize, askSize);
    }

    private void checkAggregateMarketMakerOrders(String symbol, OrderSource ... sources) {
        MarketMaker marketMaker = new MarketMaker(symbol);
        int bidSize = this.rnd.nextInt(100000);
        int askSize = this.rnd.nextInt(100000);
        marketMaker.setBidSize((double)bidSize);
        marketMaker.setAskSize((double)askSize);
        this.endpoint.getPublisher().publishEvents(Collections.singletonList(marketMaker));
        this.runTasks();
        this.checkReceivedOrders(symbol, '\u0000', sources, bidSize, askSize);
    }

    private void checkReceivedOrders(String symbol, char exchange, OrderSource[] sources, int bidSize, int askSize) {
        for (OrderSource source : sources) {
            Order order = this.orders.poll();
            Assert.assertNotNull((Object)order);
            Assert.assertEquals((Object)symbol, (Object)order.getEventSymbol());
            Assert.assertEquals((long)exchange, (long)order.getExchangeCode());
            Assert.assertEquals((Object)source, (Object)order.getSource());
            Assert.assertEquals((long)(order.getOrderSide() == Side.BUY ? (long)bidSize : (long)askSize), (long)order.getSize());
        }
        Assert.assertEquals((long)0L, (long)this.orders.size());
    }

    @Test
    public void testMixSources() throws InterruptedException {
        String symbol = "TEST3";
        IndexedEventSubscriptionSymbol subSeparateCompositeBid = new IndexedEventSubscriptionSymbol((Object)symbol, (IndexedEventSource)OrderSource.COMPOSITE_BID);
        IndexedEventSubscriptionSymbol subSeparateCompositeAsk = new IndexedEventSubscriptionSymbol((Object)symbol, (IndexedEventSource)OrderSource.COMPOSITE_ASK);
        IndexedEventSubscriptionSymbol subUnitaryComposite = new IndexedEventSubscriptionSymbol((Object)symbol, (IndexedEventSource)OrderSource.COMPOSITE);
        IndexedEventSubscriptionSymbol subSeparateAggregateBid = new IndexedEventSubscriptionSymbol((Object)symbol, (IndexedEventSource)OrderSource.AGGREGATE_BID);
        IndexedEventSubscriptionSymbol subSeparateAggregateAsk = new IndexedEventSubscriptionSymbol((Object)symbol, (IndexedEventSource)OrderSource.AGGREGATE_ASK);
        IndexedEventSubscriptionSymbol subUnitaryAggregate = new IndexedEventSubscriptionSymbol((Object)symbol, (IndexedEventSource)OrderSource.AGGREGATE);
        Arrays.asList(subSeparateCompositeBid, subSeparateCompositeAsk, subUnitaryComposite, subSeparateAggregateBid, subSeparateAggregateAsk, subUnitaryAggregate).forEach(s -> this.sub.addSymbols(s));
        this.runTasks();
        Assert.assertEquals((Object)symbol, (Object)this.addQuoteSub.poll());
        Assert.assertEquals((long)0L, (long)this.addQuoteSub.size());
        Assert.assertEquals((long)0L, (long)this.addOrderSub.size());
        Assert.assertEquals((Object)symbol, (Object)this.addMarketMakerSub.poll());
        Assert.assertEquals((long)0L, (long)this.addMarketMakerSub.size());
        Assert.assertEquals((long)0L, (long)this.addOrderSub.size());
        this.checkSyntheticQuoteOrders(symbol, '\u0000', OrderSource.COMPOSITE_BID, OrderSource.COMPOSITE_ASK, OrderSource.COMPOSITE, OrderSource.COMPOSITE);
        this.sub.removeSymbols(new Object[]{subSeparateCompositeBid, subUnitaryComposite});
        this.runTasks();
        Assert.assertEquals((long)0L, (long)this.addQuoteSub.size());
        Assert.assertEquals((long)0L, (long)this.removeQuoteSub.size());
        this.checkSyntheticQuoteOrders(symbol, '\u0000', OrderSource.COMPOSITE_ASK);
        this.sub.removeSymbols(new Object[]{subSeparateCompositeAsk});
        this.runTasks();
        Assert.assertEquals((long)0L, (long)this.addQuoteSub.size());
        Assert.assertEquals((Object)symbol, (Object)this.removeQuoteSub.poll());
        Assert.assertEquals((long)0L, (long)this.removeQuoteSub.size());
        this.checkAggregateMarketMakerOrders(symbol, OrderSource.AGGREGATE_BID, OrderSource.AGGREGATE_ASK, OrderSource.AGGREGATE, OrderSource.AGGREGATE);
        this.sub.removeSymbols(new Object[]{subSeparateAggregateBid, subUnitaryAggregate});
        this.runTasks();
        Assert.assertEquals((long)0L, (long)this.addMarketMakerSub.size());
        Assert.assertEquals((long)0L, (long)this.removeMarketMakerSub.size());
        this.checkAggregateMarketMakerOrders(symbol, OrderSource.AGGREGATE_ASK);
        this.sub.removeSymbols(new Object[]{subSeparateAggregateAsk});
        this.runTasks();
        Assert.assertEquals((long)0L, (long)this.addMarketMakerSub.size());
        Assert.assertEquals((Object)symbol, (Object)this.removeMarketMakerSub.poll());
        Assert.assertEquals((long)0L, (long)this.removeMarketMakerSub.size());
    }

    @Test
    public void testMixSourceAndGeneric() {
        String symbol = "TEST4";
        OrderSource source = OrderSource.ISE;
        IndexedEventSubscriptionSymbol subIse = new IndexedEventSubscriptionSymbol((Object)symbol, (IndexedEventSource)source);
        this.sub.addSymbols(new Object[]{subIse, symbol});
        this.runTasks();
        Assert.assertTrue((boolean)this.takeSubSet(this.addOrderSub).contains(subIse));
        Assert.assertEquals(this.allQuotesSet(symbol), this.takeSubSet(this.addQuoteSub));
        Assert.assertEquals(this.allMarketMakerSet(symbol), this.takeSubSet(this.addMarketMakerSub));
        this.checkEventWithSource(symbol, source);
        this.sub.removeSymbols(new Object[]{symbol});
        this.runTasks();
        Assert.assertEquals(Collections.emptySet(), this.takeSubSet(this.addOrderSub));
        Assert.assertEquals(Collections.emptySet(), this.takeSubSet(this.addQuoteSub));
        Assert.assertEquals(Collections.emptySet(), this.takeSubSet(this.addMarketMakerSub));
        Assert.assertFalse((boolean)this.takeSubSet(this.removeOrderSub).contains(subIse));
        Assert.assertEquals(this.allQuotesSet(symbol), this.takeSubSet(this.removeQuoteSub));
        Assert.assertEquals(this.allMarketMakerSet(symbol), this.takeSubSet(this.removeMarketMakerSub));
        this.checkEventWithSource(symbol, source);
        this.sub.removeSymbols(new Object[]{subIse});
        this.runTasks();
        Assert.assertEquals(Collections.emptySet(), this.takeSubSet(this.addOrderSub));
        Assert.assertEquals(Collections.emptySet(), this.takeSubSet(this.addQuoteSub));
        Assert.assertEquals(Collections.emptySet(), this.takeSubSet(this.addMarketMakerSub));
        Assert.assertEquals(Collections.singleton(subIse), this.takeSubSet(this.removeOrderSub));
    }

    @Test
    public void testUnitarySourceBidAskOrder() {
        String symbol = "TEST5";
        List<OrderSource> sources = Arrays.asList(OrderSource.COMPOSITE_BID, OrderSource.COMPOSITE_ASK, OrderSource.COMPOSITE, OrderSource.AGGREGATE_BID, OrderSource.AGGREGATE_ASK, OrderSource.AGGREGATE, OrderSource.NTV);
        for (int i = 0; i < 1000; ++i) {
            Order order;
            sources.forEach(source -> this.sub.addSymbols((Object)new IndexedEventSubscriptionSymbol((Object)symbol, (IndexedEventSource)source)));
            int bidSize = this.rnd.nextInt(100000);
            int askSize = this.rnd.nextInt(100000);
            MarketMaker marketMaker = new MarketMaker(symbol);
            marketMaker.setBidSize((double)bidSize);
            marketMaker.setAskSize((double)askSize);
            Quote quote = new Quote(symbol);
            quote.setBidSize((long)bidSize);
            quote.setAskSize((long)askSize);
            Order pubOrder = new Order(symbol);
            pubOrder.setSource(OrderSource.NTV);
            pubOrder.setOrderSide(Side.BUY);
            pubOrder.setSize((long)bidSize);
            this.endpoint.getPublisher().publishEvents(Arrays.asList(quote, marketMaker, pubOrder));
            this.runTasks();
            Assert.assertEquals((long)(sources.size() + 2), (long)this.orders.size());
            int compositeOrderCount = 0;
            int aggregateOrderCount = 0;
            while ((order = this.orders.poll()) != null) {
                OrderSource source2 = order.getSource();
                if (source2 != OrderSource.COMPOSITE && source2 != OrderSource.AGGREGATE) continue;
                Assert.assertEquals((Object)symbol, (Object)order.getEventSymbol());
                Assert.assertEquals((String)("Bid side is expected first. Current order of sources in subscription: " + sources), (Object)Side.BUY, (Object)order.getOrderSide());
                Assert.assertEquals((long)bidSize, (long)order.getSize());
                order = this.orders.poll();
                Assert.assertNotNull((Object)order);
                Assert.assertEquals((Object)symbol, (Object)order.getEventSymbol());
                Assert.assertEquals((Object)source2, (Object)order.getSource());
                Assert.assertEquals((String)("Ask side is expected second. Current order of sources in subscription: " + sources), (Object)Side.SELL, (Object)order.getOrderSide());
                Assert.assertEquals((long)askSize, (long)order.getSize());
                if (source2 == OrderSource.COMPOSITE) {
                    compositeOrderCount += 2;
                }
                if (source2 != OrderSource.AGGREGATE) continue;
                aggregateOrderCount += 2;
            }
            Assert.assertEquals((long)2L, (long)compositeOrderCount);
            Assert.assertEquals((long)2L, (long)aggregateOrderCount);
            Collections.shuffle(sources, this.rnd);
            this.sub.clear();
        }
    }

    @Test
    public void testUnitarySourceEventFlags() {
        String symbol = "TEST6";
        this.sub.addSymbols((Object)new IndexedEventSubscriptionSymbol((Object)symbol, (IndexedEventSource)OrderSource.AGGREGATE));
        this.publishMarketMaker(symbol, 2, 1.0, 2.0, 4);
        this.publishMarketMaker(symbol, 1, 3.0, 4.0, 0);
        this.publishMarketMaker(symbol, 0, Double.NaN, Double.NaN, 10);
        this.runTasks();
        this.checkOrder(symbol, 2, Side.BUY, 1.0, 5);
        this.checkOrder(symbol, 2, Side.SELL, 2.0, 0);
        this.checkOrder(symbol, 1, Side.BUY, 3.0, 1);
        this.checkOrder(symbol, 1, Side.SELL, 4.0, 0);
        this.checkOrder(symbol, 0, Side.BUY, Double.NaN, 3);
        this.checkOrder(symbol, 0, Side.SELL, Double.NaN, 10);
        this.publishMarketMaker(symbol, 3, 5.0, 6.0, 1);
        this.publishMarketMaker(symbol, 4, 7.0, 8.0, 0);
        this.runTasks();
        this.checkOrder(symbol, 3, Side.BUY, 5.0, 1);
        this.checkOrder(symbol, 3, Side.SELL, 6.0, 1);
        this.checkOrder(symbol, 4, Side.BUY, 7.0, 1);
        this.checkOrder(symbol, 4, Side.SELL, 8.0, 0);
        this.publishMarketMaker(symbol, 4, Double.NaN, Double.NaN, 2);
        this.runTasks();
        this.checkOrder(symbol, 4, Side.BUY, Double.NaN, 3);
        this.checkOrder(symbol, 4, Side.SELL, Double.NaN, 2);
        Assert.assertEquals((long)0L, (long)this.orders.size());
    }

    private void publishMarketMaker(String symbol, int index, double bidSize, double askSize, int eventFlags) {
        MarketMaker event = new MarketMaker(symbol);
        event.setIndex((long)index);
        event.setBidSize(bidSize);
        event.setAskSize(askSize);
        event.setEventFlags(eventFlags);
        this.endpoint.getPublisher().publishEvents(Collections.singleton(event));
    }

    private void checkOrder(String symbol, int index, Side side, double size, int eventFlags) {
        Order order = this.orders.poll();
        Assert.assertNotNull((Object)order);
        Assert.assertEquals((Object)symbol, (Object)order.getEventSymbol());
        Assert.assertEquals((long)index, (long)(order.getIndex() & 0xFFFFFFFFL));
        Assert.assertEquals((Object)side, (Object)order.getOrderSide());
        Assert.assertEquals((double)size, (double)order.getSizeAsDouble(), (double)0.0);
        Assert.assertEquals((long)eventFlags, (long)order.getEventFlags());
    }
}

