/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.api.test;

import com.devexperts.test.ThreadCleanCheck;
import com.dxfeed.api.DXEndpoint;
import com.dxfeed.api.DXFeed;
import com.dxfeed.api.DXFeedSubscription;
import com.dxfeed.api.DXPublisher;
import com.dxfeed.event.market.AnalyticOrder;
import com.dxfeed.event.market.Order;
import com.dxfeed.event.market.OtcMarketsOrder;
import com.dxfeed.event.market.Quote;
import com.dxfeed.event.market.Scope;
import com.dxfeed.event.market.Side;
import java.util.Collections;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OrderTest {
    private static final String SYMBOL = "TEST";
    private DXEndpoint endpoint;
    private DXFeed feed;
    private DXPublisher publisher;
    private DXFeedSubscription<Order> sub;
    private final BlockingQueue<Order> queue = new ArrayBlockingQueue<Order>(10);
    private final long t0 = System.currentTimeMillis() / 1000L * 1000L;
    private final long t1 = this.t0 - 1000L;

    @Before
    public void setUp() throws Exception {
        ThreadCleanCheck.before();
        this.endpoint = DXEndpoint.create((DXEndpoint.Role)DXEndpoint.Role.LOCAL_HUB);
        this.feed = this.endpoint.getFeed();
        this.publisher = this.endpoint.getPublisher();
        this.sub = this.feed.createSubscription(Order.class);
        this.sub.addEventListener(this.queue::addAll);
        this.sub.addSymbols((Object)SYMBOL);
    }

    @After
    public void tearDown() throws Exception {
        this.endpoint.close();
        ThreadCleanCheck.after();
    }

    @Test
    public void testCompositeOrders() throws InterruptedException {
        Quote composite = new Quote(SYMBOL);
        composite.setBidExchangeCode('A');
        composite.setBidPrice(12.34);
        composite.setBidSize(10L);
        composite.setBidTime(this.t0);
        composite.setAskExchangeCode('B');
        composite.setAskPrice(12.35);
        composite.setAskSize(11L);
        composite.setAskTime(this.t1);
        this.publisher.publishEvents(Collections.singleton(composite));
        Order o1 = this.queue.take();
        Order o2 = this.queue.take();
        if (o1.getOrderSide() == Side.SELL) {
            Order tmp = o1;
            o1 = o2;
            o2 = tmp;
        }
        Assert.assertEquals((Object)SYMBOL, (Object)o1.getEventSymbol());
        Assert.assertEquals((Object)Side.BUY, (Object)o1.getOrderSide());
        Assert.assertEquals((Object)Scope.COMPOSITE, (Object)o1.getScope());
        Assert.assertEquals((long)65L, (long)o1.getExchangeCode());
        Assert.assertEquals((double)12.34, (double)o1.getPrice(), (double)0.0);
        Assert.assertEquals((long)10L, (long)o1.getSize());
        Assert.assertEquals((long)this.t0, (long)o1.getTime());
        Assert.assertEquals((Object)SYMBOL, (Object)o2.getEventSymbol());
        Assert.assertEquals((Object)Side.SELL, (Object)o2.getOrderSide());
        Assert.assertEquals((Object)Scope.COMPOSITE, (Object)o2.getScope());
        Assert.assertEquals((long)66L, (long)o2.getExchangeCode());
        Assert.assertEquals((double)12.35, (double)o2.getPrice(), (double)0.0);
        Assert.assertEquals((long)11L, (long)o2.getSize());
        Assert.assertEquals((long)this.t1, (long)o2.getTime());
    }

    @Test
    public void testRegionalOrders() throws InterruptedException {
        Quote composite = new Quote("TEST&Z");
        composite.setBidPrice(12.34);
        composite.setBidSize(10L);
        composite.setBidTime(this.t0);
        composite.setAskPrice(12.35);
        composite.setAskSize(11L);
        composite.setAskTime(this.t1);
        this.publisher.publishEvents(Collections.singleton(composite));
        Order o1 = this.queue.take();
        Order o2 = this.queue.take();
        if (o1.getOrderSide() == Side.SELL) {
            Order tmp = o1;
            o1 = o2;
            o2 = tmp;
        }
        Assert.assertEquals((Object)SYMBOL, (Object)o1.getEventSymbol());
        Assert.assertEquals((Object)Side.BUY, (Object)o1.getOrderSide());
        Assert.assertEquals((Object)Scope.REGIONAL, (Object)o1.getScope());
        Assert.assertEquals((long)90L, (long)o1.getExchangeCode());
        Assert.assertEquals((double)12.34, (double)o1.getPrice(), (double)0.0);
        Assert.assertEquals((long)10L, (long)o1.getSize());
        Assert.assertEquals((long)this.t0, (long)o1.getTime());
        Assert.assertEquals((Object)SYMBOL, (Object)o2.getEventSymbol());
        Assert.assertEquals((Object)Side.SELL, (Object)o2.getOrderSide());
        Assert.assertEquals((Object)Scope.REGIONAL, (Object)o2.getScope());
        Assert.assertEquals((long)90L, (long)o2.getExchangeCode());
        Assert.assertEquals((double)12.35, (double)o2.getPrice(), (double)0.0);
        Assert.assertEquals((long)11L, (long)o2.getSize());
        Assert.assertEquals((long)this.t1, (long)o2.getTime());
    }

    @Test
    public void testOrder() throws InterruptedException {
        Order order = new Order(SYMBOL);
        order.setOrderSide(Side.BUY);
        order.setMarketMaker("NSDQ");
        order.setScope(Scope.ORDER);
        order.setPrice(10.0);
        order.setSize(1L);
        order.setIndex(1L);
        this.publisher.publishEvents(Collections.singleton(order));
        Order received = this.queue.take();
        Assert.assertEquals((Object)SYMBOL, (Object)received.getEventSymbol());
        Assert.assertEquals((Object)Side.BUY, (Object)received.getOrderSide());
        Assert.assertEquals((Object)Scope.ORDER, (Object)received.getScope());
        Assert.assertEquals((double)10.0, (double)received.getPrice(), (double)0.0);
        Assert.assertEquals((long)1L, (long)received.getSize());
    }

    @Test
    public void testAnalyticOrderNotReceived() throws InterruptedException {
        AnalyticOrder analyticOrder = new AnalyticOrder(SYMBOL);
        analyticOrder.setOrderSide(Side.BUY);
        analyticOrder.setMarketMaker("NSDQ");
        analyticOrder.setScope(Scope.ORDER);
        analyticOrder.setPrice(10.0);
        analyticOrder.setSize(1L);
        analyticOrder.setIndex(1L);
        this.publisher.publishEvents(Collections.singleton(analyticOrder));
        Order received = this.queue.poll(2L, TimeUnit.SECONDS);
        Assert.assertNull((Object)received);
    }

    @Test
    public void testOtcMarketsOrderNotReceived() throws InterruptedException {
        OtcMarketsOrder otcMarketsOrder = new OtcMarketsOrder(SYMBOL);
        otcMarketsOrder.setOrderSide(Side.BUY);
        otcMarketsOrder.setMarketMaker("NSDQ");
        otcMarketsOrder.setScope(Scope.ORDER);
        otcMarketsOrder.setPrice(10.0);
        otcMarketsOrder.setSize(1L);
        otcMarketsOrder.setIndex(1L);
        this.publisher.publishEvents(Collections.singleton(otcMarketsOrder));
        Order received = this.queue.poll(2L, TimeUnit.SECONDS);
        Assert.assertNull((Object)received);
    }
}

