/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.api.test;

import com.devexperts.connector.proto.ApplicationConnectionFactory;
import com.devexperts.qd.QDFactory;
import com.devexperts.qd.QDTicker;
import com.devexperts.qd.qtp.AgentAdapter;
import com.devexperts.qd.qtp.MessageAdapter;
import com.devexperts.qd.qtp.MessageConnector;
import com.devexperts.qd.qtp.MessageConnectors;
import com.devexperts.qd.qtp.ProtocolDescriptor;
import com.devexperts.qd.samplecert.SampleCert;
import com.devexperts.qd.stats.QDStats;
import com.devexperts.test.ThreadCleanCheck;
import com.dxfeed.api.DXEndpoint;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SSLUserPasswordTest {
    private static final int PORT = (new Random().nextInt(100) + 100) * 100 + 81;
    private List<MessageConnector> serverConnectors;
    private DXEndpoint dx;
    private final BlockingQueue<String> receivedAuth = new ArrayBlockingQueue<String>(1);

    @Before
    public void setUp() throws Exception {
        ThreadCleanCheck.before();
    }

    @After
    public void tearDown() throws Exception {
        if (this.dx != null) {
            this.dx.close();
        }
        if (this.serverConnectors != null) {
            MessageConnectors.stopMessageConnectors(this.serverConnectors);
        }
        ThreadCleanCheck.after();
    }

    @Test
    public void testSSLUserPassword() throws InterruptedException {
        SampleCert.init();
        this.serverConnectors = MessageConnectors.createMessageConnectors((ApplicationConnectionFactory)MessageConnectors.applicationConnectionFactory((MessageAdapter.Factory)new AuthAgentAdapterFactory()), (String)("ssl[isServer=true," + SampleCert.KEY_STORE_CONFIG + "]+:" + PORT));
        MessageConnectors.startMessageConnectors(this.serverConnectors);
        this.dx = DXEndpoint.create().user("demo").password("demo").connect("ssl[" + SampleCert.TRUST_STORE_CONFIG + "]+localhost:" + PORT);
        Assert.assertNotNull((Object)this.receivedAuth.poll(10L, TimeUnit.SECONDS));
    }

    private class AuthAgentAdapterFactory
    implements MessageAdapter.Factory {
        private AuthAgentAdapterFactory() {
        }

        public MessageAdapter createAdapter(QDStats stats) {
            return new AuthAgentAdapter(stats);
        }
    }

    private class AuthAgentAdapter
    extends AgentAdapter {
        AuthAgentAdapter(QDStats stats) {
            super(null, (QDTicker)QDFactory.getDefaultFactory().tickerBuilder().withScheme(QDFactory.getDefaultScheme()).build(), null, null, null, null, stats);
        }

        public void processDescribeProtocol(ProtocolDescriptor desc, boolean logDescriptor) {
            super.processDescribeProtocol(desc, logDescriptor);
            String auth = desc.getProperty("authorization");
            if (auth != null) {
                SSLUserPasswordTest.this.receivedAuth.add(auth);
            }
        }
    }
}

