/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.api.test;

import com.devexperts.test.ThreadCleanCheck;
import com.dxfeed.api.DXEndpoint;
import com.dxfeed.api.DXFeed;
import com.dxfeed.api.DXFeedSubscription;
import com.dxfeed.api.DXPublisher;
import com.dxfeed.event.LastingEvent;
import com.dxfeed.event.misc.TextConfiguration;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.List;
import java.util.Queue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TextConfigurationTest {
    private static final String SYMBOL = "TEST";
    private final Queue<TextConfiguration> receivedEvents = new ArrayDeque<TextConfiguration>();
    private DXEndpoint endpoint;
    private DXFeed feed;
    private DXPublisher publisher;
    private DXFeedSubscription<TextConfiguration> sub;
    @Parameterized.Parameter
    public boolean isVersionFieldEnabled;

    @Parameterized.Parameters(name="isVersionFieldEnabled:{0}")
    public static List<Boolean> params() {
        return Arrays.asList(true, false);
    }

    @Before
    public void setUp() {
        ThreadCleanCheck.before();
        this.endpoint = DXEndpoint.newBuilder().withRole(DXEndpoint.Role.LOCAL_HUB).withProperty("dxscheme.enabled.Version", this.isVersionFieldEnabled ? "*" : "").build();
        this.endpoint.executor(Runnable::run);
        this.feed = this.endpoint.getFeed();
        this.publisher = this.endpoint.getPublisher();
        this.sub = this.feed.createSubscription(TextConfiguration.class);
        this.sub.addEventListener(this.receivedEvents::addAll);
        this.sub.addSymbols((Object)SYMBOL);
    }

    @After
    public void tearDown() {
        this.sub.close();
        this.endpoint.close();
        ThreadCleanCheck.after();
    }

    @Test
    public void testConflation() {
        TextConfiguration one = this.createTextConfiguration(100L, 1, "one", 1);
        TextConfiguration two = this.createTextConfiguration(200L, 2, "two", 2);
        TextConfiguration three = this.createTextConfiguration(300L, 3, "three", 3);
        this.publishEvents(one, two, three);
        this.assertOnlyOneEventReceived();
        this.assertReceivedEvent(three);
        this.assertLastEvent(three);
    }

    @Test
    public void testConflationWithEnabledVersionField() {
        Assume.assumeTrue((boolean)this.isVersionFieldEnabled);
        TextConfiguration two = this.createTextConfiguration(200L, 2, "two", 2);
        TextConfiguration three = this.createTextConfiguration(300L, 3, "three", 3);
        TextConfiguration one = this.createTextConfiguration(100L, 1, "one", 1);
        this.publishEvents(two, three, one);
        this.assertOnlyOneEventReceived();
        this.assertReceivedEvent(three);
        this.assertLastEvent(three);
        this.publishEvents(one, two);
        Assert.assertTrue((boolean)this.receivedEvents.isEmpty());
        three.setText("new three");
        this.publishEvents(three);
        this.assertReceivedEvent(three);
        TextConfiguration four = this.createTextConfiguration(400L, 4, "four", 4);
        this.publishEvents(four);
        this.assertReceivedEvent(four);
        this.assertLastEvent(four);
    }

    @Test
    public void testConflationWithDisabledVersionField() {
        Assume.assumeTrue((!this.isVersionFieldEnabled ? 1 : 0) != 0);
        TextConfiguration two = this.createTextConfiguration(200L, 2, "two", 2);
        TextConfiguration three = this.createTextConfiguration(300L, 3, "three", 3);
        TextConfiguration one = this.createTextConfiguration(100L, 1, "one", 1);
        this.publishEvents(two, three, one);
        this.assertOnlyOneEventReceived();
        this.assertReceivedEvent(one);
        this.assertLastEvent(one);
    }

    @Test
    public void testEmptyTextConfiguration() {
        TextConfiguration conf = new TextConfiguration();
        Assert.assertNull((Object)conf.getEventSymbol());
        Assert.assertEquals((long)0L, (long)conf.getTime());
        Assert.assertEquals((long)0L, (long)conf.getSequence());
        Assert.assertEquals((long)0L, (long)conf.getVersion());
        Assert.assertNull((Object)conf.getText());
    }

    private void assertOnlyOneEventReceived() {
        Assert.assertEquals((long)1L, (long)this.receivedEvents.size());
    }

    private void assertReceivedEvent(TextConfiguration expected) {
        this.assertEvent(expected, this.receivedEvents.poll());
    }

    private void assertLastEvent(TextConfiguration expected) {
        this.assertEvent(expected, (TextConfiguration)this.feed.getLastEvent((LastingEvent)new TextConfiguration(SYMBOL)));
    }

    private void assertEvent(TextConfiguration expected, TextConfiguration actual) {
        Assert.assertNotNull((Object)actual);
        Assert.assertEquals((Object)expected.getEventSymbol(), (Object)actual.getEventSymbol());
        Assert.assertEquals((long)expected.getTime(), (long)actual.getTime());
        Assert.assertEquals((long)expected.getSequence(), (long)actual.getSequence());
        Assert.assertEquals((Object)expected.getText(), (Object)actual.getText());
        Assert.assertEquals((long)(this.isVersionFieldEnabled ? (long)expected.getVersion() : 0L), (long)actual.getVersion());
    }

    private TextConfiguration createTextConfiguration(long time, int sequence, String text, int version) {
        TextConfiguration conf = new TextConfiguration(SYMBOL);
        conf.setTime(time);
        conf.setSequence(sequence);
        conf.setText(text);
        conf.setVersion(version);
        return conf;
    }

    private void publishEvents(TextConfiguration ... conf) {
        this.publisher.publishEvents(Arrays.asList(conf));
    }
}

