/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.model;

import com.devexperts.test.ThreadCleanCheck;
import com.dxfeed.api.DXEndpoint;
import com.dxfeed.api.DXFeed;
import com.dxfeed.api.DXPublisher;
import com.dxfeed.api.osub.IndexedEventSubscriptionSymbol;
import com.dxfeed.event.IndexedEventSource;
import com.dxfeed.event.market.Order;
import com.dxfeed.event.market.OrderSource;
import com.dxfeed.event.market.Side;
import com.dxfeed.model.IndexedEventTxModel;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IndexedEventTxModelTest {
    private static final String SYMBOL = "TEST-SYMBOL";
    private static final IndexedEventSource SOURCE = IndexedEventSource.DEFAULT;
    private final List<Order> publishedEvents = new ArrayList<Order>();
    private final Queue<Order> receivedEvents = new ArrayDeque<Order>();
    private DXEndpoint endpoint;
    private DXFeed feed;
    private DXPublisher publisher;
    private IndexedEventTxModel<Order> model;
    private int listenerNotificationCounter;
    private int snapshotNotificationCounter;

    @Before
    public void setUp() {
        ThreadCleanCheck.before();
        this.endpoint = DXEndpoint.create((DXEndpoint.Role)DXEndpoint.Role.LOCAL_HUB);
        this.feed = this.endpoint.getFeed();
        this.publisher = this.endpoint.getPublisher();
    }

    @After
    public void tearDown() {
        this.snapshotNotificationCounter = 0;
        this.listenerNotificationCounter = 0;
        this.receivedEvents.clear();
        this.publishedEvents.clear();
        this.model.close();
        this.endpoint.close();
        ThreadCleanCheck.after();
    }

    @Test
    public void testInitialState() {
        IndexedEventTxModel.Builder builder = IndexedEventTxModel.newBuilder(Order.class);
        Assert.assertThrows(NullPointerException.class, () -> ((IndexedEventTxModel.Builder)builder).build());
        builder.withSymbol(SYMBOL);
        Assert.assertThrows(NullPointerException.class, () -> ((IndexedEventTxModel.Builder)builder).build());
        builder.withSource(SOURCE);
        Assert.assertThrows(NullPointerException.class, () -> ((IndexedEventTxModel.Builder)builder).build());
        this.model = builder.withListener((events, isSnapshot) -> {}).build();
        Assert.assertEquals((Object)SYMBOL, (Object)this.model.getSymbol());
        Assert.assertEquals((Object)SOURCE, (Object)this.model.getSource());
        Assert.assertFalse((boolean)this.model.isClosed());
        this.model.close();
        IndexedEventSubscriptionSymbol symbol = new IndexedEventSubscriptionSymbol((Object)"TEST", (IndexedEventSource)OrderSource.ntv);
        this.model = builder.withSymbol(symbol).build();
        Assert.assertEquals((Object)symbol, (Object)this.model.getIndexedEventSubscriptionSymbol());
        Assert.assertFalse((boolean)this.model.isClosed());
    }

    @Test
    public void testSnapshotAndUpdate() {
        this.model = this.builder().build();
        this.addOrderToPublish(1, 1.0, 4);
        this.addOrderToPublish(0, 2.0, 8);
        this.addOrderToPublish(1, 3.0);
        this.addOrderToPublish(3, 4.0);
        this.addOrderToPublish(2, 5.0);
        this.publishDeferred(false);
        this.assertSnapshotNotification(1);
        this.assertListenerNotification(2);
        this.assertReceivedEventCount(5);
        this.assertOrder(1, 1.0, 0);
        this.assertOrder(0, 2.0, 0);
        this.assertOrder(1, 3.0, 0);
        this.assertOrder(3, 4.0, 0);
        this.assertOrder(2, 5.0, 0);
    }

    @Test
    public void testEmptySnapshot() {
        this.model = this.builder().build();
        this.addOrderToPublish(0, 1.0, 14);
        this.publishDeferred(false);
        this.assertSnapshotNotification(1);
        this.assertReceivedEventCount(0);
    }

    @Test
    public void testSnapshotWithPending() {
        this.model = this.builder().build();
        this.addOrderToPublish(1, 1.0, 4);
        this.publishDeferred(false);
        this.assertIsChanged(false);
        this.assertReceivedEventCount(0);
        this.addOrderToPublish(0, 2.0, 9);
        this.publishDeferred(false);
        this.assertIsChanged(false);
        this.addOrderToPublish(1, 3.0);
        this.publishDeferred(false);
        this.assertListenerNotification(1);
        this.assertSnapshotNotification(1);
        this.assertReceivedEventCount(2);
        this.assertOrder(1, 3.0, 0);
        this.assertOrder(0, 2.0, 0);
    }

    @Test
    public void testMultipleSnapshot() {
        this.model = this.builder().build();
        this.addOrderToPublish(1, 1.0, 4);
        this.publishDeferred(false);
        this.assertIsChanged(false);
        this.assertReceivedEventCount(0);
        this.addOrderToPublish(0, 2.0, 8);
        this.addOrderToPublish(2, 3.0, 4);
        this.publishDeferred(false);
        this.assertListenerNotification(1);
        this.assertSnapshotNotification(1);
        this.assertReceivedEventCount(2);
        this.assertOrder(1, 1.0, 0);
        this.assertOrder(0, 2.0, 0);
        this.addOrderToPublish(0, 4.0, 8);
        this.addOrderToPublish(3, 5.0);
        this.publishDeferred(false);
        this.assertSnapshotNotification(1);
        this.assertListenerNotification(2);
        this.assertReceivedEventCount(3);
        this.assertOrder(2, 3.0, 0);
        this.assertOrder(0, 4.0, 0);
        this.assertOrder(3, 5.0, 0);
    }

    @Test
    public void testMultipleSnapshotInOneBatch() {
        this.model = this.builder().build();
        this.addOrderToPublish(0, 1.0, 12);
        this.addOrderToPublish(0, 2.0, 20);
        this.addOrderToPublish(0, 3.0, 30);
        this.publishDeferred(false);
        this.assertListenerNotification(3);
        this.assertSnapshotNotification(3);
        this.assertReceivedEventCount(2);
        this.assertOrder(0, 1.0, 0);
        this.assertOrder(0, 2.0, 0);
    }

    @Test
    public void testMultipleSnapshotWithUpdatesInOneBatch() {
        this.model = this.builder().build();
        this.addOrderToPublish(0, 1.0, 12);
        this.addOrderToPublish(1, 2.0);
        this.addOrderToPublish(2, 3.0);
        this.addOrderToPublish(0, 4.0, 20);
        this.addOrderToPublish(1, 5.0);
        this.addOrderToPublish(0, 6.0, 30);
        this.addOrderToPublish(1, 7.0);
        this.publishDeferred(false);
        this.assertSnapshotNotification(3);
        this.assertListenerNotification(6);
        this.assertReceivedEventCount(6);
        this.assertOrder(0, 1.0, 0);
        this.assertOrder(1, 2.0, 0);
        this.assertOrder(2, 3.0, 0);
        this.assertOrder(0, 4.0, 0);
        this.assertOrder(1, 5.0, 0);
        this.assertOrder(1, 7.0, 0);
    }

    @Test
    public void testIncompleteSnapshot() {
        this.model = this.builder().build();
        this.addOrderToPublish(1, 1.0, 4);
        this.publishDeferred(false);
        this.assertIsChanged(false);
        this.assertReceivedEventCount(0);
        this.addOrderToPublish(2, 2.0, 4);
        this.addOrderToPublish(3, 3.0);
        this.publishDeferred(false);
        this.assertIsChanged(false);
        this.assertReceivedEventCount(0);
        this.addOrderToPublish(4, 4.0, 4);
        this.publishDeferred(false);
        this.assertIsChanged(false);
        this.assertReceivedEventCount(0);
        this.addOrderToPublish(0, 5.0, 8);
        this.addOrderToPublish(5, 6.0);
        this.addOrderToPublish(6, 7.0);
        this.publishDeferred(false);
        this.assertListenerNotification(2);
        this.assertSnapshotNotification(1);
        this.assertReceivedEventCount(4);
        this.assertOrder(4, 4.0, 0);
        this.assertOrder(0, 5.0, 0);
        this.assertOrder(5, 6.0, 0);
        this.assertOrder(6, 7.0, 0);
        this.addOrderToPublish(7, 4.0, 4);
        this.publishDeferred(false);
        this.assertIsChanged(false);
    }

    @Test
    public void testPending() {
        this.model = this.builder().build();
        this.addOrderToPublish(0, 1.0, 12);
        this.publishDeferred(false);
        this.assertIsChanged(true);
        this.assertIsSnapshot(true);
        this.assertReceivedEventCount(1);
        this.addOrderToPublish(1, 2.0, 1);
        this.addOrderToPublish(1, 3.0, 1);
        this.publishDeferred(false);
        this.assertIsChanged(false);
        this.addOrderToPublish(2, 4.0, 0);
        this.addOrderToPublish(3, 5.0, 0);
        this.publishDeferred(false);
        this.assertListenerNotification(1);
        this.assertIsSnapshot(false);
        this.assertReceivedEventCount(5);
        this.assertOrder(0, 1.0, 0);
        this.assertOrder(1, 2.0, 1);
        this.assertOrder(1, 3.0, 1);
        this.assertOrder(2, 4.0, 0);
        this.assertOrder(3, 5.0, 0);
    }

    @Test
    public void testPendingEventsClearedAfterSnapshotReceived() {
        this.model = this.builder().build();
        this.addOrderToPublish(2, 1.0, 1);
        this.addOrderToPublish(3, 2.0, 1);
        this.addOrderToPublish(1, 3.0, 1);
        this.addOrderToPublish(0, 4.0, 12);
        this.publishDeferred(false);
        this.assertReceivedEventCount(1);
        this.assertOrder(0, 4.0, 0);
    }

    @Test
    public void testExceptionInListenerDoesNotBreakModelState() {
        this.model = this.builder().withExecutor(task -> {
            try {
                task.run();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }).withListener((events, isSnapshot) -> {
            ++this.listenerNotificationCounter;
            if (isSnapshot) {
                ++this.snapshotNotificationCounter;
            }
            this.receivedEvents.addAll(events);
            throw new RuntimeException();
        }).build();
        this.addOrderToPublish(0, 1.0, 12);
        this.publishDeferred(true);
        this.assertIsChanged(true);
        this.assertReceivedEventCount(1);
        this.assertOrder(0, 1.0, 0);
        this.addOrderToPublish(1, 1.0, 1);
        this.addOrderToPublish(2, 2.0, 1);
        this.addOrderToPublish(3, 3.0, 1);
        this.publishDeferred(true);
        this.assertIsChanged(false);
        this.addOrderToPublish(4, 4.0);
        this.publishDeferred(true);
        this.assertReceivedEventCount(4);
        this.assertOrder(1, 1.0, 1);
        this.assertOrder(2, 2.0, 1);
        this.assertOrder(3, 3.0, 1);
        this.assertOrder(4, 4.0, 0);
    }

    @Test
    public void testEventsWithoutSnapshot() {
        this.model = this.builder().build();
        this.addOrderToPublish(2, 1.0);
        this.addOrderToPublish(3, 2.0);
        this.addOrderToPublish(1, 3.0);
        this.addOrderToPublish(1, 4.0);
        this.addOrderToPublish(0, 5.0);
        this.publishDeferred(false);
        this.assertListenerNotification(1);
        this.assertReceivedEventCount(5);
        this.assertOrder(2, 1.0, 0);
        this.assertOrder(3, 2.0, 0);
        this.assertOrder(1, 3.0, 0);
        this.assertOrder(1, 4.0, 0);
        this.assertOrder(0, 5.0, 0);
        this.addOrderToPublish(0, 1.0, 12);
        this.addOrderToPublish(1, 2.0);
        this.publishDeferred(false);
        this.assertIsChanged(true);
        this.assertReceivedEventCount(2);
        this.assertOrder(0, 1.0, 0);
        this.assertOrder(1, 2.0, 0);
    }

    @Test
    public void testSnapshotWithRemoveAndPending() {
        this.model = this.builder().build();
        this.addOrderToPublish(7, 1.0, 4);
        this.addOrderToPublish(6, 2.0);
        this.addOrderToPublish(5, 3.0, 2);
        this.addOrderToPublish(4, 4.0);
        this.addOrderToPublish(3, 5.0);
        this.addOrderToPublish(2, 6.0, 1);
        this.addOrderToPublish(2, 7.0);
        this.addOrderToPublish(1, 8.0);
        this.addOrderToPublish(0, Double.NaN, 11);
        this.addOrderToPublish(1, 9.0);
        this.publishDeferred(false);
        this.assertReceivedEventCount(6);
        this.assertOrder(7, 1.0, 0);
        this.assertOrder(6, 2.0, 0);
        this.assertOrder(4, 4.0, 0);
        this.assertOrder(3, 5.0, 0);
        this.assertOrder(2, 7.0, 0);
        this.assertOrder(1, 9.0, 0);
    }

    @Test
    public void testAttachFeed() {
        this.model = this.builder().withFeed(null).build();
        this.addOrderToPublish(0, 1.0, 12);
        this.publishDeferred(true);
        this.assertIsChanged(false);
        this.model.getSubscriptionController().attach(this.feed);
        this.addOrderToPublish(0, 1.0, 12);
        this.publishDeferred(true);
        this.assertIsChanged(true);
        this.assertReceivedEventCount(1);
        this.model.getSubscriptionController().detach(this.feed);
        this.addOrderToPublish(0, 2.0, 12);
        this.publishDeferred(true);
        this.assertIsChanged(false);
        this.model.getSubscriptionController().attach(this.feed);
        this.addOrderToPublish(0, 3.0, 12);
        this.publishDeferred(true);
        this.assertIsChanged(true);
        this.assertReceivedEventCount(2);
        this.assertOrder(0, 1.0, 0);
        this.assertOrder(0, 3.0, 0);
    }

    @Test
    public void testBatchLimit() {
        this.model = this.builder().withEventsBatchLimit(1).build();
        Assert.assertEquals((long)1L, (long)this.model.getSubscriptionController().getEventsBatchLimit());
        this.addOrderToPublish(2, 1.0, 4);
        this.addOrderToPublish(1, 2.0);
        this.addOrderToPublish(0, 3.0, 8);
        this.publishDeferred(true);
        this.assertListenerNotification(1);
        this.addOrderToPublish(3, 1.0);
        this.addOrderToPublish(4, 1.0);
        this.addOrderToPublish(5, 1.0);
        this.publishDeferred(true);
        this.assertListenerNotification(3);
        this.model.getSubscriptionController().setEventsBatchLimit(3);
        Assert.assertEquals((long)3L, (long)this.model.getSubscriptionController().getEventsBatchLimit());
        this.addOrderToPublish(6, 1.0);
        this.addOrderToPublish(7, 1.0);
        this.addOrderToPublish(8, 1.0);
        this.addOrderToPublish(9, 1.0);
        this.publishDeferred(true);
        this.assertListenerNotification(2);
    }

    @Test
    public void testCloseAbruptly() {
        this.model = this.builder().build();
        this.addOrderToPublish(0, 12.34, 12);
        this.publishDeferred(true);
        this.assertIsChanged(true);
        this.assertIsSnapshot(true);
        Assert.assertFalse((boolean)this.model.isClosed());
        this.model.close();
        Assert.assertTrue((boolean)this.model.isClosed());
        this.addOrderToPublish(2, 56.78, 0);
        this.publishDeferred(true);
        this.assertIsChanged(false);
    }

    private void addOrderToPublish(int index, double size) {
        this.addOrderToPublish(index, size, 0);
    }

    private void addOrderToPublish(int index, double size, int eventFlags) {
        Order order = new Order(SYMBOL);
        order.setIndex((long)index);
        order.setSource(OrderSource.DEFAULT);
        order.setSizeAsDouble(size);
        order.setEventFlags(eventFlags);
        order.setOrderSide(Side.BUY);
        this.publishedEvents.add(order);
    }

    private void publishDeferred(boolean withPublisher) {
        if (withPublisher) {
            this.publisher.publishEvents(this.publishedEvents);
        } else {
            this.model.processEvents(this.publishedEvents);
        }
        this.publishedEvents.clear();
    }

    private void assertIsChanged(boolean isChanged) {
        Assert.assertTrue((boolean)(isChanged ? this.listenerNotificationCounter > 0 : this.listenerNotificationCounter == 0));
        this.listenerNotificationCounter = 0;
    }

    private void assertIsSnapshot(boolean isSnapshot) {
        Assert.assertTrue((boolean)(isSnapshot ? this.snapshotNotificationCounter > 0 : this.snapshotNotificationCounter == 0));
        this.snapshotNotificationCounter = 0;
    }

    private void assertListenerNotification(int count) {
        Assert.assertEquals((long)count, (long)this.listenerNotificationCounter);
        this.listenerNotificationCounter = 0;
    }

    private void assertSnapshotNotification(int count) {
        Assert.assertEquals((long)count, (long)this.snapshotNotificationCounter);
        this.snapshotNotificationCounter = 0;
    }

    private void assertReceivedEventCount(int count) {
        Assert.assertEquals((long)count, (long)this.receivedEvents.size());
    }

    private void assertOrder(int index, double size, int eventFlags) {
        Order order = this.receivedEvents.poll();
        Assert.assertNotNull((String)String.format("Order in the %d index cannot be null", index), (Object)order);
        Assert.assertEquals((String)String.format("At index %d: Unexpected symbol", index), (Object)SYMBOL, (Object)order.getEventSymbol());
        Assert.assertEquals((String)String.format("At index %d: Unexpected index", index), (long)index, (long)order.getIndex());
        Assert.assertEquals((String)String.format("At index %d: Unexpected size", index), (double)size, (double)order.getSizeAsDouble(), (double)0.0);
        Assert.assertEquals((String)String.format("At index %d: Unexpected flags", index), (long)eventFlags, (long)order.getEventFlags());
    }

    private IndexedEventTxModel.Builder<Order> builder() {
        return IndexedEventTxModel.newBuilder(Order.class).withFeed(this.feed).withSymbol(SYMBOL).withSource(SOURCE).withListener((events, isSnapshot) -> {
            ++this.listenerNotificationCounter;
            if (isSnapshot) {
                ++this.snapshotNotificationCounter;
            }
            this.receivedEvents.addAll(events);
        }).withExecutor(Runnable::run);
    }
}

