/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.model.test;

import com.devexperts.test.ThreadCleanCheck;
import com.dxfeed.api.DXEndpoint;
import com.dxfeed.api.DXFeed;
import com.dxfeed.api.DXPublisher;
import com.dxfeed.event.market.MarketEvent;
import com.dxfeed.event.market.MarketEventSymbols;
import com.dxfeed.event.market.Order;
import com.dxfeed.event.market.Quote;
import com.dxfeed.event.market.Side;
import com.dxfeed.model.ObservableListModelListener;
import com.dxfeed.model.market.OrderBookModel;
import com.dxfeed.model.market.OrderBookModelFilter;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Random;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OrderBookModelStressTest {
    public static final String[] SYMBOLS = new String[]{"GOOG", "AAPL", "IBM"};
    public static final int N_SECONDS = 3;
    public static final int MAX_PUB_EVENTS = 10;
    private DXEndpoint endpoint;
    private ExecutorService executor;
    private PublisherThread publisherThread;
    private volatile Thread processingThread;
    private volatile long lastChangeTime;
    private final ArrayBlockingQueue<Throwable> exception = new ArrayBlockingQueue(1);
    private final Thread.UncaughtExceptionHandler uncaughtExceptionHandler = (t, e) -> this.exception.offer(e);

    @Before
    public void setUp() throws Exception {
        ThreadCleanCheck.before();
        this.executor = Executors.newFixedThreadPool(1, r -> {
            this.processingThread = new Thread(r);
            this.processingThread.setUncaughtExceptionHandler(this.uncaughtExceptionHandler);
            return this.processingThread;
        });
        this.endpoint = DXEndpoint.newBuilder().withRole(DXEndpoint.Role.LOCAL_HUB).build().executor((Executor)this.executor);
    }

    @After
    public void tearDown() throws Exception {
        this.endpoint.close();
        if (this.publisherThread != null) {
            this.publisherThread.interrupt();
        }
        if (this.executor != null) {
            this.executor.shutdown();
        }
        ThreadCleanCheck.after();
    }

    @Test
    public void testOrderBookUnderStress() throws InterruptedException {
        long startTime;
        ArrayList<OrderBookModel> models = new ArrayList<OrderBookModel>();
        DXFeed feed = this.endpoint.getFeed();
        for (String symbol : SYMBOLS) {
            for (OrderBookModelFilter filter : EnumSet.allOf(OrderBookModelFilter.class)) {
                OrderBookModel model = new OrderBookModel();
                model.setSymbol(symbol);
                model.setFilter(filter);
                ObservableListModelListener listener = change -> {
                    this.lastChangeTime = System.currentTimeMillis();
                };
                model.getBuyOrders().addListener(listener);
                model.getSellOrders().addListener(listener);
                model.attach(feed);
                models.add(model);
            }
        }
        this.lastChangeTime = startTime = System.currentTimeMillis();
        this.publisherThread = new PublisherThread(this.endpoint.getPublisher());
        this.publisherThread.setPriority(3);
        this.publisherThread.setUncaughtExceptionHandler(this.uncaughtExceptionHandler);
        this.publisherThread.start();
        for (int i = 0; i < 3; ++i) {
            StackTraceElement[] stackTrace;
            long now;
            Throwable t = this.exception.poll(1L, TimeUnit.SECONDS);
            if (t != null) {
                t.printStackTrace();
                Assert.fail((String)("Fails: " + t));
            }
            if (this.lastChangeTime >= (now = System.currentTimeMillis()) - 1000L) continue;
            System.out.println("Hangs at stack trace:");
            for (StackTraceElement element : stackTrace = this.processingThread.getStackTrace()) {
                System.out.println("\tat " + element);
            }
            Assert.fail((String)"Hangs");
        }
        models.forEach(OrderBookModel::close);
    }

    static class PublisherThread
    extends Thread {
        private final DXPublisher publisher;

        PublisherThread(DXPublisher publisher) {
            this.publisher = publisher;
        }

        @Override
        public void run() {
            Random rnd = new Random(1L);
            ArrayList<MarketEvent> events = new ArrayList<MarketEvent>();
            while (!Thread.interrupted()) {
                int n = rnd.nextInt(10) + 1;
                for (int i = 0; i < n; ++i) {
                    events.add(this.randomEvent(rnd));
                }
                this.publisher.publishEvents(events);
                events.clear();
            }
        }

        private MarketEvent randomEvent(Random rnd) {
            String symbol = SYMBOLS[rnd.nextInt(SYMBOLS.length)];
            switch (rnd.nextInt(3)) {
                case 0: {
                    Quote quote = new Quote(symbol);
                    quote.setBidPrice(this.randomPrice(rnd));
                    quote.setBidSize(this.randomSize(rnd));
                    quote.setBidExchangeCode(this.randomExchange(rnd));
                    quote.setAskPrice(this.randomPrice(rnd));
                    quote.setAskSize(this.randomSize(rnd));
                    quote.setAskExchangeCode(this.randomExchange(rnd));
                    return quote;
                }
                case 1: {
                    Quote regQuote = new Quote(symbol + "&" + this.randomExchange(rnd));
                    regQuote.setBidPrice(this.randomPrice(rnd));
                    regQuote.setBidSize(this.randomSize(rnd));
                    regQuote.setAskPrice(this.randomPrice(rnd));
                    regQuote.setAskSize(this.randomSize(rnd));
                    return regQuote;
                }
                case 2: {
                    Order order = new Order(symbol);
                    order.setOrderSide(rnd.nextBoolean() ? Side.BUY : Side.SELL);
                    order.setIndex((long)rnd.nextInt(100));
                    order.setPrice(this.randomPrice(rnd));
                    order.setSize(this.randomSize(rnd));
                    order.setExchangeCode(this.randomExchange(rnd));
                    return order;
                }
            }
            throw new AssertionError();
        }

        private char randomExchangeOrComposite(Random rnd) {
            return rnd.nextInt(20) == 0 ? (char)'\u0000' : this.randomExchange(rnd);
        }

        private char randomExchange(Random rnd) {
            return MarketEventSymbols.SUPPORTED_EXCHANGES.charAt(rnd.nextInt(MarketEventSymbols.SUPPORTED_EXCHANGES.length()));
        }

        private long randomSize(Random rnd) {
            return rnd.nextInt(10);
        }

        private double randomPrice(Random rnd) {
            return (double)(rnd.nextInt(1000) + 10) / 10.0;
        }
    }
}

