/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.ondemand.impl.event;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.DataScheme;
import com.devexperts.qd.QDFactory;
import com.devexperts.qd.SymbolCodec;
import com.devexperts.qd.ng.RecordMapping;
import com.dxfeed.event.candle.impl.TradeHistoryMapping;
import com.dxfeed.event.market.impl.FundamentalMapping;
import com.dxfeed.event.market.impl.MarketEventMapping;
import com.dxfeed.event.market.impl.MarketMakerMapping;
import com.dxfeed.event.market.impl.ProfileMapping;
import com.dxfeed.event.market.impl.QuoteMapping;
import com.dxfeed.event.market.impl.SummaryMapping;
import com.dxfeed.event.market.impl.TimeAndSaleMapping;
import com.dxfeed.event.market.impl.TradeMapping;
import com.dxfeed.ondemand.impl.Key;
import com.dxfeed.ondemand.impl.event.MDREvent;
import com.dxfeed.ondemand.impl.event.MDRMarketMaker;
import com.dxfeed.ondemand.impl.event.MDRProfile;
import com.dxfeed.ondemand.impl.event.MDRQuote;
import com.dxfeed.ondemand.impl.event.MDRSummary;
import com.dxfeed.ondemand.impl.event.MDRTrade;
import com.dxfeed.ondemand.impl.event.MDRTradeHistory;
import java.util.Arrays;
import java.util.Collection;

public class MDREventUtil {
    public static final DataScheme SCHEME = QDFactory.getDefaultScheme();
    public static final SymbolCodec CODEC = SCHEME.getCodec();
    private static final char[] RECORD_TYPES = new char[SCHEME.getRecordCount()];
    private static final char[] RECORD_EXCHANGES = new char[SCHEME.getRecordCount()];
    private static final DataRecord[][][] RECORDS_BY_TYPE_EXCHANGE = new DataRecord[128][][];
    public static final String TYPES = "QTSPHM";
    public static final int NUMBER_OF_CATEGORIES = 128;
    private static final String[] CATEGORY_NAMES;
    private static final int[] CATEGORY_TYPE_INDEXES;
    private static final String CURRENCY_CODES = "AED,AFN,ALL,AMD,ANG,AOA,ARS,AUD,AWG,AZN,BAM,BBD,BDT,BGN,BHD,BIF,BMD,BND,BOB,BOV,BRL,BSD,BTN,BWP,BYR,BZD,CAD,CDF,CHE,CHF,CHW,CLF,CLP,CNY,COP,COU,CRC,CUC,CUP,CVE,CZK,DJF,DKK,DOP,DZD,EEK,EGP,ERN,ETB,EUR,FJD,FKP,GBP,GEL,GHS,GIP,GMD,GNF,GTQ,GYD,HKD,HNL,HRK,HTG,HUF,IDR,ILS,INR,IQD,IRR,ISK,JMD,JOD,JPY,KES,KGS,KHR,KMF,KPW,KRW,KWD,KYD,KZT,LAK,LBP,LKR,LRD,LSL,LTL,LVL,LYD,MAD,MDL,MGA,MKD,MMK,MNT,MOP,MRO,MUR,MVR,MWK,MXN,MXV,MYR,MZN,NAD,NGN,NIO,NOK,NPR,NZD,OMR,PAB,PEN,PGK,PHP,PKR,PLN,PYG,QAR,RON,RSD,RUB,RWF,SAR,SBD,SCR,SDG,SEK,SGD,SHP,SLL,SOS,SRD,STD,SYP,SZL,THB,TJS,TMT,TND,TOP,TRY,TTD,TWD,TZS,UAH,UGX,USD,USN,USS,UYU,UZS,VEF,VND,VUV,WST,XAF,XAG,XAU,XBA,XBB,XBC,XBD,XCD,XDR,XFU,XOF,XPD,XPF,XPT,XTS,XXX,YER,ZAR,ZMK,ZWL,ADF,ADP,ATS,BEF,CYP,DEM,ESP,FIM,FRF,GRD,IEP,ITL,LUF,MCF,MAF,MTL,NLG,PTE,SIT,SKK,SML,VAL,XEU,AFA,AON,AOR,ARL,ARP,ARA,AZM,BGL,BOP,BRB,BRC,BRE,BRN,BRR,CSD,CSK,DDM,ECS,ECV,GQE,ESA,ESB,GNE,GHC,GWP,ILP,ILR,ISJ,LAJ,MGF,MKN,MLF,MVQ,MXP,MZM,NFD,PEH,PEI,PLZ,ROL,RUR,SDD,SRG,SUR,SVC,TJR,TMM,TRL,UAK,UGS,UYN,VEB,XFO,YDD,YUD,YUN,YUR,YUO,YUG,YUM,ZAL,ZRN,ZRZ,ZWC,ZWD,ZWN,ZWR,";
    private static final int[] CURRENCY_SET;

    private static void buildRecordMapping(int index, Class<? extends RecordMapping> mappingClass, char type) {
        DataRecord[] rs;
        DataRecord record = SCHEME.getRecord(index);
        RecordMapping mapping = record.getMapping(mappingClass);
        if (mapping == null) {
            return;
        }
        char exchange = mapping instanceof MarketEventMapping ? ((MarketEventMapping)mapping).getRecordExchange() : (char)'\u0000';
        MDREventUtil.RECORD_TYPES[index] = type;
        char c = MDREventUtil.RECORD_EXCHANGES[index] = type == 'H' ? (char)'\u0000' : exchange;
        if (RECORDS_BY_TYPE_EXCHANGE[type] == null) {
            MDREventUtil.RECORDS_BY_TYPE_EXCHANGE[type] = new DataRecord[128][];
        }
        rs = (rs = RECORDS_BY_TYPE_EXCHANGE[type][exchange]) == null ? new DataRecord[1] : Arrays.copyOf(rs, rs.length + 1);
        rs[rs.length - 1] = record;
        MDREventUtil.RECORDS_BY_TYPE_EXCHANGE[type][exchange] = rs;
    }

    private static IllegalArgumentException unknownType(int type) {
        return new IllegalArgumentException("Unknown type '" + (char)(type >= 32 ? (int)type : 63) + "'");
    }

    public static char getType(DataRecord record) {
        return RECORD_TYPES[record.getId()];
    }

    public static char getExchange(DataRecord record) {
        return RECORD_EXCHANGES[record.getId()];
    }

    public static DataRecord[] getRecords(char type, char exchange) {
        DataRecord[][] a = RECORDS_BY_TYPE_EXCHANGE[type];
        if (a == null) {
            throw MDREventUtil.unknownType(type);
        }
        return a[exchange];
    }

    public static MDREvent createEvent(char type) {
        switch (type) {
            case 'Q': {
                return new MDRQuote();
            }
            case 'T': {
                return new MDRTrade();
            }
            case 'S': {
                return new MDRSummary();
            }
            case 'P': {
                return new MDRProfile();
            }
            case 'H': {
                return new MDRTradeHistory();
            }
            case 'M': {
                return new MDRMarketMaker();
            }
        }
        throw MDREventUtil.unknownType(type);
    }

    public static String getRecordName(char type) {
        switch (type) {
            case 'Q': {
                return "Quote";
            }
            case 'T': {
                return "Trade";
            }
            case 'S': {
                return "Summary";
            }
            case 'P': {
                return "Profile";
            }
            case 'H': {
                return "TimeAndSale";
            }
            case 'M': {
                return "MarketMaker";
            }
        }
        throw MDREventUtil.unknownType(type);
    }

    private static int getCategory(int si, int exchange, int type) {
        int ti;
        int ei;
        int n = ei = exchange == 0 ? 0 : 1;
        if (type < 0 || type >= CATEGORY_TYPE_INDEXES.length || (ti = CATEGORY_TYPE_INDEXES[type]) < 0) {
            throw MDREventUtil.unknownType(type);
        }
        return (si << 4) + (ei << 3) + ti;
    }

    public static String getCategoryName(int category) {
        return CATEGORY_NAMES[category];
    }

    public static int getCategory(String name) {
        for (int i = 0; i < CATEGORY_NAMES.length; ++i) {
            if (!CATEGORY_NAMES[i].equals(name)) continue;
            return i;
        }
        throw new IllegalArgumentException("Unknown category: " + name);
    }

    public static int getCategory(Key key) {
        String s = key.getSymbol();
        int si = s == null || s.length() == 0 ? 0 : (s.charAt(0) == '/' ? 1 : (s.charAt(0) == '.' ? (s.length() > 1 && s.charAt(1) == '/' ? 3 : 2) : (MDREventUtil.isForex(s) ? 4 : 0)));
        return MDREventUtil.getCategory(si, (int)key.getExchange(), (int)key.getType());
    }

    public static int getCategory(byte[] bytes, int offset, int length) {
        int si = length == 0 ? 0 : (bytes[offset] == 47 ? 1 : (bytes[offset] == 46 ? (length > 1 && bytes[offset + 1] == 47 ? 3 : 2) : (MDREventUtil.isForex(bytes, offset, length) ? 4 : 0)));
        return MDREventUtil.getCategory(si, (int)bytes[offset + length], (int)bytes[offset + length + 1]);
    }

    public static String countCategories(Collection<Key> keys) {
        int[] categories = new int[128];
        for (Key key : keys) {
            int n = MDREventUtil.getCategory(key);
            categories[n] = categories[n] + 1;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < categories.length; ++i) {
            if (categories[i] <= 0) continue;
            sb.append(" ").append(MDREventUtil.getCategoryName(i)).append("=").append(categories[i]);
        }
        return sb.toString();
    }

    private static int getCurrencyIndex(int c1, int c2, int c3) {
        return c1 - 65 << 10 | c2 - 65 << 5 | c3 - 65 | (90 - c1 | 90 - c2 | 90 - c3) >> 5;
    }

    private static boolean isCurrency(int currencyIndex) {
        return currencyIndex >= 0 && (CURRENCY_SET[currencyIndex >> 5] & 1 << currencyIndex) != 0;
    }

    public static boolean isCurrency(String s) {
        return s != null && s.length() == 3 && MDREventUtil.isCurrency(s, 0);
    }

    public static boolean isCurrency(String s, int offset) {
        return MDREventUtil.isCurrency(MDREventUtil.getCurrencyIndex(s.charAt(offset), s.charAt(offset + 1), s.charAt(offset + 2)));
    }

    public static boolean isCurrency(byte[] bytes, int offset) {
        return MDREventUtil.isCurrency(MDREventUtil.getCurrencyIndex(bytes[offset], bytes[offset + 1], bytes[offset + 2]));
    }

    public static boolean isForex(String s) {
        if (s == null || s.length() < 7) {
            return false;
        }
        if (s.charAt(3) == '/') {
            return MDREventUtil.isCurrency(s, 0) && MDREventUtil.isCurrency(s, 4);
        }
        if (s.charAt(4) == '/') {
            return s.length() >= 9 && MDREventUtil.isCurrency(s, 0) && s.charAt(3) == '$' && MDREventUtil.isCurrency(s, 5) && s.charAt(8) == '$';
        }
        if (s.charAt(6) == '/') {
            return s.length() >= 13 && MDREventUtil.isCurrency(s, 0) && s.startsWith("$FX", 3) && MDREventUtil.isCurrency(s, 7) && s.startsWith("$FX", 10);
        }
        return false;
    }

    public static boolean isForex(byte[] bytes, int offset, int length) {
        if (length < 7) {
            return false;
        }
        if (bytes[offset + 3] == 47) {
            return MDREventUtil.isCurrency(bytes, offset) && MDREventUtil.isCurrency(bytes, offset + 4);
        }
        if (bytes[offset + 4] == 47) {
            return length >= 9 && MDREventUtil.isCurrency(bytes, offset) && bytes[offset + 3] == 36 && MDREventUtil.isCurrency(bytes, offset + 5) && bytes[offset + 8] == 36;
        }
        if (bytes[offset + 6] == 47) {
            return length >= 13 && MDREventUtil.isCurrency(bytes, offset) && bytes[offset + 3] == 36 && bytes[offset + 4] == 70 && bytes[offset + 5] == 88 && MDREventUtil.isCurrency(bytes, offset + 7) && bytes[offset + 10] == 36 && bytes[offset + 11] == 70 && bytes[offset + 12] == 88;
        }
        return false;
    }

    public static boolean isGoodSymbol(String symbol) {
        if (symbol == null || symbol.length() == 0 || symbol.length() >= 256) {
            return false;
        }
        if (symbol.charAt(0) == '#' && (symbol.equals("#LOCKED") || symbol.equals("#INVERTED"))) {
            return false;
        }
        boolean hasLetter = false;
        for (int i = 0; i < symbol.length(); ++i) {
            char c = symbol.charAt(i);
            if (Character.isISOControl(c) || Character.isHighSurrogate(c) || Character.isLowSurrogate(c)) {
                return false;
            }
            if (c == ' ' || c == ',') {
                return false;
            }
            if (hasLetter || !Character.isLetter(c)) continue;
            hasLetter = true;
        }
        return hasLetter;
    }

    static {
        for (int i = 0; i < SCHEME.getRecordCount(); ++i) {
            MDREventUtil.buildRecordMapping(i, QuoteMapping.class, 'Q');
            MDREventUtil.buildRecordMapping(i, TradeMapping.class, 'T');
            MDREventUtil.buildRecordMapping(i, SummaryMapping.class, 'S');
            MDREventUtil.buildRecordMapping(i, FundamentalMapping.class, 'S');
            MDREventUtil.buildRecordMapping(i, ProfileMapping.class, 'P');
            MDREventUtil.buildRecordMapping(i, TimeAndSaleMapping.class, 'H');
            MDREventUtil.buildRecordMapping(i, TradeHistoryMapping.class, 'H');
            MDREventUtil.buildRecordMapping(i, MarketMakerMapping.class, 'M');
        }
        CATEGORY_NAMES = new String[128];
        CATEGORY_TYPE_INDEXES = new int[128];
        for (int si = 0; si < 8; ++si) {
            for (int ei = 0; ei < 2; ++ei) {
                for (int ti = 0; ti < 8; ++ti) {
                    MDREventUtil.CATEGORY_NAMES[(si << 4) + (ei << 3) + ti] = new String(new char[]{"EFOQX---".charAt(si), "-.".charAt(ei), "QTSPHM--".charAt(ti)});
                }
            }
        }
        Arrays.fill(CATEGORY_TYPE_INDEXES, -1);
        MDREventUtil.CATEGORY_TYPE_INDEXES[81] = 0;
        MDREventUtil.CATEGORY_TYPE_INDEXES[84] = 1;
        MDREventUtil.CATEGORY_TYPE_INDEXES[83] = 2;
        MDREventUtil.CATEGORY_TYPE_INDEXES[80] = 3;
        MDREventUtil.CATEGORY_TYPE_INDEXES[72] = 4;
        MDREventUtil.CATEGORY_TYPE_INDEXES[77] = 5;
        CURRENCY_SET = new int[1024];
        for (String s : CURRENCY_CODES.split(",")) {
            if (s.length() != 3) {
                throw new IllegalArgumentException("Bad currency " + s);
            }
            int currencyIndex = MDREventUtil.getCurrencyIndex(s.charAt(0), s.charAt(1), s.charAt(2));
            if (currencyIndex < 0) {
                throw new IllegalArgumentException("Bad currency " + s);
            }
            if (MDREventUtil.isCurrency(currencyIndex)) {
                throw new IllegalArgumentException("Duplicate currency " + s);
            }
            int n = currencyIndex >> 5;
            CURRENCY_SET[n] = CURRENCY_SET[n] | 1 << currencyIndex;
        }
    }
}

