/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.ondemand.impl;

import com.devexperts.io.BufferedOutput;
import com.devexperts.io.ByteArrayInput;
import com.devexperts.io.ByteArrayOutput;
import com.devexperts.io.IOUtil;
import com.devexperts.logging.Logging;
import com.devexperts.util.TimeFormat;
import com.dxfeed.ondemand.impl.Key;
import com.dxfeed.ondemand.impl.ReplayUtil;
import java.io.DataInput;
import java.io.IOException;
import java.util.Comparator;
import java.util.zip.DataFormatException;

public class Block
extends Key {
    private static final Logging log = Logging.getLogging(Block.class);
    public static final Comparator<Block> COMPARATOR = new Comparator<Block>(){

        @Override
        public int compare(Block block1, Block block2) {
            int i = Key.COMPARATOR.compare(block1, block2);
            if (i == 0) {
                i = Long.compare(block1.getStartTime(), block2.getStartTime());
            }
            if (i == 0) {
                i = Long.compare(block1.getEndTime(), block2.getEndTime());
            }
            return i;
        }
    };
    public static final int COMPRESSION_MASK = 7;
    public static final int COMPRESSION_NONE = 0;
    public static final int COMPRESSION_DEFLATE = 1;
    protected int version;
    protected long startTime;
    protected long endTime;
    protected byte[] body;
    protected int bodyOffset;
    protected int bodyLength;

    public long getVersion() {
        return this.version;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public boolean containsTime(long time) {
        return this.startTime <= time && time < this.endTime;
    }

    public int getBodyLength() {
        return this.bodyLength;
    }

    public boolean isIdentical(Block block) {
        if (!this.equals(block) || this.version != block.version || this.startTime != block.startTime || this.endTime != block.endTime || this.bodyLength != block.bodyLength) {
            return false;
        }
        for (int i = 0; i < this.bodyLength; ++i) {
            if (this.body[this.bodyOffset + i] == block.body[block.bodyOffset + i]) continue;
            return false;
        }
        return true;
    }

    public void decompress() {
        if ((this.version & 7) == 0) {
            if (this.body.length != this.bodyLength) {
                byte[] tmp = new byte[this.bodyLength];
                System.arraycopy(this.body, this.bodyOffset, tmp, 0, this.bodyLength);
                this.body = tmp;
                this.bodyOffset = 0;
            }
        } else if ((this.version & 7) == 1) {
            try {
                ByteArrayOutput out = new ByteArrayOutput(Math.max(this.bodyLength * 2, 4096));
                ReplayUtil.inflate(this.body, this.bodyOffset, this.bodyLength, out);
                this.version = this.version & 0xFFFFFFF8 | 0;
                this.body = out.toByteArray();
                this.bodyOffset = 0;
                this.bodyLength = this.body.length;
            }
            catch (DataFormatException e) {
                log.error("Decompression failed for " + this, (Throwable)e);
            }
        } else {
            log.error("Unknown compression method " + (this.version & 7) + " for " + this);
        }
        if ((this.version & 7) != 0) {
            this.version = this.version & 0xFFFFFFF8 | 0;
            this.body = new byte[0];
            this.bodyOffset = 0;
            this.bodyLength = 0;
        }
    }

    public ByteArrayInput getInput() {
        this.decompress();
        return new ByteArrayInput(this.body, this.bodyOffset, this.bodyLength);
    }

    public void setData(byte[] data, int dataOffset, int dataLength) {
        this.version = this.version & 0xFFFFFFF8 | 0;
        this.body = data;
        this.bodyOffset = dataOffset;
        this.bodyLength = dataLength;
    }

    public void readBlock(DataInput in) throws IOException {
        long length = IOUtil.readCompactLong((DataInput)in);
        if (length < -1L || length > Integer.MAX_VALUE) {
            throw new IOException("Illegal length.");
        }
        byte[] bytes = new byte[(int)length];
        in.readFully(bytes);
        ByteArrayInput blockInput = new ByteArrayInput(bytes);
        if (blockInput.available() < 6) {
            throw new IOException("Insufficient length.");
        }
        this.version = blockInput.readCompactInt();
        if ((this.version & 0xFFFFFFF8) != 0) {
            throw new IOException("Unknown version.");
        }
        this.symbol = blockInput.readUTFString();
        this.exchange = (char)blockInput.readUTFChar();
        this.type = (char)blockInput.readUTFChar();
        this.startTime = blockInput.readCompactLong() * 1000L;
        this.endTime = this.startTime + blockInput.readCompactLong() * 1000L;
        this.body = new byte[blockInput.available()];
        blockInput.readFully(this.body);
        this.bodyOffset = 0;
        this.bodyLength = this.body.length;
    }

    public void writeBlock(ByteArrayOutput out) throws IOException {
        if (this.symbol == null || this.body == null) {
            throw new NullPointerException();
        }
        long started = this.startTime / 1000L;
        long duration = this.endTime / 1000L - started;
        int estimateLength = 4 + this.symbol.length() + IOUtil.getCompactLength((long)started) + IOUtil.getCompactLength((long)duration) + this.bodyLength;
        int blockPosition = out.getPosition();
        out.writeCompactInt(estimateLength);
        int payloadPosition = out.getPosition();
        out.writeCompactInt(this.version);
        out.writeUTFString(this.symbol);
        out.writeUTFChar((int)this.exchange);
        out.writeUTFChar((int)this.type);
        out.writeCompactLong(started);
        out.writeCompactLong(duration);
        out.write(this.body, this.bodyOffset, this.bodyLength);
        int actualLength = out.getPosition() - payloadPosition;
        if (actualLength != estimateLength) {
            int shift = IOUtil.getCompactLength((long)actualLength) - (payloadPosition - blockPosition);
            log.info("Moving block for " + shift + " bytes; estimate = " + estimateLength + ", actual = " + actualLength);
            if (shift != 0) {
                out.ensureCapacity(out.getPosition() + shift);
                System.arraycopy(out.getBuffer(), payloadPosition, out.getBuffer(), payloadPosition + shift, actualLength);
            }
            out.setPosition(blockPosition);
            out.writeCompactInt(actualLength);
            out.setPosition(out.getPosition() + actualLength);
        }
    }

    public void writeBlock(BufferedOutput out, ByteArrayOutput header) throws IOException {
        if (this.symbol == null || this.body == null) {
            throw new NullPointerException();
        }
        long started = this.startTime / 1000L;
        long duration = this.endTime / 1000L - started;
        header.setPosition(0);
        header.writeCompactInt(this.version);
        header.writeUTFString(this.symbol);
        header.writeUTFChar((int)this.exchange);
        header.writeUTFChar((int)this.type);
        header.writeCompactLong(started);
        header.writeCompactLong(duration);
        out.writeCompactInt(header.getPosition() + this.bodyLength);
        out.write(header.getBuffer(), 0, header.getPosition());
        out.write(this.body, this.bodyOffset, this.bodyLength);
    }

    @Override
    public String toString() {
        return super.toString() + "(" + TimeFormat.DEFAULT.format(this.startTime) + ", " + TimeFormat.DEFAULT.format(this.endTime) + ")";
    }
}

