/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.ondemand.impl;

import com.devexperts.io.ByteArrayInput;
import com.devexperts.qd.DataRecord;
import com.devexperts.qd.ng.RecordBuffer;
import com.devexperts.util.IndexerFunction;
import com.dxfeed.ondemand.impl.Key;
import com.dxfeed.ondemand.impl.Log;
import com.dxfeed.ondemand.impl.Segment;
import com.dxfeed.ondemand.impl.event.MDREvent;
import com.dxfeed.ondemand.impl.event.MDREventUtil;
import com.dxfeed.ondemand.impl.event.MDRTradeHistory;
import java.io.IOException;
import java.io.Serializable;

class CurrentSegment {
    static final IndexerFunction<Key, CurrentSegment> KEY_INDEXER = (IndexerFunction & Serializable)segment -> segment.segment.block;
    Segment segment;
    MDREvent event;
    ByteArrayInput input;

    CurrentSegment(Segment segment) {
        this.acquire(segment);
    }

    private void acquire(Segment segment) {
        this.segment = segment;
        ++segment.currentCounter;
    }

    void release() {
        --this.segment.currentCounter;
    }

    void replaceSegment(Segment newSegment, long time, long usage) {
        long skipTime = this.event == null ? Long.MIN_VALUE : Math.min(time, this.event.getEventTime() - 1L);
        this.release();
        this.acquire(newSegment);
        this.restart();
        if (skipTime != Long.MIN_VALUE) {
            this.read(null, skipTime, usage);
        }
    }

    void restart() {
        this.event = null;
        this.input = null;
    }

    void read(RecordBuffer buffer, long time, long usage) {
        boolean isTradeHistory;
        boolean bl = isTradeHistory = this.segment.block.getType() == 'H';
        if (this.event == null) {
            this.event = MDREventUtil.createEvent(this.segment.block.getType());
            this.input = this.segment.block.getInput();
            this.event.init(this.segment.block.getStartTime());
            this.readNext();
        }
        if (this.event.getEventTime() <= time) {
            DataRecord[] records = MDREventUtil.getRecords(this.segment.block.getType(), this.segment.block.getExchange());
            while (this.event.getEventTime() <= time) {
                if (buffer != null) {
                    DataRecord[] regRecords;
                    int cipher = MDREventUtil.CODEC.encode(this.segment.block.getSymbol());
                    for (DataRecord record : records) {
                        this.event.getInto(buffer.add(record, cipher, this.segment.block.getSymbol()));
                    }
                    if (isTradeHistory && (regRecords = MDREventUtil.getRecords('H', ((MDRTradeHistory)this.event).getExchange())) != null) {
                        for (DataRecord record : regRecords) {
                            this.event.getInto(buffer.add(record, cipher, this.segment.block.getSymbol()));
                        }
                    }
                }
                this.readNext();
            }
        }
        this.segment.updateUsage(usage);
    }

    private void readNext() {
        try {
            if (this.input.available() > 0) {
                this.event.read(this.input);
            } else {
                this.event.setEventTime(Long.MAX_VALUE);
            }
        }
        catch (IOException e) {
            this.event.setEventTime(Long.MAX_VALUE);
            Log.log.error("Unexpected IOException", (Throwable)e);
        }
    }
}

