/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.ondemand.impl;

import com.devexperts.io.ByteArrayInput;
import com.devexperts.io.ByteArrayOutput;
import com.devexperts.logging.Logging;
import com.devexperts.util.Base64;
import com.devexperts.util.TimeFormat;
import java.io.IOException;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Map;

public class MarketDataToken
implements Serializable {
    private static final long serialVersionUID = 0L;
    private static final String TOKEN_PASSWORD_PREFIX = "$.";
    private static final String DIGEST_ALGORITHM = "SHA-256";
    private static final int DIGEST_SIZE = 32;
    private static final Logging log = Logging.getLogging(MarketDataToken.class);
    public static final String SERVICE_ACTIVE = "service_active";
    public static final String SERVICE_MESSAGE = "service_message";
    public static final String SERVICE_MIN_TIME = "service_minTime";
    public static final String SERVICE_MAX_TIME = "service_maxTime";
    public static final String SERVICE_ADDRESS = "service_address";
    public static final String TOKEN_CONTRACT = "token_contract";
    public static final String TOKEN_TIMEOUT = "token_timeout";
    public static final String TOKEN_SECRET = "token_secret";
    private final boolean serviceActive;
    private final String serviceMessage;
    private final long serviceMinTime;
    private final long serviceMaxTime;
    private final String serviceAddress;
    private final String tokenContract;
    private final String tokenUser;
    private final long tokenExpiration;
    private final byte[] tokenDigest;
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");

    public MarketDataToken(Map<String, String> configuration, String user) {
        this.serviceActive = MarketDataToken.getString(configuration, SERVICE_ACTIVE, "").equalsIgnoreCase("true");
        this.serviceMessage = MarketDataToken.getString(configuration, SERVICE_MESSAGE, "");
        this.serviceMinTime = MarketDataToken.getDate(configuration, SERVICE_MIN_TIME, 0L);
        this.serviceMaxTime = MarketDataToken.getDate(configuration, SERVICE_MAX_TIME, 0L);
        this.serviceAddress = MarketDataToken.getString(configuration, SERVICE_ADDRESS, "");
        this.tokenContract = MarketDataToken.getString(configuration, TOKEN_CONTRACT, "");
        this.tokenUser = user == null ? "" : user;
        this.tokenExpiration = System.currentTimeMillis() + MarketDataToken.getLong(configuration, TOKEN_TIMEOUT, 600000L);
        this.tokenDigest = this.computeDigest(MarketDataToken.getString(configuration, TOKEN_SECRET, ""));
    }

    public MarketDataToken(String contract, String user, long expiration, byte[] digest) {
        this(contract, user, expiration, digest, "");
    }

    private MarketDataToken(String contract, String user, long expiration, byte[] digest, String address) {
        this.serviceActive = true;
        this.serviceMessage = "";
        this.serviceMinTime = 0L;
        this.serviceMaxTime = 0L;
        this.serviceAddress = address;
        this.tokenContract = contract == null ? "" : contract;
        this.tokenUser = user == null ? "" : user;
        this.tokenExpiration = expiration;
        this.tokenDigest = digest == null ? new byte[]{} : digest;
    }

    private MarketDataToken(String user, String message) {
        this.serviceActive = false;
        this.serviceMessage = message;
        this.serviceMinTime = 0L;
        this.serviceMaxTime = 0L;
        this.serviceAddress = "";
        this.tokenContract = "";
        this.tokenUser = user;
        this.tokenExpiration = 0L;
        this.tokenDigest = new byte[0];
    }

    public boolean isServiceActive() {
        return this.serviceActive;
    }

    public String getServiceMessage() {
        return this.serviceMessage;
    }

    public long getServiceMinTime() {
        return this.serviceMinTime;
    }

    public long getServiceMaxTime() {
        return this.serviceMaxTime;
    }

    public String getServiceAddress() {
        return this.serviceAddress;
    }

    public String getTokenContract() {
        return this.tokenContract;
    }

    public String getTokenUser() {
        return this.tokenUser;
    }

    public long getTokenExpiration() {
        return this.tokenExpiration;
    }

    public byte[] getTokenDigest() {
        return this.tokenDigest;
    }

    public String toString() {
        return "<" + this.tokenUser + "/" + this.tokenContract + "> " + TimeFormat.DEFAULT.format(this.tokenExpiration);
    }

    public static MarketDataToken fromUserPassword(String user, String password, String address) {
        String contract = user;
        long expiration = Long.MAX_VALUE;
        byte[] digest = null;
        if (password.startsWith(TOKEN_PASSWORD_PREFIX)) {
            try {
                byte[] bytes = Base64.URLSAFE_UNPADDED.decode(password.substring(TOKEN_PASSWORD_PREFIX.length()));
                ByteArrayInput in = new ByteArrayInput(bytes);
                contract = in.readUTFString();
                expiration = in.readCompactLong();
                if (in.available() == 32) {
                    digest = new byte[32];
                    in.readFully(digest);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (digest == null) {
            digest = MarketDataToken.computeDigest(contract, user, expiration, password);
        }
        return new MarketDataToken(contract, user, expiration, digest, address);
    }

    public String toTokenPassword() {
        ByteArrayOutput out = new ByteArrayOutput();
        try {
            out.writeUTFString(this.tokenContract);
            out.writeCompactLong(this.tokenExpiration);
            out.write(this.tokenDigest);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return TOKEN_PASSWORD_PREFIX + Base64.URLSAFE_UNPADDED.encode(out.toByteArray());
    }

    byte[] computeDigest(String secret) {
        return MarketDataToken.computeDigest(this.tokenContract, this.tokenUser, this.tokenExpiration, secret);
    }

    private static byte[] computeDigest(String contract, String user, long expiration, String secret) {
        try {
            ByteArrayOutput bao = new ByteArrayOutput();
            bao.writeUTFString(contract);
            bao.writeUTFString(user);
            bao.writeCompactLong(expiration);
            bao.writeUTFString(secret);
            return MessageDigest.getInstance(DIGEST_ALGORITHM).digest(bao.toByteArray());
        }
        catch (IOException e) {
            log.error("Unexpected IOException", (Throwable)e);
            throw new IllegalStateException(e);
        }
        catch (NoSuchAlgorithmException e) {
            log.error("Unexpected NoSuchAlgorithmException", (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    static String getString(Map<String, String> configuration, String key, String def) {
        String value = configuration.get(key);
        return value == null ? def : value.toString();
    }

    private static synchronized long getDate(Map<String, String> configuration, String key, long def) {
        String value = MarketDataToken.getString(configuration, key, "").trim();
        if (value.length() == 0) {
            return def;
        }
        try {
            return DATE_FORMAT.parse(value).getTime();
        }
        catch (ParseException e) {
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException numberFormatException) {
                log.error("Error parsing date \"" + value + "\"", (Throwable)e);
                return def;
            }
        }
    }

    private static long getLong(Map<String, String> configuration, String key, long def) {
        String value = MarketDataToken.getString(configuration, key, "").trim();
        if (value.length() == 0) {
            return def;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            log.error("Error parsing long \"" + value + "\"", (Throwable)e);
            return def;
        }
    }
}

