/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.ondemand.impl;

import com.dxfeed.ondemand.impl.Block;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

class Segment {
    static final Comparator<Segment> USAGE_COMPARATOR = new Comparator<Segment>(){

        @Override
        public int compare(Segment segment1, Segment segment2) {
            return segment1.usage < segment2.usage ? -1 : (segment1.usage > segment2.usage ? 1 : Block.COMPARATOR.compare(segment1.block, segment2.block));
        }
    };
    private static final AtomicLongFieldUpdater<Segment> USAGE_UPDATER = AtomicLongFieldUpdater.newUpdater(Segment.class, "usage");
    final Block block;
    final long downloadTime;
    volatile long usage;
    int currentCounter;

    Segment(Block block) {
        this(block, System.currentTimeMillis());
    }

    Segment(Block block, long downloadTime) {
        block.setSymbol(block.getSymbol().intern());
        this.block = block;
        this.downloadTime = downloadTime;
    }

    public String toString() {
        return this.block.toString();
    }

    int size() {
        return 112 + this.block.getBodyLength();
    }

    boolean intersects(Segment segment) {
        return this.block.getStartTime() < segment.block.getEndTime() && this.block.getEndTime() > segment.block.getStartTime();
    }

    void updateUsage(long upd) {
        long cur;
        while ((cur = this.usage) < upd && !USAGE_UPDATER.compareAndSet(this, cur, upd)) {
        }
    }
}

