/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.ondemand.impl.event;

import com.devexperts.io.ByteArrayInput;
import com.devexperts.io.ByteArrayOutput;
import com.devexperts.qd.ng.RecordCursor;
import com.devexperts.qd.util.TimeSequenceUtil;
import com.dxfeed.event.market.impl.TradeMapping;
import com.dxfeed.ondemand.impl.event.MDREvent;
import java.io.IOException;

public class MDRTrade
extends MDREvent {
    private int lastTime;
    private int lastExchange;
    private int lastPrice;
    private int lastSize;
    private int lastTick;
    private int lastChange;
    private long volume;

    @Override
    public void init(long startTime) {
        long seconds = startTime / 1000L;
        this.eventTime = seconds * 1000L;
        this.lastTime = (int)seconds;
        this.lastExchange = 0;
        this.lastPrice = 0;
        this.lastSize = 0;
        this.lastTick = 0;
        this.lastChange = 0;
        this.volume = 0L;
    }

    @Override
    public boolean canSkip(MDREvent newEvent) {
        MDRTrade event = (MDRTrade)newEvent;
        return 0L == ((long)(this.lastTime - event.lastTime | this.lastExchange - event.lastExchange | this.lastPrice - event.lastPrice | this.lastSize - event.lastSize | this.lastTick - event.lastTick | this.lastChange - event.lastChange) | this.volume - event.volume);
    }

    @Override
    public boolean canConflate(MDREvent newEvent) {
        return true;
    }

    @Override
    public void getInto(RecordCursor cursor) {
        cursor.setEventTimeSequence(TimeSequenceUtil.getTimeSequenceFromTimeMillis((long)this.eventTime));
        TradeMapping mapping = (TradeMapping)cursor.getRecord().getMapping(TradeMapping.class);
        mapping.setLastTimeSeconds(cursor, this.lastTime);
        mapping.setLastExchange(cursor, (char)this.lastExchange);
        mapping.setLastPriceDecimal(cursor, this.lastPrice);
        mapping.setLastSize(cursor, this.lastSize);
        mapping.setLastTick(cursor, this.lastTick);
        mapping.setLastChangeDecimal(cursor, this.lastChange);
        mapping.setVolume(cursor, this.volume);
    }

    @Override
    public void setFrom(RecordCursor cursor) {
        this.setEventTime(TimeSequenceUtil.getTimeMillisFromTimeSequence((long)cursor.getEventTimeSequence()));
        TradeMapping mapping = (TradeMapping)cursor.getRecord().getMapping(TradeMapping.class);
        this.lastTime = mapping.getLastTimeSeconds(cursor);
        this.lastExchange = mapping.getLastExchange(cursor);
        this.lastPrice = mapping.getLastPriceDecimal(cursor);
        this.lastSize = mapping.getLastSize(cursor);
        this.lastTick = mapping.getLastTick(cursor);
        this.lastChange = mapping.getLastChangeDecimal(cursor);
        this.volume = mapping.getVolume(cursor);
        if (this.volume < 0L) {
            this.volume += 0x100000000L;
        }
    }

    @Override
    public void setFrom(MDREvent source) {
        MDRTrade event = (MDRTrade)source;
        this.eventTime = event.eventTime;
        this.lastTime = event.lastTime;
        this.lastExchange = event.lastExchange;
        this.lastPrice = event.lastPrice;
        this.lastSize = event.lastSize;
        this.lastTick = event.lastTick;
        this.lastChange = event.lastChange;
        this.volume = event.volume;
    }

    @Override
    public void read(ByteArrayInput in) throws IOException {
        this.eventTime += in.readCompactLong();
        int flag = in.readUnsignedByte();
        this.lastTime += MDRTrade.readDeltaFlagged(in, flag, 128);
        this.lastExchange += MDRTrade.readDeltaFlagged(in, flag, 64);
        this.lastPrice += MDRTrade.readDeltaFlagged(in, flag, 32);
        this.lastSize += MDRTrade.readDeltaFlagged(in, flag, 16);
        this.lastTick += MDRTrade.readDeltaFlagged(in, flag, 8);
        this.lastChange += MDRTrade.readDeltaFlagged(in, flag, 4);
        this.volume += (flag & 2) == 0 ? (long)this.lastSize : in.readCompactLong();
    }

    @Override
    public void write(ByteArrayOutput out, MDREvent newEvent) throws IOException {
        MDRTrade event = (MDRTrade)newEvent;
        out.writeCompactLong(event.eventTime - this.eventTime);
        int flagPosition = out.getPosition();
        out.writeByte(0);
        int flag = MDRTrade.writeDeltaFlagged(out, this.lastTime, event.lastTime, 128) | MDRTrade.writeDeltaFlagged(out, this.lastExchange, event.lastExchange, 64) | MDRTrade.writeDeltaFlagged(out, this.lastPrice, event.lastPrice, 32) | MDRTrade.writeDeltaFlagged(out, this.lastSize, event.lastSize, 16) | MDRTrade.writeDeltaFlagged(out, this.lastTick, event.lastTick, 8) | MDRTrade.writeDeltaFlagged(out, this.lastChange, event.lastChange, 4);
        if (event.volume != this.volume + (long)event.lastSize) {
            out.writeCompactLong(event.volume - this.volume);
            flag |= 2;
        }
        out.getBuffer()[flagPosition] = (byte)flag;
        this.setFrom(event);
    }
}

