/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.ondemand.impl;

import com.devexperts.io.URLInputStream;
import com.devexperts.logging.Logging;
import com.dxfeed.ondemand.impl.MarketDataToken;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class MarketDataAccess {
    public static final String DENY_LIST = "deny_list";
    private static final Logging log = Logging.getLogging(MarketDataAccess.class);
    private static final MarketDataAccess instance = new MarketDataAccess();
    private volatile Map configuration = Collections.emptyMap();
    private volatile Set<String> denyList = Collections.emptySet();
    private volatile Watcher watcher;

    public static MarketDataAccess getInstance() {
        return instance;
    }

    public void setConfiguration(Map configuration) {
        this.configuration = Collections.unmodifiableMap(new HashMap(configuration));
        this.denyList = Collections.unmodifiableSet(this.getDenyList(configuration));
    }

    private Set<String> getDenyList(Map configuration) {
        HashSet<String> result = new HashSet<String>();
        String listString = MarketDataToken.getString(configuration, DENY_LIST, "");
        for (String user : listString.split(",")) {
            String user1 = user.trim();
            if (user1.isEmpty()) continue;
            result.add(user1);
        }
        return result;
    }

    public void startConfigurationWatcher(String masterURL, String cacheFile, long period) {
        this.watcher = new Watcher(masterURL, cacheFile, period);
    }

    public void stopConfigurationWatcher() {
        this.watcher = null;
    }

    public MarketDataToken createToken(String user) {
        return new MarketDataToken(this.configuration, user);
    }

    public boolean checkAllowed(MarketDataToken token) {
        return !this.denyList.contains(token.getTokenUser() + "@" + token.getTokenContract());
    }

    public boolean verifyToken(MarketDataToken token) {
        String contractSecret = MarketDataToken.getString(this.configuration, "token_secret_" + token.getTokenContract(), null);
        if (contractSecret != null) {
            return Arrays.equals(token.getTokenDigest(), token.computeDigest(contractSecret));
        }
        String contract = MarketDataToken.getString(this.configuration, "token_contract", "");
        String secret = MarketDataToken.getString(this.configuration, "token_secret", "");
        return token.getTokenContract().equals(contract) && Arrays.equals(token.getTokenDigest(), token.computeDigest(secret));
    }

    private class Watcher
    implements Runnable {
        private final String url;
        private final String cache;
        private final long period;
        private byte[] data = new byte[0];

        public Watcher(String url, String cache, long period) {
            this.url = url;
            this.cache = cache;
            this.period = period;
            Thread t = new Thread((Runnable)this, "Watcher-" + cache);
            t.setDaemon(true);
            t.start();
        }

        @Override
        public void run() {
            try {
                this.data = URLInputStream.readURL((String)this.cache);
                this.updateConfiguration();
            }
            catch (FileNotFoundException e) {
                log.warn("File " + this.cache + " not found - treating as empty.");
            }
            catch (IOException e) {
                log.error("Failed to load file " + this.cache + " - treating as empty.", (Throwable)e);
            }
            while (MarketDataAccess.this.watcher == this) {
                try {
                    byte[] newData = URLInputStream.readURL((String)this.url);
                    if (newData.length == 0) {
                        log.error("Failed to download data for file " + this.cache);
                    } else if (!Arrays.equals(newData, this.data)) {
                        log.info("Downloaded new data for file " + this.cache);
                        this.data = newData;
                        this.updateConfiguration();
                        FileOutputStream out = new FileOutputStream(this.cache);
                        out.write(this.data);
                        out.close();
                    }
                    Thread.sleep((long)((double)this.period * (0.8 + 0.4 * Math.random())));
                }
                catch (Throwable t) {
                    log.error("Error updating file " + this.cache, t);
                    try {
                        Thread.sleep((long)(10000.0 * (1.0 + Math.random())));
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        private void updateConfiguration() throws IOException {
            Properties p = new Properties();
            p.load(new ByteArrayInputStream(this.data));
            if (MarketDataAccess.this.watcher == this) {
                MarketDataAccess.this.setConfiguration(p);
            }
        }
    }
}

