/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.ondemand.impl;

import com.devexperts.io.ByteArrayInput;
import com.devexperts.io.ByteArrayOutput;
import com.devexperts.io.IOUtil;
import com.devexperts.util.LockFreePool;
import com.devexperts.util.SystemProperties;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import java.util.zip.ZipException;

public class ReplayUtil {
    private static final int MAX_BUF = SystemProperties.getIntProperty((String)"com.devexperts.mds.replay.ZipBufferSize", (int)32768);
    private static final LockFreePool<Deflater> deflaters = new LockFreePool("com.devexperts.mds.replay.deflaters", 16);
    private static final LockFreePool<Inflater> inflaters = new LockFreePool("com.devexperts.mds.replay.inflaters", 16);
    private static final byte[] emptyInput = new byte[0];
    private static final byte[] dummyByte = new byte[1];

    public static int getCompactLength(byte[] buffer, int position) {
        int n = 1;
        for (byte b = buffer[position]; b < 0; b = (byte)(b << 1)) {
            ++n;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deflate(byte[] bytes, int offset, int length, int level, ByteArrayOutput out) {
        IOUtil.checkRange((byte[])bytes, (int)offset, (int)length);
        Deflater deflater = (Deflater)deflaters.poll();
        if (deflater == null) {
            deflater = new Deflater(-1, true);
        }
        try {
            deflater.setLevel(level);
            while (!deflater.finished()) {
                out.ensureCapacity(out.getPosition() + MAX_BUF);
                int bytesRead = (int)deflater.getBytesRead();
                if (bytesRead == length) {
                    deflater.finish();
                }
                deflater.setInput(bytes, offset + bytesRead, Math.min(length - bytesRead, MAX_BUF));
                int n = deflater.deflate(out.getBuffer(), out.getPosition(), Math.min(out.getLimit() - out.getPosition(), MAX_BUF));
                out.setPosition(out.getPosition() + n);
            }
        }
        finally {
            deflater.reset();
            deflater.setInput(emptyInput);
            if (!deflaters.offer((Object)deflater)) {
                deflater.end();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void inflate(byte[] bytes, int offset, int length, ByteArrayOutput out) throws DataFormatException {
        IOUtil.checkRange((byte[])bytes, (int)offset, (int)length);
        Inflater inflater = (Inflater)inflaters.poll();
        if (inflater == null) {
            inflater = new Inflater(true);
        }
        try {
            int dummyByteUsed = 0;
            while (!inflater.finished()) {
                out.ensureCapacity(out.getPosition() + MAX_BUF);
                int len = Math.min(length, MAX_BUF);
                inflater.setInput(bytes, offset, len);
                int n = inflater.inflate(out.getBuffer(), out.getPosition(), Math.min(out.getLimit() - out.getPosition(), MAX_BUF));
                offset += (len -= inflater.getRemaining());
                out.setPosition(out.getPosition() + n);
                if (n != 0 || (length -= len) != 0 || inflater.finished()) continue;
                if (inflater.needsInput()) {
                    if (dummyByteUsed == 0) {
                        bytes = dummyByte;
                        offset = 0;
                        dummyByteUsed = 1;
                        length = 1;
                        inflater.setInput(dummyByte, 0, 1);
                    } else {
                        throw new DataFormatException("Needs input.");
                    }
                }
                if (!inflater.needsDictionary()) continue;
                throw new DataFormatException("Needs dictionary.");
            }
            if (inflater.getRemaining() != dummyByteUsed) {
                throw new DataFormatException("Remaining bytes.");
            }
        }
        finally {
            inflater.reset();
            inflater.setInput(emptyInput);
            if (!inflaters.offer((Object)inflater)) {
                inflater.end();
            }
        }
    }

    public static boolean verifyDeflate(byte[] bytes, int offset, int length, ByteArrayOutput compressed) {
        try {
            ByteArrayOutput decompressed = new ByteArrayOutput(length);
            ReplayUtil.inflate(compressed.getBuffer(), 0, compressed.getPosition(), decompressed);
            if (decompressed.getPosition() != length) {
                return false;
            }
            for (int i = 0; i < length; ++i) {
                if (decompressed.getBuffer()[i] == bytes[offset + i]) continue;
                return false;
            }
        }
        catch (DataFormatException e) {
            return false;
        }
        return true;
    }

    public static void gzip(byte[] bytes, int offset, int length, int level, ByteArrayOutput out) throws IOException {
        out.writeShort(8075);
        out.writeLong(0x800000000000000L);
        ReplayUtil.deflate(bytes, offset, length, level, out);
        CRC32 crc = new CRC32();
        crc.update(bytes, offset, length);
        out.writeInt(Integer.reverseBytes((int)crc.getValue()));
        out.writeInt(Integer.reverseBytes(length));
    }

    public static void gunzip(byte[] bytes, int offset, int length, ByteArrayOutput out) throws IOException, DataFormatException {
        ByteArrayInput in = new ByteArrayInput(bytes, offset, length);
        int startPosition = in.getPosition();
        if (in.readShort() != 8075) {
            throw new IOException("Not a GZIP format.");
        }
        if (in.readByte() != 8) {
            throw new IOException("Unsupported compression method.");
        }
        int flg = in.readUnsignedByte();
        in.readInt();
        in.readUnsignedByte();
        in.readUnsignedByte();
        if ((flg & 4) != 0) {
            int n = Short.reverseBytes(in.readShort()) & 0xFFFF;
            for (int i = 0; i < n; ++i) {
                in.readUnsignedByte();
            }
        }
        if ((flg & 8) != 0) {
            while (in.readUnsignedByte() != 0) {
            }
        }
        if ((flg & 0x10) != 0) {
            while (in.readUnsignedByte() != 0) {
            }
        }
        if ((flg & 2) != 0) {
            CRC32 crc = new CRC32();
            crc.update(in.getBuffer(), startPosition, in.getPosition());
            if ((long)(Short.reverseBytes(in.readShort()) & 0xFFFF) != (crc.getValue() & 0xFFFFL)) {
                throw new IOException("Corrupt GZIP header.");
            }
        }
        if (in.getLimit() < in.getPosition() + 8) {
            throw new IOException("Unexpected end of stream.");
        }
        ReplayUtil.inflate(in.getBuffer(), in.getPosition(), in.getLimit() - in.getPosition() - 8, out);
    }

    public static void addGZippedElement(Map<String, ? super ByteArrayOutput> elements, String key, ByteArrayOutput value) throws IOException {
        if (value.getPosition() > 1000) {
            ByteArrayOutput compressed = new ByteArrayOutput(value.getPosition() + MAX_BUF);
            ReplayUtil.gzip(value.getBuffer(), 0, value.getPosition(), 1, compressed);
            if (value.getPosition() - compressed.getPosition() > Math.max(value.getPosition() / 20, 500)) {
                elements.put(key + ".gz", (ByteArrayOutput)compressed);
                return;
            }
        }
        elements.put(key, (ByteArrayOutput)value);
    }

    public static ByteArrayInput getGZippedElement(Map<String, byte[]> elements, String key) throws IOException {
        if (elements.containsKey(key)) {
            return new ByteArrayInput(elements.get(key));
        }
        byte[] compressed = elements.get(key + ".gz");
        if (compressed == null) {
            return new ByteArrayInput();
        }
        ByteArrayOutput decompressed = new ByteArrayOutput(compressed.length * 2 + MAX_BUF);
        try {
            ReplayUtil.gunzip(compressed, 0, compressed.length, decompressed);
        }
        catch (DataFormatException e) {
            throw new ZipException(e.getMessage());
        }
        return new ByteArrayInput(decompressed.getBuffer(), 0, decompressed.getPosition());
    }

    public static ByteArrayOutput writeElements(Map<String, ?> elements) throws IOException {
        ByteArrayOutput body = new ByteArrayOutput();
        body.writeCompactInt(2);
        body.writeCompactInt(elements.size());
        for (Map.Entry<String, ?> element : elements.entrySet()) {
            body.writeUTFString(element.getKey());
            Object value = element.getValue();
            if (value instanceof ByteArrayOutput) {
                ByteArrayOutput bao = (ByteArrayOutput)value;
                body.writeCompactInt(bao.getPosition());
                body.write(bao.getBuffer(), 0, bao.getPosition());
                continue;
            }
            if (value instanceof byte[] || value == null) {
                body.writeByteArray((byte[])value);
                continue;
            }
            body.writeUTFString(value.toString());
        }
        ByteArrayOutput out = new ByteArrayOutput(5 + body.getPosition());
        out.writeCompactInt(body.getPosition());
        out.write(body.getBuffer(), 0, body.getPosition());
        return out;
    }

    public static Map<String, byte[]> readElements(ByteArrayInput in) throws IOException {
        long length = in.readCompactLong();
        if (length < -1L || length > Integer.MAX_VALUE) {
            throw new IOException("Illegal length.");
        }
        if (length < 2L) {
            throw new IOException("Insufficient length.");
        }
        long version = in.readCompactLong();
        if (version != 2L) {
            throw new IOException("Unrecognized version: " + version);
        }
        LinkedHashMap<String, byte[]> elements = new LinkedHashMap<String, byte[]>();
        int elementCount = in.readCompactInt();
        for (int i = 0; i < elementCount; ++i) {
            elements.put(in.readUTFString(), in.readByteArray());
        }
        return elements;
    }
}

