/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.ondemand.impl.event;

import com.devexperts.io.ByteArrayInput;
import com.devexperts.io.ByteArrayOutput;
import com.devexperts.qd.DataRecord;
import com.devexperts.qd.ng.RecordCursor;
import com.devexperts.qd.util.TimeSequenceUtil;
import com.dxfeed.event.market.impl.FundamentalMapping;
import com.dxfeed.event.market.impl.SummaryMapping;
import com.dxfeed.ondemand.impl.event.MDREvent;
import java.io.IOException;

public class MDRSummary
extends MDREvent {
    private int highPrice;
    private int lowPrice;
    private int openPrice;
    private int closePrice;
    private int openInterest;

    @Override
    public void init(long startTime) {
        this.eventTime = startTime / 1000L * 1000L;
        this.highPrice = 0;
        this.lowPrice = 0;
        this.openPrice = 0;
        this.closePrice = 0;
        this.openInterest = 0;
    }

    @Override
    public boolean canSkip(MDREvent newEvent) {
        MDRSummary event = (MDRSummary)newEvent;
        return 0 == (this.highPrice - event.highPrice | this.lowPrice - event.lowPrice | this.openPrice - event.openPrice | this.closePrice - event.closePrice | this.openInterest - event.openInterest);
    }

    @Override
    public boolean canConflate(MDREvent newEvent) {
        return true;
    }

    @Override
    public void getInto(RecordCursor cursor) {
        cursor.setEventTimeSequence(TimeSequenceUtil.getTimeSequenceFromTimeMillis((long)this.eventTime));
        DataRecord record = cursor.getRecord();
        if (record.getMapping(FundamentalMapping.class) != null) {
            this.getIntoFundamental(cursor, (FundamentalMapping)record.getMapping(FundamentalMapping.class));
        } else {
            this.getIntoSummary(cursor, (SummaryMapping)record.getMapping(SummaryMapping.class));
        }
    }

    private void getIntoFundamental(RecordCursor cursor, FundamentalMapping mapping) {
        mapping.setHighPriceDecimal(cursor, this.highPrice);
        mapping.setLowPriceDecimal(cursor, this.lowPrice);
        mapping.setOpenPriceDecimal(cursor, this.openPrice);
        mapping.setClosePriceDecimal(cursor, this.closePrice);
        mapping.setOpenInterest(cursor, this.openInterest);
    }

    private void getIntoSummary(RecordCursor cursor, SummaryMapping mapping) {
        mapping.setDayHighPriceDecimal(cursor, this.highPrice);
        mapping.setDayLowPriceDecimal(cursor, this.lowPrice);
        mapping.setDayOpenPriceDecimal(cursor, this.openPrice);
        mapping.setPrevDayClosePriceDecimal(cursor, this.closePrice);
        mapping.setOpenInterest(cursor, this.openInterest);
    }

    @Override
    public void setFrom(RecordCursor cursor) {
        this.setEventTime(TimeSequenceUtil.getTimeMillisFromTimeSequence((long)cursor.getEventTimeSequence()));
        DataRecord record = cursor.getRecord();
        if (record.getMapping(FundamentalMapping.class) != null) {
            this.setFromFundamental(cursor, (FundamentalMapping)record.getMapping(FundamentalMapping.class));
        } else {
            this.setFromSummary(cursor, (SummaryMapping)record.getMapping(SummaryMapping.class));
        }
    }

    private void setFromFundamental(RecordCursor cursor, FundamentalMapping mapping) {
        this.highPrice = mapping.getHighPriceDecimal(cursor);
        this.lowPrice = mapping.getLowPriceDecimal(cursor);
        this.openPrice = mapping.getOpenPriceDecimal(cursor);
        this.closePrice = mapping.getClosePriceDecimal(cursor);
        this.openInterest = mapping.getOpenInterest(cursor);
    }

    private void setFromSummary(RecordCursor cursor, SummaryMapping mapping) {
        this.highPrice = mapping.getDayHighPriceDecimal(cursor);
        this.lowPrice = mapping.getDayLowPriceDecimal(cursor);
        this.openPrice = mapping.getDayOpenPriceDecimal(cursor);
        this.closePrice = mapping.getPrevDayClosePriceDecimal(cursor);
        this.openInterest = mapping.getOpenInterest(cursor);
    }

    @Override
    public void setFrom(MDREvent source) {
        MDRSummary event = (MDRSummary)source;
        this.eventTime = event.eventTime;
        this.highPrice = event.highPrice;
        this.lowPrice = event.lowPrice;
        this.openPrice = event.openPrice;
        this.closePrice = event.closePrice;
        this.openInterest = event.openInterest;
    }

    @Override
    public void read(ByteArrayInput in) throws IOException {
        this.eventTime += in.readCompactLong();
        int flag = in.readUnsignedByte();
        this.highPrice += MDRSummary.readDeltaFlagged(in, flag, 128);
        this.lowPrice += MDRSummary.readDeltaFlagged(in, flag, 64);
        this.openPrice += MDRSummary.readDeltaFlagged(in, flag, 32);
        this.closePrice += MDRSummary.readDeltaFlagged(in, flag, 16);
        this.openInterest += MDRSummary.readDeltaFlagged(in, flag, 8);
    }

    @Override
    public void write(ByteArrayOutput out, MDREvent newEvent) throws IOException {
        MDRSummary event = (MDRSummary)newEvent;
        out.writeCompactLong(event.eventTime - this.eventTime);
        int flagPosition = out.getPosition();
        out.writeByte(0);
        int flag = MDRSummary.writeDeltaFlagged(out, this.highPrice, event.highPrice, 128) | MDRSummary.writeDeltaFlagged(out, this.lowPrice, event.lowPrice, 64) | MDRSummary.writeDeltaFlagged(out, this.openPrice, event.openPrice, 32) | MDRSummary.writeDeltaFlagged(out, this.closePrice, event.closePrice, 16) | MDRSummary.writeDeltaFlagged(out, this.openInterest, event.openInterest, 8);
        out.getBuffer()[flagPosition] = (byte)flag;
        this.setFrom(event);
    }
}

