/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.plotter;

import com.dxfeed.api.DXEndpoint;
import com.dxfeed.api.DXFeed;
import com.dxfeed.api.DXFeedEventListener;
import com.dxfeed.api.DXFeedSubscription;
import com.dxfeed.event.market.Quote;
import com.dxfeed.plotter.DXFeedMarketDataPlotter;
import com.dxfeed.plotter.LabelFlashSupport;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

final class Feed {
    final String name;
    final LabelFlashSupport flasher;
    private final DXEndpoint endpoint;
    private final DXFeed feed;
    private final DXFeedSubscription<Quote> subscription;
    private final Set<String> symbols;
    private String lastAddress;
    private long lastReceivingTime;

    Feed(String name, LabelFlashSupport flasher, DXEndpoint endpoint) {
        this.name = name;
        this.flasher = flasher;
        this.endpoint = endpoint;
        this.feed = endpoint.getFeed();
        this.subscription = this.feed.createSubscription(Quote.class);
        this.subscription.addEventListener(events -> {
            this.lastReceivingTime = System.currentTimeMillis();
            if (flasher.isFlashing()) {
                flasher.updateColor(DXFeedMarketDataPlotter.WORKING_COLOR);
                flasher.stopFlashing();
            }
        });
        this.symbols = new HashSet<String>();
    }

    void connect(String address) {
        this.endpoint.connect(address);
        this.lastAddress = address;
    }

    void reconnect() {
        this.endpoint.connect(this.lastAddress);
    }

    void disconnect() {
        this.endpoint.disconnect();
    }

    void addListener(DXFeedEventListener<Quote> listener) {
        this.subscription.addEventListener(listener);
    }

    void removeSymbols(List<String> symbols) {
        if (this.symbols.removeAll(symbols)) {
            this.subscription.removeSymbols(symbols);
        }
    }

    void addSymbols(List<String> symbols) {
        if (this.symbols.addAll(symbols)) {
            this.subscription.addSymbols(symbols);
        }
    }

    long lastReceivingTime() {
        return this.lastReceivingTime;
    }
}

