/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.plotter;

import com.devexperts.util.TimeFormat;
import com.dxfeed.event.market.Quote;
import com.dxfeed.plotter.PlotData;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import javax.swing.JPanel;

class TickChartRendererPanel
extends JPanel {
    private static final Color COLOR_AXIS = new Color(105, 105, 105);
    private static final Color COLOR_CROSSHAIR = new Color(203, 160, 0, 192);
    private static final Color COLOR_CROSSHAIR_TEXT = COLOR_CROSSHAIR.brighter().brighter();
    private static final Color COLOR_CURSOR = COLOR_CROSSHAIR.brighter().brighter();
    private static final Color COLOR_SELECTION = new Color(255, 204, 0, 64);
    private static final int TIMELINE_PROTRUSION_MULTIPLIER = 10;
    private static final int TIMELINE_PROTRUSION_D = 4;
    private static final int TIMELINE_PROTRUSION_H = 3;
    private static final int TIMELINE_PROTRUSION_M = 2;
    private static final int TIMELINE_PROTRUSION_S = 1;
    private static final int TIMELINE_PROTRUSION_MS = 0;
    private static final int[] TIMELINE_PROTRUSIONS = new int[]{0, 1, 2, 3, 4};
    private static final Color[] COLOR_TRADE_TIMELINE = new Color[]{new Color(32, 32, 32), new Color(32, 32, 32), new Color(52, 52, 52), new Color(72, 72, 72), new Color(92, 92, 92)};
    private static final int[][] STRING_TIMELINE_INTERVAL = new int[][]{{16, 19}, {13, 15}, {11, 13}, {9, 11}, {0, 8}};
    private static final String[] STRING_TIME_AXIS_LABEL = new String[]{"", "seconds", "minutes", "hours", "days"};
    private static final int TITLE_HEIGHT = 20;
    private static final int CHART_TOP_MARGIN = 23;
    private static final int CHART_BOTTOM_MARGIN = 65;
    private static final int CHART_RIGHT_MARGIN = 50;
    private static final int LEFT_MARGIN = 2;
    private static final int CHART_LEFT_MARGIN = 52;
    private static final int AXIS_TEXT_MARGIN = 3;
    private static final int MIN_HEIGHT_EX_MARGINS = 10;
    private static final int MIN_WIDTH_EX_MARGINS = 90;
    private static final double SIZE_CHART_HEIGHT_PERCENT = 0.0;
    private static final double PRICE_CHART_HEIGHT_PERCENT = 0.97;
    private static final int MIN_TICK_DISPLAY_WIDTH = 3;
    private static final BasicStroke SIMPLE_STROKE = new BasicStroke(1.0f);
    private static final BasicStroke DASHED_STROKE = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{1.5f}, 0.0f);
    private static final Font DEFAULT_FONT = new Font("SansSerif", 0, 9);
    private static final Color[] COLORS = new Color[]{new Color(5887), new Color(52200), new Color(65353), new Color(10610688), new Color(16762880), new Color(15230464), new Color(0xFF0000), new Color(11075816)};
    private final ArrayList<Double> visibleQuotePrices = new ArrayList();
    private final ArrayList<Long> visibleQuoteTimes = new ArrayList();
    private final ArrayList<Long> drawnTimes = new ArrayList();
    private final ArrayList<Integer> visibleQuoteSourceId = new ArrayList();
    private final ArrayList<Integer> lastXBySourceId = new ArrayList();
    private final ArrayList<Integer> lastYBySourceId = new ArrayList();
    private final ArrayList<Integer> counterBySourceId = new ArrayList();
    private final ArrayList<String> labelBySourceId = new ArrayList();
    private final PriorityQueue<Integer> sources = new PriorityQueue<Integer>(4, new Comparator<Integer>(){

        @Override
        public int compare(Integer o1, Integer o2) {
            return -Long.compare(((PlotData)((TickChartRendererPanel)TickChartRendererPanel.this).plots.get((int)o1.intValue())).times.get((Integer)TickChartRendererPanel.this.counterBySourceId.get(o1)), ((PlotData)((TickChartRendererPanel)TickChartRendererPanel.this).plots.get((int)o2.intValue())).times.get((Integer)TickChartRendererPanel.this.counterBySourceId.get(o2)));
        }
    });
    private BufferedImage chartImage;
    private Graphics2D chartG2D;
    private List<PlotData> plots;
    private int lastWidth = 0;
    private int lastHeight = 0;
    private boolean repaintRequired = true;
    private boolean drawCrosshairX = false;
    private boolean drawCrosshairY = false;
    private double minPrice = Double.POSITIVE_INFINITY;
    private double maxPrice = Double.NEGATIVE_INFINITY;
    private int totalTickCount = 0;
    private int visibleTickCount = 0;
    private int chartHeightExMargins = 0;
    private int chartWidthExMargins = 0;
    private int tickDisplayWidth = 3;
    private boolean autoZoom = true;
    private double zoomFactorForPriceChart = 1.0;
    private int x_crossHair = 0;
    private int y_crossHair = 0;
    private boolean mouseInside = false;
    private int[] x_lastTimeLineProtrusion = new int[5];
    private int maxProtrusionLevel = -1;
    private long firstSelectedTickTime = -1L;
    private long secondSelectedTickTime = -1L;

    TickChartRendererPanel(List<PlotData> plots) {
        this.setBackground(Color.BLACK);
        this.plots = plots;
        this.setCursor();
    }

    private static double price(Quote quote) {
        return (quote.getBidPrice() + quote.getAskPrice()) / 2.0;
    }

    private static String price2String(double price) {
        return String.format("%.5f", price);
    }

    private static Color getColor(int idx) {
        return COLORS[idx % COLORS.length];
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.isRepaintRequired()) {
            this.clear();
            this.clearTimelines();
            this.computeChartSize();
            this.computeAuxiliaryArrays();
            this.computeChartZoomFactors();
            this.drawPriceAxisAndLabels();
            this.drawTitle();
            if (this.totalTickCount > 0 && this.chartHeightExMargins > 10 && this.chartWidthExMargins > 90) {
                long currentTime;
                int x = 52 + this.chartWidthExMargins - this.tickDisplayWidth;
                long firstVisibleTime = this.drawnTimes.get(this.visibleTickCount - 1);
                for (int i = 0; i < this.visibleQuoteTimes.size() && (currentTime = this.visibleQuoteTimes.get(i).longValue()) >= firstVisibleTime; ++i) {
                    long priorTime;
                    long l = priorTime = i + 1 < this.visibleQuoteTimes.size() ? this.visibleQuoteTimes.get(i + 1) : currentTime;
                    if (currentTime != priorTime) {
                        if (currentTime == this.firstSelectedTickTime || this.secondSelectedTickTime != -1L && (currentTime == this.secondSelectedTickTime || (currentTime - this.firstSelectedTickTime ^ this.secondSelectedTickTime - currentTime) > 0L)) {
                            this.chartG2D.setColor(COLOR_SELECTION);
                            this.chartG2D.fillRect(x, 23, this.tickDisplayWidth, this.chartHeightExMargins);
                        }
                        this.drawTimeLine(x, currentTime, priorTime);
                    }
                    double currentPrice = this.visibleQuotePrices.get(i);
                    int sourceId = this.visibleQuoteSourceId.get(i);
                    int px = this.lastXBySourceId.get(sourceId);
                    int y = this.getChartYCoordinateForPrice(currentPrice);
                    if (px == 0) {
                        this.drawPriceAndSourceLabels(this.labelBySourceId.get(sourceId), currentPrice, COLORS[sourceId % COLORS.length]);
                        this.chartImage.setRGB(52 + this.chartWidthExMargins - 1, y, TickChartRendererPanel.getColor(sourceId).getRGB());
                    } else {
                        int py = this.lastYBySourceId.get(sourceId);
                        this.chartG2D.setColor(TickChartRendererPanel.getColor(sourceId));
                        this.chartG2D.drawLine(x, y, px, py);
                    }
                    this.lastXBySourceId.set(sourceId, x);
                    this.lastYBySourceId.set(sourceId, y);
                    if (currentTime == priorTime) continue;
                    x -= this.tickDisplayWidth;
                }
                this.drawTimeLineProtrusionAxises();
            }
            this.setRepaintRequired(false);
        }
        g.drawImage(this.chartImage, 0, 0, null);
        if (this.visibleTickCount > 0 && this.chartHeightExMargins > 10 && this.chartWidthExMargins > 90 && (this.drawCrosshairX || this.drawCrosshairY)) {
            this.drawCrosshair(g);
        }
    }

    boolean isAutoZoom() {
        return this.autoZoom;
    }

    void setAutoZoom(boolean autoZoom) {
        this.autoZoom = autoZoom;
    }

    void setCrosshair(int x, int y) {
        this.x_crossHair = x;
        this.y_crossHair = y;
        this.setDrawCrosshair(x, y);
        this.repaint();
    }

    void mouseEntered(int x, int y) {
        this.mouseInside = true;
        this.setDrawCrosshair(x, y);
    }

    void mouseExited() {
        this.mouseInside = false;
        this.setDrawCrosshair(-1, -1);
        this.setRepaintRequired(true);
        this.repaint();
    }

    void zoom(int amount) {
        this.autoZoom = false;
        int w = this.tickDisplayWidth;
        if ((w += amount) > this.chartWidthExMargins) {
            w = this.chartWidthExMargins;
        }
        if (w < 3) {
            w = 3;
        }
        this.tickDisplayWidth = w;
        this.setRepaintRequired(true);
        this.repaint();
    }

    void selectTickOnCrosshair() {
        int tickIdx = this.getTickIndexByX(this.x_crossHair);
        if (tickIdx >= 0) {
            long time = this.drawnTimes.get(tickIdx);
            if (this.firstSelectedTickTime == -1L) {
                this.firstSelectedTickTime = time;
            } else if (this.secondSelectedTickTime == -1L) {
                this.secondSelectedTickTime = time;
            } else {
                this.firstSelectedTickTime = time;
                this.secondSelectedTickTime = -1L;
            }
        }
        this.setRepaintRequired(true);
    }

    void disableSelection() {
        this.secondSelectedTickTime = -1L;
        this.firstSelectedTickTime = -1L;
        this.setRepaintRequired(true);
    }

    private void computeAuxiliaryArrays() {
        this.clearAuxiliaryArrays();
        int sourceId = 0;
        for (PlotData plot : this.plots) {
            this.lastXBySourceId.add(0);
            this.lastYBySourceId.add(0);
            this.counterBySourceId.add(0);
            this.labelBySourceId.add(plot.name);
            if (plot.data.size() > 0) {
                this.sources.add(sourceId);
            }
            ++sourceId;
        }
        long previousTime = -1L;
        this.visibleTickCount = this.chartWidthExMargins / 3;
        while (this.drawnTimes.size() < this.visibleTickCount && !this.sources.isEmpty()) {
            sourceId = this.sources.poll();
            PlotData plot = this.plots.get(sourceId);
            int ptr = this.counterBySourceId.get(sourceId);
            Quote quote = plot.data.get(ptr);
            long time = plot.times.get(ptr);
            this.visibleQuotePrices.add(TickChartRendererPanel.price(quote));
            this.visibleQuoteTimes.add(time);
            this.visibleQuoteSourceId.add(sourceId);
            this.counterBySourceId.set(sourceId, ptr + 1);
            if (previousTime != time) {
                this.drawnTimes.add(time);
            }
            if (ptr + 1 < plot.data.size()) {
                this.sources.add(sourceId);
            }
            previousTime = time;
        }
        this.totalTickCount = this.drawnTimes.size();
        if (this.totalTickCount > 0) {
            if (this.autoZoom) {
                this.doAutoZoom();
            }
            this.visibleTickCount = this.chartWidthExMargins / this.tickDisplayWidth;
        }
        this.visibleTickCount = Math.min(this.visibleTickCount, this.totalTickCount);
    }

    private void clearAuxiliaryArrays() {
        this.visibleQuotePrices.clear();
        this.visibleQuoteTimes.clear();
        this.drawnTimes.clear();
        this.visibleQuoteSourceId.clear();
        this.lastXBySourceId.clear();
        this.lastYBySourceId.clear();
        this.counterBySourceId.clear();
        this.labelBySourceId.clear();
        this.sources.clear();
    }

    private void doAutoZoom() {
        this.autoZoom = true;
        this.tickDisplayWidth = Math.max(this.chartWidthExMargins / this.totalTickCount, 3);
    }

    private void setCursor() {
        BufferedImage cursorImg = new BufferedImage(32, 32, 2);
        Graphics2D g2d = (Graphics2D)cursorImg.getGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2d.setColor(COLOR_CURSOR);
        g2d.drawLine(0, 8, 16, 8);
        g2d.drawLine(8, 0, 8, 16);
        this.setCursor(Toolkit.getDefaultToolkit().createCustomCursor(cursorImg, new Point(8, 8), "Crosshair cursor"));
    }

    private void setDrawCrosshair(int x, int y) {
        this.drawCrosshairX = this.mouseInside && x > 52 && x < 52 + this.chartWidthExMargins;
        this.drawCrosshairY = y > 23 && (double)y < 23.0 + (double)this.chartHeightExMargins * 0.97;
    }

    private void clear() {
        if (this.chartImage == null || this.chartImage.getWidth() != this.getWidth() || this.chartImage.getHeight() != this.getHeight()) {
            this.createEmptyImage();
        } else {
            this.chartG2D.clearRect(0, 0, this.getWidth(), this.getHeight());
        }
        this.setRepaintRequired(true);
    }

    private void createEmptyImage() {
        if (this.getWidth() > 0 && this.getHeight() > 0) {
            this.chartImage = new BufferedImage(this.getWidth(), this.getHeight(), 2);
            this.chartG2D = (Graphics2D)this.chartImage.getGraphics();
            this.chartG2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.chartG2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            this.chartG2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            this.chartG2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            this.chartG2D.setFont(DEFAULT_FONT);
        }
    }

    private void clearTimelines() {
        Arrays.fill(this.x_lastTimeLineProtrusion, 0);
        this.maxProtrusionLevel = -1;
    }

    private void computeChartSize() {
        this.chartHeightExMargins = this.getHeight() - 23 - 65;
        this.chartWidthExMargins = this.getWidth() - 52 - 50;
    }

    private void computeChartZoomFactors() {
        this.minPrice = Double.POSITIVE_INFINITY;
        this.maxPrice = Double.NEGATIVE_INFINITY;
        long firstVisibleTime = this.visibleTickCount > 0 ? this.drawnTimes.get(this.visibleTickCount - 1) : 0L;
        for (int i = 0; i < this.visibleQuoteTimes.size() && this.visibleQuoteTimes.get(i) >= firstVisibleTime; ++i) {
            double price = this.visibleQuotePrices.get(i);
            this.minPrice = Math.min(this.minPrice, price);
            this.maxPrice = Math.max(this.maxPrice, price);
        }
        this.zoomFactorForPriceChart = 0.97 * (double)this.chartHeightExMargins / (this.maxPrice - this.minPrice);
    }

    private void drawTitle() {
        String period = this.totalTickCount > 1 ? "showing " + this.visibleTickCount + " of " + this.totalTickCount + " last ticks" : (this.totalTickCount == 1 ? "single tick" : "waiting for data...");
        FontMetrics metrics = this.chartG2D.getFontMetrics(this.chartG2D.getFont());
        Rectangle2D bounds = metrics.getStringBounds(period, null);
        this.chartG2D.setColor(COLOR_AXIS);
        this.chartG2D.drawString(period, 1, (int)bounds.getHeight() + 2);
        int offset = 1 + (int)bounds.getWidth() + 13;
        for (int sourceId = 0; sourceId < this.plots.size(); ++sourceId) {
            if (this.counterBySourceId.get(sourceId) <= 0) continue;
            bounds = metrics.getStringBounds(this.labelBySourceId.get(sourceId), null);
            this.chartG2D.setColor(TickChartRendererPanel.getColor(sourceId));
            this.chartG2D.drawString(this.labelBySourceId.get(sourceId), offset, (int)bounds.getHeight() + 2);
            offset += (int)bounds.getWidth() + 5;
        }
    }

    private int getChartYCoordinateForPrice(double price) {
        int y = price == 0.0 || Double.isNaN(price) ? (int)((this.maxPrice - this.minPrice) * this.zoomFactorForPriceChart) : (int)((this.maxPrice - price) * this.zoomFactorForPriceChart);
        return y + 23;
    }

    private double getPriceByY(int y) {
        double price = 0.0;
        if (this.zoomFactorForPriceChart > 0.0) {
            price = this.maxPrice - (double)(y - 23) / this.zoomFactorForPriceChart;
        }
        return price;
    }

    private void drawCrosshair(Graphics g) {
        g.setFont(DEFAULT_FONT);
        FontMetrics metrics = g.getFontMetrics(g.getFont());
        long timeUnderCursor = 0L;
        if (this.drawCrosshairX) {
            g.setColor(COLOR_CROSSHAIR);
            g.drawLine(this.x_crossHair, 23, this.x_crossHair, this.getHeight() - 14);
            int tickIndexAtCrosshair = this.getTickIndexByX(this.x_crossHair);
            if (tickIndexAtCrosshair >= 0) {
                g.setColor(COLOR_CROSSHAIR_TEXT);
                timeUnderCursor = this.drawnTimes.get(tickIndexAtCrosshair);
                String strTimeAtCrosshair = TimeFormat.DEFAULT.withMillis().format(timeUnderCursor);
                Rectangle2D bounds = metrics.getStringBounds(strTimeAtCrosshair, null);
                int x_text = this.x_crossHair - (int)bounds.getWidth() / 2;
                if (x_text < (int)bounds.getWidth() / 2) {
                    x_text = this.x_crossHair;
                } else if (x_text > 52 + this.chartWidthExMargins - (int)bounds.getWidth() / 2) {
                    x_text = this.x_crossHair - metrics.stringWidth(strTimeAtCrosshair);
                }
                g.drawString(strTimeAtCrosshair, x_text, this.getHeight() - 4);
            }
        }
        if (this.drawCrosshairY) {
            g.setColor(COLOR_CROSSHAIR);
            g.drawLine(52, this.y_crossHair, 52 + this.chartWidthExMargins, this.y_crossHair);
            this.drawPriceLabel(g, this.y_crossHair, TickChartRendererPanel.price2String(this.getPriceByY(this.y_crossHair)), COLOR_CROSSHAIR_TEXT, true);
        }
        if (this.drawCrosshairX && this.drawCrosshairY && this.firstSelectedTickTime >= 0L) {
            long elapsedTime = timeUnderCursor - this.firstSelectedTickTime;
            this.drawCrosshairLabel(g, elapsedTime + "ms.", this.x_crossHair, this.y_crossHair, COLOR_SELECTION);
            if (this.secondSelectedTickTime >= 0L) {
                elapsedTime = this.secondSelectedTickTime - this.firstSelectedTickTime;
                this.drawCrosshairLabelBelow(g, elapsedTime + "ms.", this.x_crossHair, this.y_crossHair, COLOR_SELECTION);
            }
        }
    }

    private int getTickIndexByX(int x) {
        int tickIndex = -1;
        if (x > 52 && x < 52 + this.chartWidthExMargins && this.visibleTickCount > 0 && (tickIndex = (52 + this.chartWidthExMargins - x) / this.tickDisplayWidth) > this.visibleTickCount - 1) {
            tickIndex = -1;
        }
        return tickIndex;
    }

    private void drawCrosshairLabel(Graphics g, String label, int x, int y, Color color) {
        FontMetrics metrics = g.getFontMetrics(g.getFont());
        Rectangle2D bounds = metrics.getStringBounds(label, null);
        this.drawCrosshairLabel(g, label, x, y - 2, color, bounds);
    }

    private void drawCrosshairLabelBelow(Graphics g, String label, int x, int y, Color color) {
        FontMetrics metrics = g.getFontMetrics(g.getFont());
        Rectangle2D bounds = metrics.getStringBounds(label, null);
        this.drawCrosshairLabel(g, label, x, y + (int)bounds.getHeight() + 2, color, bounds);
    }

    private void drawCrosshairLabel(Graphics g, String label, int x, int y, Color color, Rectangle2D bounds) {
        Color c = color.darker().darker().darker();
        g.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), 192));
        g.fillRect(x + 2, y - (int)bounds.getHeight() - 1, (int)bounds.getWidth() + 2, (int)bounds.getHeight() + 2);
        g.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), 192));
        g.drawRect(x + 2, y - (int)bounds.getHeight() - 1, (int)bounds.getWidth() + 2, (int)bounds.getHeight() + 2);
        g.drawString(label, x + 4, y - 2);
    }

    private boolean isRepaintRequired() {
        return this.repaintRequired || this.lastWidth != this.getWidth() || this.lastHeight != this.getHeight();
    }

    void setRepaintRequired(boolean repaintRequired) {
        this.repaintRequired = repaintRequired;
        if (repaintRequired) {
            this.setDrawCrosshair(this.x_crossHair, this.y_crossHair);
        } else {
            this.lastWidth = this.getWidth();
            this.lastHeight = this.getHeight();
        }
    }

    private void drawTimeLine(int x, long previousTime, long currentTime) {
        String strPriorTime = TimeFormat.DEFAULT.withMillis().format(previousTime);
        String strCurTime = TimeFormat.DEFAULT.withMillis().format(currentTime);
        FontMetrics metrics = this.chartG2D.getFontMetrics(this.chartG2D.getFont());
        Stroke oldStroke = this.chartG2D.getStroke();
        for (int protrusionLevel : TIMELINE_PROTRUSIONS) {
            if (!strPriorTime.regionMatches(0, strCurTime, 0, STRING_TIMELINE_INTERVAL[protrusionLevel][1])) {
                String strTimeAxisLabel = strCurTime.substring(STRING_TIMELINE_INTERVAL[protrusionLevel][0], STRING_TIMELINE_INTERVAL[protrusionLevel][1]);
                this.chartG2D.setStroke(protrusionLevel == 0 ? DASHED_STROKE : SIMPLE_STROKE);
                this.chartG2D.setColor(COLOR_TRADE_TIMELINE[protrusionLevel]);
                int y_timeLine = 23 + this.chartHeightExMargins + 2 + protrusionLevel * 10;
                this.chartG2D.drawLine(x, 23, x, y_timeLine);
                if (protrusionLevel == 0) continue;
                int x_last = this.x_lastTimeLineProtrusion[protrusionLevel];
                Rectangle2D bounds = metrics.getStringBounds(strTimeAxisLabel, null);
                if (x_last != 0 && x_last - x <= (int)bounds.getWidth() / 2 + 4) continue;
                this.chartG2D.setColor(COLOR_TRADE_TIMELINE[protrusionLevel].brighter().brighter());
                this.chartG2D.drawString(strTimeAxisLabel, x - (int)bounds.getWidth() / 2 + 1, y_timeLine + (int)bounds.getHeight() - 2);
                this.x_lastTimeLineProtrusion[protrusionLevel] = x;
                continue;
            }
            this.maxProtrusionLevel = Math.max(this.maxProtrusionLevel, protrusionLevel - 1);
            break;
        }
        this.chartG2D.setStroke(oldStroke);
    }

    private void drawTimeLineProtrusionAxises() {
        FontMetrics metrics = this.chartG2D.getFontMetrics(this.chartG2D.getFont());
        for (int protrusionLevel : TIMELINE_PROTRUSIONS) {
            if (protrusionLevel == 0 || protrusionLevel > this.maxProtrusionLevel) continue;
            this.chartG2D.setColor(COLOR_TRADE_TIMELINE[protrusionLevel]);
            int y_timeLine = 23 + this.chartHeightExMargins + 2 + protrusionLevel * 10;
            this.chartG2D.drawLine(52, y_timeLine, 52 + this.chartWidthExMargins, y_timeLine);
            String strTimeLineAxisLabel = STRING_TIME_AXIS_LABEL[protrusionLevel];
            Rectangle2D bounds = metrics.getStringBounds(strTimeLineAxisLabel, null);
            this.chartG2D.drawString(strTimeLineAxisLabel, 52 + this.chartWidthExMargins + 2, y_timeLine + (int)bounds.getHeight() / 2 - 1);
        }
    }

    private void drawPriceAndSourceLabels(String sourceName, double currentPrice, Color color) {
        String strLabel = TickChartRendererPanel.price2String(currentPrice);
        int y_curTickPrice = this.getChartYCoordinateForPrice(currentPrice);
        this.drawPriceLabel(y_curTickPrice, strLabel, color, false);
    }

    private void drawPriceAxisAndLabels() {
        String strMinPrice = TickChartRendererPanel.price2String(this.minPrice);
        String strMaxPrice = TickChartRendererPanel.price2String(this.maxPrice);
        Stroke oldStroke = this.chartG2D.getStroke();
        this.chartG2D.setStroke(SIMPLE_STROKE);
        this.drawPriceAxis();
        this.chartG2D.setStroke(oldStroke);
        this.drawPriceLabel(23 + (int)((double)this.chartHeightExMargins * 0.97), strMinPrice, COLOR_AXIS, true);
        this.drawPriceLabel(23, strMaxPrice, COLOR_AXIS, true);
    }

    private void drawPriceAxis() {
        int x1 = 52;
        int x2 = 52 + this.chartWidthExMargins;
        int y1 = 23;
        int y2 = 23 + (int)((double)this.chartHeightExMargins * 0.97);
        this.chartG2D.setColor(COLOR_AXIS);
        this.chartG2D.drawLine(52, 23, 52, y2);
        this.chartG2D.drawLine(x2, 23, x2, y2);
    }

    private void drawPriceLabel(int y_priceLabel, String strPrice, Color color, boolean bothSides) {
        this.drawPriceLabel(this.chartG2D, y_priceLabel, strPrice, color, bothSides);
    }

    private void drawPriceLabel(Graphics g, int y_priceLabel, String strPrice, Color color, boolean bothSides) {
        g.setColor(color);
        int x = 52 + this.chartWidthExMargins + 3;
        Rectangle2D bounds = g.getFontMetrics().getStringBounds(strPrice, null);
        g.drawString(strPrice, x, y_priceLabel + (int)bounds.getHeight() / 2 - 2);
        if (bothSides) {
            x = 49 - (int)bounds.getWidth();
            g.drawString(strPrice, x, y_priceLabel + (int)bounds.getHeight() / 2 - 2);
        }
    }
}

