/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.plotter;

import com.devexperts.logging.Logging;
import com.devexperts.util.LogUtil;
import com.dxfeed.api.DXEndpoint;
import com.dxfeed.api.DXFeedEventListener;
import com.dxfeed.event.market.Quote;
import com.dxfeed.plotter.Feed;
import com.dxfeed.plotter.LabelFlashSupport;
import com.dxfeed.plotter.PlotData;
import com.dxfeed.plotter.SimpleMovingQueue;
import com.dxfeed.plotter.Stats;
import com.dxfeed.plotter.SwingExecutor;
import com.dxfeed.plotter.TickChartRendererPanel;
import com.formdev.flatlaf.intellijthemes.FlatOneDarkIJTheme;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.StyleContext;

public class DXFeedMarketDataPlotter
implements Runnable {
    private static final Logging log = Logging.getLogging(DXFeedMarketDataPlotter.class);
    private static final String PROPERTIES_FILE = "dxplotter.cfg";
    private static final String PROPERTIES_PATH = File.separatorChar + ".dxplotter" + File.separatorChar + "dxplotter.cfg";
    private static final String NAME_PROPERTY = "name";
    private static final String ADDRESSES_PROPERTY = "addresses";
    private static final String SYMBOLS_PROPERTY = "symbols";
    private static final String MAX_QUOTES_PROPERTY = "maxQuotesCapacity";
    private static final String UI_REFRESH_PERIOD_PROPERTY = "uiRefreshPeriod";
    private static final String PROCRASTINATION_PERIOD_PROPERTY = "procrastinationPeriod";
    private static final int MIN_UI_REFRESH_PERIOD = 10;
    private static final int MIN_PROCRASTINATION_PERIOD = 150;
    static final Color WORKING_COLOR = Color.green;
    static final Color PROCRASTINATING_COLOR = Color.red;
    private final String configFile;
    private final String name;
    private final String addresses;
    private final int maxQuotesCapacity;
    private final int uiRefreshPeriod;
    private final int procrastinationPeriod;
    private final ScheduledExecutorService procrastinationChecker = Executors.newSingleThreadScheduledExecutor();
    private final SimpleDateFormat timeFormatSelectedTZ = new SimpleDateFormat("yyyyMMdd-HHmmss");
    private final Stats eventStats = new Stats("Total/s");
    private final Stats quoteStats = new Stats("Q/s");
    private JPanel form;
    private JLabel mpsLabel;
    private JLabel qpsLabel;
    private JPanel tickChartPanel;
    private JTabbedPane tabbedPane;
    private JTextField subscribedSymbolsEdit;
    private JButton playButton;
    private JButton pauseButton;
    private JToolBar addressToolbar;
    private JLabel currentTimeLabel;
    private JPanel endpointLabelsPanel;
    private TickChartRendererPanel tickChartRendererPanel;
    private JFrame mainFrame;
    private String[] symbols;
    private List<Feed> feeds;
    private List<PlotData> plots;
    private Map<String, Integer> plotIdxByName;
    private final Action pause = new AbstractAction("Freeze"){

        @Override
        public void actionPerformed(ActionEvent e) {
            for (Feed feed : DXFeedMarketDataPlotter.this.feeds) {
                feed.disconnect();
            }
            DXFeedMarketDataPlotter.this.pauseButton.setEnabled(false);
            DXFeedMarketDataPlotter.this.playButton.setEnabled(true);
        }
    };
    private final Action play = new AbstractAction("Unfreeze"){

        @Override
        public void actionPerformed(ActionEvent e) {
            for (Feed feed : DXFeedMarketDataPlotter.this.feeds) {
                feed.reconnect();
            }
            DXFeedMarketDataPlotter.this.pauseButton.setEnabled(true);
            DXFeedMarketDataPlotter.this.playButton.setEnabled(false);
        }
    };

    private DXFeedMarketDataPlotter(String configFile) {
        this.configFile = configFile;
        this.$$$setupUI$$$();
        Properties properties = DXFeedMarketDataPlotter.loadConfiguration(configFile);
        this.name = properties.getProperty(NAME_PROPERTY, "");
        this.addresses = properties.getProperty(ADDRESSES_PROPERTY, "demo demo.dxfeed.com:7300");
        String symbolsCsv = properties.getProperty(SYMBOLS_PROPERTY, "");
        this.symbols = DXFeedMarketDataPlotter.sortAndUnique(symbolsCsv);
        this.maxQuotesCapacity = DXFeedMarketDataPlotter.getIntProperty(properties.getProperty(MAX_QUOTES_PROPERTY), 1000);
        this.uiRefreshPeriod = Math.max(10, DXFeedMarketDataPlotter.getIntProperty(properties.getProperty(UI_REFRESH_PERIOD_PROPERTY), 150));
        this.procrastinationPeriod = Math.max(150, DXFeedMarketDataPlotter.getIntProperty(properties.getProperty(PROCRASTINATION_PERIOD_PROPERTY), 3000));
    }

    private static int getIntProperty(String value, int defaultValue) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            log.error("Failed to parse integer property from string \"" + value + "\"");
            return defaultValue;
        }
    }

    private static String stringsToCsv(String[] array) {
        if (array.length == 0) {
            return "";
        }
        StringBuilder csv = new StringBuilder(array[0]);
        for (int i = 1; i < array.length; ++i) {
            csv.append(',').append(array[i]);
        }
        return csv.toString();
    }

    private static String[] sortAndUnique(String csv) {
        Object[] array = csv.split(",");
        Arrays.sort(array);
        int ptr = 1;
        for (int i = 1; i < array.length; ++i) {
            if (((String)array[i]).equals(array[i - 1])) continue;
            array[ptr++] = array[i];
        }
        if (ptr == array.length) {
            return array;
        }
        return (String[])Arrays.copyOf(array, ptr);
    }

    private static Properties loadConfiguration(String configFile) {
        Properties properties = new Properties();
        File file = new File(configFile);
        if (!file.exists()) {
            log.info(LogUtil.hideCredentials((Object)file.getAbsoluteFile()) + " file not found; will use default configuration");
            file = new File(PROPERTIES_FILE);
        }
        if (file.exists()) {
            log.info("Loading configuration from " + LogUtil.hideCredentials((Object)file.getAbsoluteFile()));
            try (FileInputStream in = new FileInputStream(file);){
                properties.load(in);
            }
            catch (IOException e) {
                log.error("Failed to load configuration from " + LogUtil.hideCredentials((Object)file.getAbsoluteFile()) + "; will use default configuration");
            }
        }
        return properties;
    }

    private void saveConfiguration(String configFile) {
        File file = new File(configFile);
        log.info("Saving configuration into " + LogUtil.hideCredentials((Object)file.getAbsoluteFile()));
        try {
            Properties properties = new Properties();
            properties.setProperty(NAME_PROPERTY, this.name);
            properties.setProperty(ADDRESSES_PROPERTY, this.addresses);
            properties.setProperty(SYMBOLS_PROPERTY, DXFeedMarketDataPlotter.stringsToCsv(this.symbols));
            properties.setProperty(MAX_QUOTES_PROPERTY, Integer.toString(this.maxQuotesCapacity));
            properties.setProperty(UI_REFRESH_PERIOD_PROPERTY, Integer.toString(this.uiRefreshPeriod));
            if (file.getParentFile() != null && !file.getParentFile().mkdirs()) {
                log.warn("Failed to create path to configuration file");
            }
            properties.store(new FileOutputStream(file), "dxFeed Market Data Plotter Configuration");
        }
        catch (IOException e) {
            log.error("Failed to save configuration into " + LogUtil.hideCredentials((Object)file.getAbsoluteFile()), (Throwable)e);
        }
    }

    private static void setDarkTheme() {
        try {
            UIManager.setLookAndFeel((LookAndFeel)new FlatOneDarkIJTheme());
            FontUIResource text = (FontUIResource)UIManager.get("defaultFont");
            Font boldFont = text.deriveFont(1, text.getSize());
            UIManager.put("defaultFont", new FontUIResource(boldFont));
            UIManager.put("Component.arrowType", "chevron");
            UIManager.put("Component.focusWidth", 1);
            UIManager.put("ScrollBar.width", 16);
            UIManager.put("ScrollBar.showButtons", true);
            UIManager.put("Table.intercellSpacing", new Dimension(1, 1));
        }
        catch (Exception e) {
            log.error("Cannot set LookAndFeel theme", (Throwable)e);
        }
    }

    public static void main(String[] args) {
        DXFeedMarketDataPlotter.setDarkTheme();
        String defaultConfigFile = System.getProperty("user.home") + PROPERTIES_PATH;
        String configFile = args.length > 0 ? args[0] : defaultConfigFile;
        SwingUtilities.invokeLater(new DXFeedMarketDataPlotter(configFile));
    }

    @Override
    public void run() {
        this.createFeed();
        this.initTickChartRendererPanel();
        this.initStatsUpdater();
        this.createFrame();
        this.startProcrastinationChecker();
    }

    private void createFeed() {
        String[] addressList = this.addresses.split(",");
        this.plots = new ArrayList<PlotData>();
        this.plotIdxByName = new HashMap<String, Integer>();
        this.feeds = new ArrayList<Feed>(addressList.length);
        for (String nameAddress : addressList) {
            String address;
            String name;
            int spaceIdx = nameAddress.indexOf(32);
            if (spaceIdx == -1) {
                name = LogUtil.hideCredentials((Object)nameAddress);
                address = nameAddress;
            } else {
                name = nameAddress.substring(0, spaceIdx);
                address = nameAddress.substring(spaceIdx + 1);
            }
            String wrappedName = "-" + name;
            for (String symbol : this.symbols) {
                String plotName = symbol + wrappedName;
                if (this.plotIdxByName.containsKey(plotName)) {
                    throw new IllegalStateException("Plot name of symbol '" + symbol + "' and feedName '" + name + "' is already used");
                }
                this.plotIdxByName.put(plotName, this.plots.size());
                this.plots.add(new PlotData(plotName, new SimpleMovingQueue<Quote>(this.maxQuotesCapacity), new SimpleMovingQueue<Long>(this.maxQuotesCapacity)));
            }
            JLabel label = new JLabel(name);
            label.setForeground(WORKING_COLOR);
            this.endpointLabelsPanel.add(label);
            JSeparator separator = new JSeparator(1);
            separator.setPreferredSize(new Dimension(10, 14));
            this.endpointLabelsPanel.add(separator);
            Feed feed = new Feed(name, new LabelFlashSupport(label), DXEndpoint.create().executor((Executor)new SwingExecutor(this.uiRefreshPeriod)));
            feed.addListener((DXFeedEventListener<Quote>)((DXFeedEventListener)events -> {
                long receiveTime = System.currentTimeMillis();
                this.eventStats.increment(events.size());
                this.quoteStats.increment(events.size());
                for (Quote quote : events) {
                    PlotData plot = this.plots.get(this.plotIdxByName.get(quote.getEventSymbol() + wrappedName));
                    plot.data.add(quote);
                    plot.times.add(receiveTime);
                }
                this.tickChartRendererPanel.setRepaintRequired(true);
                this.tickChartRendererPanel.repaint();
            }));
            feed.addSymbols(Arrays.asList(this.symbols));
            feed.connect(address);
            this.feeds.add(feed);
            log.info("Connected to '" + name + "' (" + LogUtil.hideCredentials((Object)address) + ")");
        }
    }

    private void initTickChartRendererPanel() {
        this.tickChartRendererPanel = new TickChartRendererPanel(this.plots);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.fill = 1;
        this.tickChartPanel.setLayout(new GridBagLayout());
        this.tickChartPanel.add((Component)this.tickChartRendererPanel, gbc);
        this.tickChartRendererPanel.addMouseWheelListener(e -> this.tickChartRendererPanel.zoom(-e.getWheelRotation() * 2));
        this.tickChartRendererPanel.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                DXFeedMarketDataPlotter.this.tickChartRendererPanel.setCrosshair(e.getX(), e.getY());
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                DXFeedMarketDataPlotter.this.tickChartRendererPanel.setCrosshair(e.getX(), e.getY());
            }
        });
        this.tickChartRendererPanel.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                DXFeedMarketDataPlotter.this.tickChartRendererPanel.selectTickOnCrosshair();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                DXFeedMarketDataPlotter.this.tickChartRendererPanel.mouseExited();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                DXFeedMarketDataPlotter.this.tickChartRendererPanel.mouseEntered(e.getX(), e.getY());
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }
        });
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(e -> {
            if (e.getKeyCode() == 27) {
                this.tickChartRendererPanel.disableSelection();
            }
            return false;
        });
    }

    private void setCurrentTimeLabel(Date time) {
        this.currentTimeLabel.setText(this.timeFormatSelectedTZ.format(time));
    }

    private void initStatsUpdater() {
        Timer timer = new Timer(1000, new ActionListener(){
            private long lastTime = System.currentTimeMillis();

            @Override
            public void actionPerformed(ActionEvent e) {
                long curTime = System.currentTimeMillis();
                long delta = curTime - this.lastTime;
                DXFeedMarketDataPlotter.this.mpsLabel.setText(DXFeedMarketDataPlotter.this.eventStats.update(delta));
                DXFeedMarketDataPlotter.this.qpsLabel.setText(DXFeedMarketDataPlotter.this.quoteStats.update(delta));
                DXFeedMarketDataPlotter.this.setCurrentTimeLabel(new Date(curTime));
                this.lastTime = curTime;
            }
        });
        timer.start();
    }

    private void createFrame() {
        this.mainFrame = new JFrame("dxFeed Market Data Plotter" + (this.name.length() == 0 ? "" : ": " + this.name));
        this.mainFrame.add(this.form);
        this.mainFrame.pack();
        this.mainFrame.setLocationByPlatform(true);
        this.mainFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                DXFeedMarketDataPlotter.this.saveConfiguration(DXFeedMarketDataPlotter.this.configFile);
                System.exit(0);
            }
        });
        this.pauseButton.addActionListener(this.pause);
        this.playButton.addActionListener(this.play);
        this.subscribedSymbolsEdit.setText(DXFeedMarketDataPlotter.stringsToCsv(this.symbols));
        this.subscribedSymbolsEdit.addActionListener(e -> {
            this.updateSubscription(this.subscribedSymbolsEdit.getText());
            this.tickChartRendererPanel.setRepaintRequired(true);
        });
        this.setComponentSizes();
        this.mainFrame.setMinimumSize(new Dimension(800, 600));
        this.mainFrame.setExtendedState(this.mainFrame.getExtendedState() | 6);
        this.mainFrame.setVisible(true);
    }

    private void startProcrastinationChecker() {
        this.procrastinationChecker.scheduleWithFixedDelay(() -> {
            long threshold = System.currentTimeMillis() - (long)this.procrastinationPeriod;
            for (Feed feed : this.feeds) {
                if (feed.lastReceivingTime() >= threshold || feed.flasher.isFlashing()) continue;
                feed.flasher.updateColor(PROCRASTINATING_COLOR);
                feed.flasher.startFlashing();
            }
        }, this.procrastinationPeriod, this.procrastinationPeriod, TimeUnit.MILLISECONDS);
    }

    private void updateSubscription(String newSymbolsCsv) {
        this.updateSubscription(DXFeedMarketDataPlotter.sortAndUnique(newSymbolsCsv));
    }

    private void updateSubscription(String[] newSymbols) {
        int i;
        HashSet<String> removed = new HashSet<String>(this.symbols.length);
        ArrayList<String> added = new ArrayList<String>(newSymbols.length);
        int a = 0;
        int b = 0;
        while (a < this.symbols.length && b < newSymbols.length) {
            int cmp = this.symbols[a].compareTo(newSymbols[b]);
            if (cmp < 0) {
                removed.add(this.symbols[a++]);
                continue;
            }
            if (cmp > 0) {
                added.add(newSymbols[b++]);
                continue;
            }
            ++a;
            ++b;
        }
        while (a < this.symbols.length) {
            removed.add(this.symbols[a]);
            ++a;
        }
        while (b < newSymbols.length) {
            added.add(newSymbols[b]);
            ++b;
        }
        ArrayList<List<Quote>> freeQQueue = new ArrayList<List<Quote>>();
        ArrayList<List<Long>> freeTQueue = new ArrayList<List<Long>>();
        int ptr = 0;
        for (i = 0; i < this.plots.size(); ++i) {
            String plotName = this.plots.get((int)i).name;
            String symbol = plotName.substring(0, plotName.indexOf(45));
            if (removed.contains(symbol)) {
                PlotData removedData = this.plots.get(i);
                freeQQueue.add(removedData.data);
                freeTQueue.add(removedData.times);
                continue;
            }
            this.plots.set(ptr++, this.plots.get(i));
            this.plotIdxByName.put(this.plots.get((int)i).name, ptr - 1);
        }
        for (i = this.plots.size() - 1; i >= ptr; --i) {
            this.plots.remove(i);
        }
        for (Feed feed : this.feeds) {
            feed.removeSymbols(new ArrayList<String>(removed));
            for (String symbol : added) {
                List<Long> timeList;
                List<Quote> quoteList;
                if (freeQQueue.isEmpty()) {
                    quoteList = new SimpleMovingQueue(this.maxQuotesCapacity);
                    timeList = new SimpleMovingQueue(this.maxQuotesCapacity);
                } else {
                    quoteList = (List)freeQQueue.remove(freeQQueue.size() - 1);
                    timeList = (List)freeTQueue.remove(freeTQueue.size() - 1);
                    quoteList.clear();
                    timeList.clear();
                }
                String plotName = symbol + '-' + feed.name;
                this.plotIdxByName.put(plotName, this.plots.size());
                this.plots.add(new PlotData(plotName, quoteList, timeList));
            }
            feed.addSymbols(added);
        }
        this.tickChartRendererPanel.setAutoZoom(true);
        this.symbols = newSymbols;
    }

    private void setComponentSizes() {
        this.mpsLabel.setPreferredSize(new Dimension(70, 14));
        this.qpsLabel.setPreferredSize(new Dimension(70, 14));
        this.currentTimeLabel.setPreferredSize(new Dimension(100, 14));
    }

    private void createUIComponents() {
    }

    private void $$$setupUI$$$() {
        this.tabbedPane = new JTabbedPane();
        JPanel panel1 = new JPanel();
        panel1.setLayout(new GridBagLayout());
        this.tabbedPane.addTab("Default view", panel1);
        JPanel panel2 = new JPanel();
        panel2.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel1.add((Component)panel2, gbc);
        this.form = new JPanel();
        this.form.setLayout(new BorderLayout(0, 0));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel2.add((Component)this.form, gbc);
        JPanel panel3 = new JPanel();
        panel3.setLayout(new GridBagLayout());
        this.form.add((Component)panel3, "South");
        JPanel panel4 = new JPanel();
        panel4.setLayout(new GridBagLayout());
        panel4.setToolTipText("Feed address");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 6.0;
        gbc.anchor = 17;
        gbc.fill = 3;
        panel3.add((Component)panel4, gbc);
        JToolBar.Separator toolBar$Separator1 = new JToolBar.Separator();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        panel4.add((Component)toolBar$Separator1, gbc);
        this.currentTimeLabel = new JLabel();
        Font currentTimeLabelFont = this.$$$getFont$$$(null, 0, 10, this.currentTimeLabel.getFont());
        if (currentTimeLabelFont != null) {
            this.currentTimeLabel.setFont(currentTimeLabelFont);
        }
        this.currentTimeLabel.setText("");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 13;
        panel4.add((Component)this.currentTimeLabel, gbc);
        JSeparator separator1 = new JSeparator();
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.fill = 1;
        panel4.add((Component)separator1, gbc);
        JSeparator separator2 = new JSeparator();
        separator2.setOrientation(1);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.fill = 1;
        panel3.add((Component)separator2, gbc);
        JPanel panel5 = new JPanel();
        panel5.setLayout(new GridBagLayout());
        panel5.setToolTipText("Total events per second");
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        panel3.add((Component)panel5, gbc);
        this.mpsLabel = new JLabel();
        Font mpsLabelFont = this.$$$getFont$$$(null, 0, 10, this.mpsLabel.getFont());
        if (mpsLabelFont != null) {
            this.mpsLabel.setFont(mpsLabelFont);
        }
        this.mpsLabel.setHorizontalAlignment(0);
        this.mpsLabel.setHorizontalTextPosition(0);
        this.mpsLabel.setText("");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        panel5.add((Component)this.mpsLabel, gbc);
        JSeparator separator3 = new JSeparator();
        separator3.setOrientation(1);
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 0;
        gbc.fill = 1;
        panel3.add((Component)separator3, gbc);
        JPanel panel6 = new JPanel();
        panel6.setLayout(new GridBagLayout());
        panel6.setToolTipText("Quote events per second");
        gbc = new GridBagConstraints();
        gbc.gridx = 5;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        panel3.add((Component)panel6, gbc);
        this.qpsLabel = new JLabel();
        Font qpsLabelFont = this.$$$getFont$$$(null, 0, 10, this.qpsLabel.getFont());
        if (qpsLabelFont != null) {
            this.qpsLabel.setFont(qpsLabelFont);
        }
        this.qpsLabel.setHorizontalAlignment(0);
        this.qpsLabel.setHorizontalTextPosition(0);
        this.qpsLabel.setText("");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        panel6.add((Component)this.qpsLabel, gbc);
        this.endpointLabelsPanel = new JPanel();
        this.endpointLabelsPanel.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 1;
        panel3.add((Component)this.endpointLabelsPanel, gbc);
        JPanel panel7 = new JPanel();
        panel7.setLayout(new GridBagLayout());
        this.form.add((Component)panel7, "Center");
        JPanel panel8 = new JPanel();
        panel8.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel7.add((Component)panel8, gbc);
        this.tickChartPanel = new JPanel();
        this.tickChartPanel.setLayout(new GridBagLayout());
        this.tickChartPanel.setPreferredSize(new Dimension(800, 200));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel8.add((Component)this.tickChartPanel, gbc);
        JPanel panel9 = new JPanel();
        panel9.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        panel7.add((Component)panel9, gbc);
        this.addressToolbar = new JToolBar();
        this.addressToolbar.setBorderPainted(true);
        this.addressToolbar.setFloatable(false);
        Font addressToolbarFont = this.$$$getFont$$$(null, 0, 9, this.addressToolbar.getFont());
        if (addressToolbarFont != null) {
            this.addressToolbar.setFont(addressToolbarFont);
        }
        this.addressToolbar.setRollover(false);
        this.addressToolbar.putClientProperty("JToolBar.isRollover", Boolean.FALSE);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 11;
        gbc.fill = 2;
        panel9.add((Component)this.addressToolbar, gbc);
        this.playButton = new JButton();
        this.playButton.setEnabled(false);
        this.playButton.setIcon(new ImageIcon(this.getClass().getResource("/com/dxfeed/plotter/icons/play-icon.png")));
        this.playButton.setInheritsPopupMenu(true);
        this.playButton.setText("");
        this.playButton.setToolTipText("Connect/Replay");
        this.playButton.putClientProperty("hideActionText", Boolean.FALSE);
        this.addressToolbar.add(this.playButton);
        this.pauseButton = new JButton();
        this.pauseButton.setIcon(new ImageIcon(this.getClass().getResource("/com/dxfeed/plotter/icons/pause-icon.png")));
        this.pauseButton.setText("");
        this.pauseButton.setToolTipText("Pause");
        this.addressToolbar.add(this.pauseButton);
        JToolBar.Separator toolBar$Separator2 = new JToolBar.Separator();
        this.addressToolbar.add(toolBar$Separator2);
        JLabel label1 = new JLabel();
        Font label1Font = this.$$$getFont$$$(null, -1, -1, label1.getFont());
        if (label1Font != null) {
            label1.setFont(label1Font);
        }
        label1.setText("Subscribe to: ");
        this.addressToolbar.add(label1);
        this.subscribedSymbolsEdit = new JTextField();
        this.subscribedSymbolsEdit.setColumns(0);
        this.subscribedSymbolsEdit.setEditable(true);
        Font subscribedSymbolsEditFont = this.$$$getFont$$$(null, -1, -1, this.subscribedSymbolsEdit.getFont());
        if (subscribedSymbolsEditFont != null) {
            this.subscribedSymbolsEdit.setFont(subscribedSymbolsEditFont);
        }
        this.subscribedSymbolsEdit.setForeground(new Color(-1));
        this.subscribedSymbolsEdit.setToolTipText("Connection address");
        this.addressToolbar.add(this.subscribedSymbolsEdit);
    }

    private Font $$$getFont$$$(String fontName, int style, int size, Font currentFont) {
        Font testFont;
        if (currentFont == null) {
            return null;
        }
        String resultName = fontName == null ? currentFont.getName() : ((testFont = new Font(fontName, 0, 10)).canDisplay('a') && testFont.canDisplay('1') ? fontName : currentFont.getName());
        Font font = new Font(resultName, style >= 0 ? style : currentFont.getStyle(), size >= 0 ? size : currentFont.getSize());
        boolean isMac = System.getProperty("os.name", "").toLowerCase(Locale.ENGLISH).startsWith("mac");
        Font fontWithFallback = isMac ? new Font(font.getFamily(), font.getStyle(), font.getSize()) : new StyleContext().getFont(font.getFamily(), font.getStyle(), font.getSize());
        return fontWithFallback instanceof FontUIResource ? fontWithFallback : new FontUIResource(fontWithFallback);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.tabbedPane;
    }
}

