/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.plotter;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.Timer;

class LabelFlashSupport {
    private JLabel label;
    private Color baseColor;
    private Color darkerColor;
    private boolean darker = false;
    private final Timer timer = new Timer(200, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Color c = LabelFlashSupport.this.darker ? LabelFlashSupport.this.darkerColor : LabelFlashSupport.this.baseColor;
            LabelFlashSupport.this.darker = !LabelFlashSupport.this.darker;
            LabelFlashSupport.this.label.setForeground(c);
        }
    });

    LabelFlashSupport(JLabel label) {
        this.setLabel(label);
    }

    void updateColor(Color color) {
        this.label.setForeground(color);
        this.baseColor = color;
        this.darkerColor = color.darker();
    }

    void startFlashing() {
        this.timer.start();
    }

    void stopFlashing() {
        this.timer.stop();
    }

    boolean isFlashing() {
        return this.timer.isRunning();
    }

    private void setLabel(JLabel label) {
        this.label = label;
        this.updateColor(label.getForeground());
    }
}

