/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.plotter;

import java.util.AbstractQueue;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.Nonnull;

final class SimpleMovingQueue<E>
extends AbstractQueue<E>
implements List<E> {
    private final int mask;
    private final E[] elements;
    private int head;
    private int tail;

    SimpleMovingQueue(int requiredCapacity) {
        if ((requiredCapacity & requiredCapacity + 1) != 0) {
            requiredCapacity = Integer.highestOneBit(requiredCapacity) << 1;
        }
        this.mask = requiredCapacity - 1;
        this.elements = new Object[requiredCapacity];
    }

    @Override
    public Iterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    public int size() {
        return this.tail - this.head & this.mask;
    }

    @Override
    public void clear() {
        Arrays.fill(this.elements, null);
        this.tail = 0;
        this.head = 0;
    }

    @Override
    public boolean offer(E e) {
        if (this.size() == this.mask) {
            this.poll();
        }
        this.elements[this.tail] = e;
        this.tail = this.succ(this.tail);
        return true;
    }

    @Override
    public E poll() {
        if (this.head == this.tail) {
            return null;
        }
        E result = this.elements[this.head];
        this.head = this.succ(this.head);
        return result;
    }

    @Override
    public E peek() {
        if (this.head == this.tail) {
            return null;
        }
        return this.elements[this.head];
    }

    @Override
    public boolean addAll(int index, @Nonnull Collection<? extends E> c) {
        throw new UnsupportedOperationException("addAll(index, collection)");
    }

    @Override
    public E get(int index) {
        if (index >= this.size()) {
            throw new IndexOutOfBoundsException(index + " >= size = " + this.size());
        }
        return this.elements[this.tail - index - 1 & this.mask];
    }

    @Override
    public E set(int index, E element) {
        throw new UnsupportedOperationException("set(index, element)");
    }

    @Override
    public void add(int index, E element) {
        throw new UnsupportedOperationException("add(index, element)");
    }

    @Override
    public E remove(int index) {
        throw new UnsupportedOperationException("remove(index)");
    }

    @Override
    public int indexOf(Object o) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!Objects.equals(o, this.elements[this.head + i & this.mask])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        for (int i = this.size() - 1; i >= 0; --i) {
            if (!Objects.equals(o, this.elements[this.head + i & this.mask])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    @Nonnull
    public ListIterator<E> listIterator(final int index) {
        if (0 < index || index >= this.size()) {
            throw new IllegalArgumentException(index + " not in range [0, " + this.size() + ")");
        }
        return new ListIterator<E>(){
            int i;
            {
                this.i = index;
            }

            @Override
            public boolean hasNext() {
                return this.i < SimpleMovingQueue.this.size();
            }

            @Override
            public E next() {
                if (this.i >= SimpleMovingQueue.this.size()) {
                    throw new NoSuchElementException("next");
                }
                return SimpleMovingQueue.this.get(this.i++);
            }

            @Override
            public boolean hasPrevious() {
                return this.i > 0;
            }

            @Override
            public E previous() {
                if (this.i <= 0) {
                    throw new NoSuchElementException("previous");
                }
                return SimpleMovingQueue.this.get(--this.i);
            }

            @Override
            public int nextIndex() {
                return this.i;
            }

            @Override
            public int previousIndex() {
                return this.i - 1;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }

            @Override
            public void set(E e) {
                throw new UnsupportedOperationException("set");
            }

            @Override
            public void add(E e) {
                throw new UnsupportedOperationException("add");
            }
        };
    }

    @Override
    @Nonnull
    public List<E> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("subList(from, to)");
    }

    private int succ(int i) {
        return i + 1 & this.mask;
    }
}

