/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.sample.api;

import com.dxfeed.api.DXFeed;
import com.dxfeed.api.DXFeedSubscription;
import com.dxfeed.event.LastingEvent;
import com.dxfeed.event.market.MarketEvent;
import com.dxfeed.event.market.Quote;
import com.dxfeed.event.market.Trade;
import java.util.Collections;

public class DXFeedSample {
    public static void main(String[] args) throws InterruptedException {
        if (args.length != 1) {
            System.err.println("usage: DXFeedSample <symbol>");
            System.err.println("where: <symbol>  is security symbol (e.g. IBM, C, SPX etc.)");
            return;
        }
        String symbol = args[0];
        DXFeedSample.testQuoteListener(symbol);
        DXFeedSample.testQuoteAndTradeListener(symbol);
        DXFeedSample.testTradeSnapshots(symbol);
    }

    private static void testQuoteListener(String symbol) {
        DXFeedSubscription sub = DXFeed.getInstance().createSubscription(Quote.class);
        sub.addEventListener(quotes -> {
            for (Quote quote : quotes) {
                System.out.println("Mid = " + (quote.getBidPrice() + quote.getAskPrice()) / 2.0);
            }
        });
        sub.addSymbols(Collections.singletonList(symbol));
    }

    private static void testQuoteAndTradeListener(String symbol) {
        DXFeedSubscription sub = DXFeed.getInstance().createSubscription(new Class[]{Quote.class, Trade.class});
        sub.addEventListener(events -> {
            for (MarketEvent event : events) {
                System.out.println(event);
            }
        });
        sub.addSymbols(Collections.singletonList(symbol));
    }

    private static void testTradeSnapshots(String symbol) throws InterruptedException {
        DXFeed feed = DXFeed.getInstance();
        DXFeedSubscription sub = feed.createSubscription(Trade.class);
        sub.addSymbols(Collections.singletonList(symbol));
        while (true) {
            System.out.println(feed.getLastEvent((LastingEvent)new Trade(symbol)));
            Thread.sleep(1000L);
        }
    }
}

