/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.sample.ui.swing;

import com.devexperts.util.TimeUtil;
import com.dxfeed.api.DXEndpoint;
import com.dxfeed.api.DXFeed;
import com.dxfeed.api.DXFeedSubscription;
import com.dxfeed.event.market.MarketEvent;
import com.dxfeed.event.market.Quote;
import com.dxfeed.event.market.Trade;
import com.dxfeed.ondemand.OnDemandService;
import com.dxfeed.sample.ui.swing.SwingExecutor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.FileNotFoundException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.Executor;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;

public class DXFeedQuoteTableOnDemand {
    private static final List<String> SYMBOLS = DXFeedQuoteTableOnDemand.readSymbols("symbols_ondemand.txt");
    private static final int N = SYMBOLS.size();
    private static final Map<String, Integer> SYMBOL_IDS = new HashMap<String, Integer>();
    private JPanel form;
    private JTable quoteTable;
    private JButton replayFlashcrashButton;
    private JButton pauseButton;
    private JButton stopAndResumeButton;
    private JComboBox<String> speedComboBox;
    private JLabel replayTimeLabel;
    private JLabel statusLabel;
    private JButton stopAndClearButton;
    private final SimpleDateFormat timeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss 'EST'");
    private final DXEndpoint endpoint;
    private final OnDemandService onDemand;
    private final DXFeed feed;
    private final DXFeedSubscription<Quote> quoteSub;
    private final DXFeedSubscription<Trade> tradeSub;
    private final DefaultTableModel tableModel;
    private final Quote[] quotes;
    private final Trade[] trades;

    private static int getSymbolId(MarketEvent event) {
        return SYMBOL_IDS.get(event.getEventSymbol());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> readSymbols(String fileName) {
        Scanner in = new Scanner(new File(fileName));
        in.useDelimiter("[,\\s]+");
        try {
            ArrayList<String> result = new ArrayList<String>();
            while (in.hasNext()) {
                result.add(in.next());
            }
            ArrayList<String> arrayList = result;
            in.close();
            return arrayList;
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void main(String[] args) {
        DXEndpoint.getInstance().executor((Executor)new SwingExecutor(20));
        DXFeedQuoteTableOnDemand instance = new DXFeedQuoteTableOnDemand();
        SwingUtilities.invokeLater(instance::go);
    }

    public DXFeedQuoteTableOnDemand() {
        this.timeFormat.setTimeZone(TimeUtil.getTimeZone((String)"America/New_York"));
        this.endpoint = DXEndpoint.getInstance();
        this.onDemand = OnDemandService.getInstance((DXEndpoint)this.endpoint);
        this.feed = this.endpoint.getFeed();
        this.tableModel = new DefaultTableModel();
        this.quotes = new Quote[N];
        this.trades = new Trade[N];
        for (int i = 0; i < N; ++i) {
            this.quotes[i] = new Quote();
            this.trades[i] = new Trade();
        }
        this.quoteSub = this.feed.createSubscription(Quote.class);
        this.tradeSub = this.feed.createSubscription(Trade.class);
    }

    private void go() {
        this.setupUI();
        this.initTableModel();
        this.initListeners();
        this.createFrame();
    }

    private void createFrame() {
        JFrame frame = new JFrame("DXFeed Quote Table OnDemand");
        frame.add(this.form);
        frame.pack();
        frame.setLocationByPlatform(true);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    private void initListeners() {
        this.quoteSub.addEventListener(events -> {
            Iterator iterator = events.iterator();
            while (iterator.hasNext()) {
                Quote quote;
                this.quotes[DXFeedQuoteTableOnDemand.getSymbolId((MarketEvent)quote)] = quote = (Quote)iterator.next();
            }
            this.updateTableModel();
        });
        this.tradeSub.addEventListener(events -> {
            Iterator iterator = events.iterator();
            while (iterator.hasNext()) {
                Trade trade;
                this.trades[DXFeedQuoteTableOnDemand.getSymbolId((MarketEvent)trade)] = trade = (Trade)iterator.next();
            }
            this.updateTableModel();
        });
        this.quoteSub.addSymbols(SYMBOLS);
        this.tradeSub.addSymbols(SYMBOLS);
        this.endpoint.addStateChangeListener(evt -> this.statusLabel.setText("Status: " + evt.getNewValue()));
        this.onDemand.addPropertyChangeListener(evt -> {
            switch (evt.getPropertyName()) {
                case "replaySupported": {
                    this.replayFlashcrashButton.setEnabled((Boolean)evt.getNewValue());
                    break;
                }
                case "replay": {
                    this.updateReplay((Boolean)evt.getNewValue());
                    break;
                }
                case "speed": {
                    this.speedComboBox.setSelectedItem(evt.getNewValue().toString());
                    break;
                }
                case "time": {
                    this.replayTimeLabel.setText("Replay time: " + this.timeFormat.format(evt.getNewValue()));
                }
            }
        });
        this.updateReplay(false);
        this.replayFlashcrashButton.addActionListener(e -> this.replayFlashCrash());
        this.pauseButton.addActionListener(e -> this.onDemand.pause());
        this.stopAndResumeButton.addActionListener(e -> this.onDemand.stopAndResume());
        this.stopAndClearButton.addActionListener(e -> this.onDemand.stopAndClear());
        this.speedComboBox.addActionListener(e -> this.onDemand.setSpeed(Double.valueOf(this.speedComboBox.getSelectedItem().toString()).doubleValue()));
    }

    private void replayFlashCrash() {
        try {
            this.onDemand.replay(this.timeFormat.parse("2010-05-06 14:47:48 EST"), 1.0);
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void updateReplay(boolean replay) {
        this.pauseButton.setEnabled(replay);
        this.speedComboBox.setEnabled(replay);
        this.replayTimeLabel.setEnabled(replay);
    }

    private void initTableModel() {
        this.tableModel.addColumn("Symbol");
        this.tableModel.addColumn("Last");
        this.tableModel.addColumn("LastEx");
        this.tableModel.addColumn("Last Size");
        this.tableModel.addColumn("Bid");
        this.tableModel.addColumn("Ask");
        this.tableModel.addColumn("Bid Size");
        this.tableModel.addColumn("Ask Size");
        this.updateTableModel();
        this.quoteTable.setModel(this.tableModel);
    }

    private void updateTableModel() {
        this.tableModel.setNumRows(0);
        for (int i = 0; i < N; ++i) {
            Quote quote = this.quotes[i];
            Trade trade = this.trades[i];
            this.tableModel.addRow(new Object[]{SYMBOLS.get(i), trade.getPrice(), Character.valueOf(trade.getExchangeCode()), trade.getSizeAsDouble(), quote.getBidPrice(), quote.getAskPrice(), quote.getBidSizeAsDouble(), quote.getAskSizeAsDouble()});
        }
    }

    private void setupUI() {
        this.form = new JPanel();
        this.form.setLayout(new GridBagLayout());
        JPanel panel1 = new JPanel();
        panel1.setLayout(new BorderLayout(0, 0));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.form.add((Component)panel1, gbc);
        panel1.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null));
        JScrollPane scrollPane1 = new JScrollPane();
        panel1.add((Component)scrollPane1, "Center");
        this.quoteTable = new JTable();
        scrollPane1.setViewportView(this.quoteTable);
        JPanel panel2 = new JPanel();
        panel2.setLayout(new GridBagLayout());
        panel1.add((Component)panel2, "North");
        JPanel panel3 = new JPanel();
        panel3.setLayout(new FlowLayout(0, 5, 5));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        panel2.add((Component)panel3, gbc);
        this.replayFlashcrashButton = new JButton();
        this.replayFlashcrashButton.setText("Replay \"Flashcrash\" ");
        this.replayFlashcrashButton.setMnemonic('F');
        this.replayFlashcrashButton.setDisplayedMnemonicIndex(8);
        panel3.add(this.replayFlashcrashButton);
        this.stopAndResumeButton = new JButton();
        this.stopAndResumeButton.setEnabled(true);
        this.stopAndResumeButton.setText("Stop&Resume");
        this.stopAndResumeButton.setMnemonic('R');
        this.stopAndResumeButton.setDisplayedMnemonicIndex(5);
        panel3.add(this.stopAndResumeButton);
        this.stopAndClearButton = new JButton();
        this.stopAndClearButton.setText("Stop&Clear");
        this.stopAndClearButton.setMnemonic('C');
        this.stopAndClearButton.setDisplayedMnemonicIndex(5);
        panel3.add(this.stopAndClearButton);
        JLabel setSpeedLabel = new JLabel();
        setSpeedLabel.setText("Set speed");
        panel3.add(setSpeedLabel);
        this.speedComboBox = new JComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel1 = new DefaultComboBoxModel<String>();
        defaultComboBoxModel1.addElement("0.0");
        defaultComboBoxModel1.addElement("0.1");
        defaultComboBoxModel1.addElement("0.5");
        defaultComboBoxModel1.addElement("1.0");
        defaultComboBoxModel1.addElement("2.0");
        defaultComboBoxModel1.addElement("3.0");
        defaultComboBoxModel1.addElement("5.0");
        defaultComboBoxModel1.addElement("10.0");
        this.speedComboBox.setModel(defaultComboBoxModel1);
        panel3.add(this.speedComboBox);
        this.pauseButton = new JButton();
        this.pauseButton.setText("Pause");
        this.pauseButton.setMnemonic('P');
        this.pauseButton.setDisplayedMnemonicIndex(0);
        panel3.add(this.pauseButton);
        JPanel panel4 = new JPanel();
        panel4.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        panel2.add((Component)panel4, gbc);
        this.statusLabel = new JLabel();
        this.statusLabel.setText("Status");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        panel4.add((Component)this.statusLabel, gbc);
        this.replayTimeLabel = new JLabel();
        this.replayTimeLabel.setText("Replay time: 0");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        panel4.add((Component)this.replayTimeLabel, gbc);
    }

    static {
        for (int i = 0; i < N; ++i) {
            SYMBOL_IDS.put(SYMBOLS.get(i), i);
        }
    }
}

